# Summary

- [Introduction](./introduction.md)
- [Using the Wasmtime CLI](./cli.md)
  - [Installation](./cli-install.md)
  - [CLI Options](./cli-options.md)
  - [CLI Logging](./cli-logging.md)
  - [Cache Configuration](./cli-cache.md)
- [Using the Wasmtime API](./lang.md)
  - [Hello, world!](./examples-hello-world.md)
  - [Calculating the GCD](./examples-gcd.md)
  - [Using Linear Memory](./examples-memory.md)
  - [Linking Modules](./examples-linking.md)
  - [`anyref` Reference Type](./examples-anyref.md)
  - [`externref` Reference Type](./examples-externref.md)
  - [Multiple Memories](./examples-multimemory.md)
  - [Using Multi-Value](./examples-multi-value.md)
  - [Serializing Modules](./examples-serialize.md)
  - [Multithreaded Embedding](./examples-multithreaded-embedding.md)
  - [WASIp1](./examples-wasip1.md)
  - [WASIp2](./examples-wasip2.md)
    - [An Application with Plugins](./wasip2-plugins.md)
  - [Core Dumps](./examples-core-dumps.md)
  - [Memory Protection Keys](./examples-mpk.md)
  - [Async Host Functions](./examples-async.md)
  - [Debugging WebAssembly](./examples-debugging.md)
    - [Debugging with `gdb` and `lldb`](./examples-debugging-native-debugger.md)
    - [Debugging with Core Dumps](./examples-debugging-core-dumps.md)
  - [Profiling WebAssembly](./examples-profiling.md)
    - [Profiling with Perf](./examples-profiling-perf.md)
    - [Profiling with VTune](./examples-profiling-vtune.md)
    - [Profiling with `samply`](./examples-profiling-samply.md)
    - [Cross-platform Profiling](./examples-profiling-guest.md)
  - [Building a Minimal Embedding](./examples-minimal.md)
  - [Portable Interpretation](./examples-pulley.md)
  - [Pre-Compiling Wasm](./examples-pre-compiling-wasm.md)
  - [Fast Execution](./examples-fast-execution.md)
  - [Fast Instantiation](./examples-fast-instantiation.md)
  - [Fast Compilation](./examples-fast-compilation.md)
  - [Interrupting Execution](./examples-interrupting-wasm.md)
  - [Deterministic Execution](./examples-deterministic-wasm-execution.md)
  - [Checking Guests' Memory Accesses](./wmemcheck.md)
- [Stability](stability.md)
  - [Release Process](./stability-release.md)
  - [Tiers of support](./stability-tiers.md)
  - [Platform Support](./stability-platform-support.md)
  - [Wasm Proposals](./stability-wasm-proposals.md)
- [Security](security.md)
  - [Disclosure Policy](./security-disclosure.md)
  - [What is considered a security bug?](./security-what-is-considered-a-security-vulnerability.md)
  - [Vulnerability runbook](./security-vulnerability-runbook.md)
- [Contributing](contributing.md)
  - [Architecture](./contributing-architecture.md)
  - [Building](./contributing-building.md)
  - [Testing](./contributing-testing.md)
  - [Fuzzing](./contributing-fuzzing.md)
  - [CI](./contributing-ci.md)
  - [Reducing Test Cases](./contributing-reducing-test-cases.md)
  - [Cross Compiling](./contributing-cross-compiling.md)
  - [Coding Guidelines](./contributing-coding-guidelines.md)
  - [Development Process](./contributing-development-process.md)
  - [RFC Process](./contributing-rfc-process.md)
  - [Implementing Wasm Proposals](./contributing-implementing-wasm-proposals.md)
  - [Maintainer Guidelines](./contributing-maintainer-guidelines.md)
    - [Code Review](./contributing-code-review.md)
    - [Release Process](./contributing-release-process.md)
  - [Conditional Compilation](./contributing-conditional-compilation.md)
  - [Governance](./contributing-governance.md)
  - [Code of Conduct](./contributing-coc.md)
