@page CHANGES-2-8 Version 2.8
  
## Version 2.8 (Feb 22, 2022)

Changes from version 2.7 which are relevant for users:

- Changes leading to differences with previous versions
  - in \ref METAD and \ref PBMETAD, Gaussians are now stretched rather than truncated, making the energy a continuous function
    of the collective variable. See \issue{420}.
  - \ref sum_hills is now aware of stretched Gaussians. This change also fixes a minor bug in the set of grid points
    where Gaussians were different from zero that is still present up to version 2.7.
  - it is possible to restart from a HILLS file produced with PLUMED < 2.8, but Gaussians will be reinterpreted as stretched
    and a warning will be written in the log file. This might lead to small numerical changes in bias potentials.
  - in \ref METAD if possible the root walker in WALKERS_MPI will set the folder from which reading the GRID/HILLS file upon restart
  - in \ref METAD work is not calculated by default anymore, if needed it can be obtained using CALC_WORK
  - in \ref METAD an error will be thrown if, when restarting from FILE, the file is not found
  - the parser is more strict. Specifically, the explicitly crashes when a string cannot be parsed correctly.
    This was true only in a limited number of cases until v2.7 and might lead to errors when reading incorrectly
    formatted files. See \issue{717}.

- New actions:
  - \ref GHBFIX to compute generalized hydrogen-bond fixes

- New contributed module:
  - A new SASA module by Andrea Arsiccio
     - \ref SASA_HASEL
     - \ref SASA_LCPO
  - A new S2 contact model module by Omar Valsson 
     - \ref S2CM

- Fixed patches:
  - A bug in using GROMACS with expanded ensemble in combination with PLUMED has been fixed (version 2020.6 and 2021.4, see \issue{793}).
    Notice that this fix requires PLUMED 2.8, so it won't be backward compatible.

- Other improvements
  - in \ref METAD a new keyword NLIST has been added to use a neighbor list for bias evaluation, this should be faster than grids with many CVs
  - in \ref METAD there are more checks that a restart of WALKERS_MPI is working consistently among walkers
  - in \ref driver there is a flag `--restart` that can be used to enforce restart (similar to using \ref RESTART in the PLUMED input file).
  - Added configure option `--enable-cxx`. Can be used to select C++14 with `--enable-cxx=14`. Required to compile against libraries
    whose header files need C++14.

- Changes in the OPES module
  - new action \ref OPES_EXPANDED
  - various new actions of type \ref EXPANSION_CV to be used with \ref OPES_EXPANDED
  - new action \ref OPES_METAD_EXPLORE
  - new option EXTRA_BIAS in \ref OPES_METAD, to sample custom target distributions
  - new option EXCLUDED_REGION in \ref OPES_METAD, to define a region where no kernels are deposited

- Changes in the VES module
  - New localized basis functions: Wavelets (\ref BF_WAVELETS), Gaussians (\ref BF_GAUSSIANS), and cubic splines (\ref BF_CUBIC_B_SPLINES). In particular, symmetric wavelets (symlets) have shown the best performance and are recommended of the localized basis functions. Furthermore, symlets have been shown to perform better than delocalized Chebyshev and Legendre polynomials.  
  - New optimizer based on Adam (\ref OPT_ADAM). Still experimental, and restarting with it does not work yet. 
  - New optimizer based on classical Robbins Monro stochastic gradient descent (\ref OPT_ROBBINS_MONRO_SGD). Only included for reference and not recommended for usage in simulations. 
  - Fixed a bug in \ref VES_LINEAR_EXPANSION for multidimensional bias potential if one (or more) of the CVs is outside the range of the bias potential. Previously, there was a force acting on the CVs if this happened. Now, there is no biasing force acting on the CVs if one (or more) of the CVs is outside the bias potential range. 

- Changes in the DRR module
  - Added a new option MERGEHISTORYFILES to output a single history file instead of many .drrstate files.

- For developers:
  - The C++ interface now performs type checking (see https://github.com/plumed/plumed2/pull/653).
    This should require no change for MD codes that were calling PLUMED with correct arguments.
    Checks could be disabled at runtime with `export PLUMED_TYPESAFE_IGNORE=yes`.
  - Two new Fortran modules have been added. One of them provides explicit interfaces for the already available wrappers.
    With no change in calling code, just by including this module, one could perform runtime type/shape checking.
    In addition, a novel object oriented Fortran interface has been designed which allow to better manipulate
    PLUMED instances from Fortran.
    Both interfaces were written with a significant help from Balint Aradi.
  - The C interface (`plumed_cmd`) also performs type checking and allows overload-like syntax to pass
    additional size and shape information. This is obtained redefining `plumed_cmd` to a macro that calls the C++ interface,
    when using a C++ compiler, or using C11 `_Generic`, if the C compiler supports it.
    This feature is not supported if used a pre-C11 C compiler (pre-C++11 C++ compilers are ok instead).
  - `xxd` replaced by a awk script. This removed the build dependence on vim.
  - Lepton has been updated with OpenMM 7.6.0
  - Asmjit is now enabled by default on supported architectures.
  - Xdrfile library is now embedded and always available.
  - `--enable-rpath` now also includes the path where `libplumedKernel.so` is installed (see \issue{767}).

## Version 2.8.1 (Oct 21, 2022)

- Includes all fixes up to 2.7.5
- It is now possible to pass a mpi4py communicator from the Python interface.
  This is backported from master, see \issue{818} (thanks to Henrique Musseli Cezar).
- Fix in `--enable-rpath` (see \issue{807}).
- Updated gromacs patches
- Fixed gromacs patches (2020 and 2021) to solve \issue{829}.
- Fixed a few incorrect `const` conversions in `wrapper/Plumed.h`.

## Version 2.8.2 (Mar 13, 2023)

- Includes all fixes up to 2.7.6
- Fixed a regression introduced in v2.8.0 which would make multi-thread simulations,
  with a separate Plumed object in each thread, crash randomly
- Fixed a bug in \ref SAXS cv using recent versions of arrayfire
- Fixed a bug in the GROMACS 2022 patch when atoms reordering happens also without domain decompisition: needs patch to be reapplied
- Updated GROMACS patches to warn about the joint use of update gpu and plumed: needs patch to be reapplied 
- GROMACS patches for v2021 and v2022 have been updated to use -rerun with -plumed again: needs patch to be reapplied
- Fixed a few cases where plumed was aborting rather than throwing an exception
- Fixed `wrapper/Plumed.h` so that more compilers are covered (see \issue{897}).

## Version 2.8.3 (May 25, 2023)

- Fixed a numerical instability in \ref OPES_EXPANDED that could cause `-inf` to appear in the DELTAFS file when biasing large systems
- Small fixes in the test suite to make sure `plumed` is always invoked with `--no-mpi` when testing for features. This avoids
  problems that were appearing when testing with some specific versions of OpenMPI.

## Version 2.8.4 (Jun 3, 2024)

\plumednotmaintained

- Added the possibility to disable `RTLD_DEEPBIND` (see \issue{952}).
- Fixed a bug in `switchingfunction` mode `Q` thanks to @nm3787, (see #951)
- Improved error reporting in CUSTOM switching function: an error is thrown if one uses `x` and `x2` arguments simultaneously (reported by Olivier Languin-Cattoen).
- Fixed bug in diagonalization of fixed-sized matrices that could lead to segmentation faults in the following case: RMSD calculations with `TYPE=OPTIMAL`, same weights used for alignment and displacement, either the running frame or the reference frame is invariant for rotation (i.e., atoms are placed along a straight line). This was happening in [benchmark tests in version 2.10](https://github.com/plumed/plumed2/pull/1033#issuecomment-1976380245), and is very unlikely (but possible) in real simulations. In addition, the diagMatSym function on fixed size tensors was incorrectly modifying its argument matrix. By inspection of the places this was used (RMSD and Gyration), this should have no effect since a temporary matrix is built, diagonalized, and discarded in all those cases, but it has been fixed nonetheless.
- Removed a number of incorrect dependencies between modules
- Addressed numerical instabilities in the calculation of the derivative of the SwitchingFunction RATIONAL without simplification (where `NN!=2*MM`) around `d=R_0`.
- Fixed an error in checking array shapes in the interface. Arrays with shape (N,4) should not be accepted for positions or forces.
- Small fix in Python, where we do not assume anymore that strings are null terminated.
- Environment variables such as `PLUMED_INCLUDEDIR` and similar are sanitized before they are used for running commands.
- Fixed a bug leading to a crash when using python selectors (e.g., `@mda:` or `@mdt:`) and multiple MPI processes per replica.
- Fixed leaks in Subprocess, potentially givin problems with a large number (>250) of sequentially created plumed objects all of them using `@mda:` or `@mdt:` selectors.
- Quantum Espresso patches have been fixed for a bug leading to incorrect masses passed to PLUMED and for a missing string terminator.

