import { SlashCommandConfigurator } from './base.js';
const FILE_PATHS = {
    proposal: '.agent/workflows/openspec-proposal.md',
    apply: '.agent/workflows/openspec-apply.md',
    archive: '.agent/workflows/openspec-archive.md'
};
const DESCRIPTIONS = {
    proposal: 'Scaffold a new OpenSpec change and validate strictly.',
    apply: 'Implement an approved OpenSpec change and keep tasks in sync.',
    archive: 'Archive a deployed OpenSpec change and update specs.'
};
export class AntigravitySlashCommandConfigurator extends SlashCommandConfigurator {
    toolId = 'antigravity';
    isAvailable = true;
    getRelativePath(id) {
        return FILE_PATHS[id];
    }
    getFrontmatter(id) {
        const description = DESCRIPTIONS[id];
        return `---\ndescription: ${description}\n---`;
    }
}
//# sourceMappingURL=antigravity.js.map