/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_vec extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e0rabo";
        final String metaValue_hy = "armen";
        final String metaValue_ban = "balineze";
        final String metaValue_bug = "bugineze";
        final String metaValue_ccp = "ciakma";
        final String metaValue_doi = "dogri";
        final String metaValue_ka = "jeorjan";
        final String metaValue_el = "grego";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebr\u00e0ego";
        final String metaValue_jv = "javaneze";
        final String metaValue_ja = "japoneze";
        final String metaValue_km = "kmer";
        final String metaValue_ko = "corean";
        final String metaValue_lo = "lao";
        final String metaValue_la = "latin";
        final String metaValue_mak = "makasar";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malay\u00e0lam";
        final String metaValue_mn = "m\u00f3ngolo";
        final String metaValue_my = "birman";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_si = "singaleze";
        final String metaValue_su = "sundaneze";
        final String metaValue_syr = "sir\u00ecago";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugo";
        final String metaValue_th = "tailandeze";
        final String metaValue_bo = "tibetan";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "001", "mondo" },
            { "002", "\u00c0frega" },
            { "003", "M\u00e8rega de\u2019l nord" },
            { "005", "M\u00e8rega de\u2019l sud" },
            { "009", "Oseania" },
            { "011", "\u00c0frega osidentale" },
            { "013", "M\u00e8rega sentrale" },
            { "014", "\u00c0frega orientale" },
            { "015", "\u00c0frega setentrionale" },
            { "017", "\u00c0frega sentrale" },
            { "018", "\u00c0frega meridionale" },
            { "019", "M\u00e8reghe" },
            { "021", "M\u00e8rega setentrionale" },
            { "029", "Car\u00e0ibi" },
            { "030", "Azia orientale" },
            { "034", "Azia meridionale" },
            { "035", "Azia de\u2019l sudest" },
            { "039", "Europa meridionale" },
            { "053", "Australazia" },
            { "054", "Melanezia" },
            { "057", "Rejon microneziana" },
            { "061", "Polinezia" },
            { "142", "Azia" },
            { "143", "Azia sentrale" },
            { "145", "Azia osidentale" },
            { "150", "Europa" },
            { "151", "Europa orientale" },
            { "154", "Europa setentrionale" },
            { "155", "Europa osidentale" },
            { "202", "\u00c0frega subsahariana" },
            { "419", "M\u00e8rega Latina" },
            { "AC", "\u00cczola Asension" },
            { "AD", "Andora" },
            { "AE", "Emir\u00e0i \u00c0rabi Un\u00eci" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e0rtide" },
            { "AR", "Arjentina" },
            { "AS", "Sam\u00f2a meregane" },
            { "AT", "\u00c0ustria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00cczole Aland" },
            { "AZ", "Azerbaijan" },
            { "BA", "Boznia e Erzeg\u00f2vina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Beljo" },
            { "BF", "Burkina Fazo" },
            { "BG", "Bulgar\u00eca" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S. Bartolom\u00e8o" },
            { "BM", "Bermuda" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BQ", "Paezi Basi cara\u00ecbeghi" },
            { "BR", "Brazile" },
            { "BS", "Bahamas" },
            { "BT", "Butan" },
            { "BV", "\u00cczola Buvet" },
            { "BW", "Botzwana" },
            { "BY", "Belorusia" },
            { "BZ", "Belize" },
            { "CA", "C\u00e0nada" },
            { "CC", "\u00cczole Cocos (Keeling)" },
            { "CD", "Rep\u00f9blega Democr\u00e0tega de\u2019l Congo" },
            { "CF", "Rep\u00f9blega Sentrafregana" },
            { "CG", "Rep\u00f9blega de\u2019l Congo" },
            { "CH", "Zv\u00ecsara" },
            { "CI", "Costa d\u2019Avorio" },
            { "CK", "\u00cczole Cook" },
            { "CL", "Cile" },
            { "CM", "C\u00e0merun" },
            { "CN", "Sina" },
            { "CO", "Colonbia" },
            { "CP", "\u00cczola de Clipperton" },
            { "CQ", "Sarc" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cao Verdo" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "\u00cczola de Nadale" },
            { "CY", "Sipro" },
            { "CZ", "Cechia" },
            { "DE", "Jermania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Jibuti" },
            { "DK", "Danimarca" },
            { "DM", "Dom\u00e9nega" },
            { "DO", "Rep\u00f9blega Domenegana" },
            { "DZ", "Aljer\u00eca" },
            { "EA", "Ceuta e Melila" },
            { "EC", "\u00c8cuador" },
            { "EE", "Estonia" },
            { "EG", "Ejito" },
            { "EH", "Sahara Osidentale" },
            { "ER", "Eritr\u00e8a" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Union europ\u00e8a" },
            { "EZ", "Eurozona" },
            { "FI", "Finlanda" },
            { "FJ", "Fiji" },
            { "FK", "\u00cczole Malvine" },
            { "FM", "Micronezia" },
            { "FO", "\u00cczole F\u00e0roe" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Regno Un\u00eco" },
            { "GD", "Granada" },
            { "GE", "Jeorja" },
            { "GF", "Guyana franseze" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibiltera" },
            { "GL", "Groenlanda" },
            { "GM", "Ganbia" },
            { "GN", "Guin\u00e8a" },
            { "GP", "Guadalupa" },
            { "GQ", "Guin\u00e8a Ecuatoriale" },
            { "GR", "Grecia" },
            { "GS", "Georgia de\u2019l sud e Sandwich de\u2019l sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guin\u00e8a Bis\u00e0o" },
            { "GY", "Guyana" },
            { "HK", "RAS de Hong Kong" },
            { "HM", "\u00cczole Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croasia" },
            { "HT", "Haiti" },
            { "HU", "Ongar\u00eca" },
            { "IC", "\u00cczole Canarie" },
            { "ID", "Indonezia" },
            { "IE", "Irlanda" },
            { "IL", "Izraele" },
            { "IM", "\u00cczola de Man" },
            { "IN", "India" },
            { "IO", "Teritorio brit\u00e0nego de l\u2019Os\u00e8ano Indian" },
            { "IQ", "Irac" },
            { "IR", "Iran" },
            { "IS", "Izlanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jam\u00e0ega" },
            { "JO", "Jordania" },
            { "JP", "Japon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizistan" },
            { "KH", "Canboja" },
            { "KI", "Kiribati" },
            { "KM", "\u00cczole Comore" },
            { "KN", "S. Cristofer e Nevis" },
            { "KP", "Cor\u00e8a de\u2019l nord" },
            { "KR", "Cor\u00e8a de\u2019l sud" },
            { "KW", "Kuwait" },
            { "KY", "\u00cczole Caiman" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "L\u00ecbano" },
            { "LC", "S. Lus\u00eca" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lezoto" },
            { "LT", "Lituania" },
            { "LU", "Lusenburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Maroco" },
            { "MC", "M\u00f2naco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "S. Martin (Fransa)" },
            { "MG", "Madagascar" },
            { "MH", "\u00cczole Marshall" },
            { "MK", "Masedonia de\u2019l nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "RAS de Mac\u00e0o" },
            { "MP", "\u00cczole Mariane setentrionali" },
            { "MQ", "Martiniga" },
            { "MR", "Mauritania" },
            { "MS", "Montserat" },
            { "MT", "Malta" },
            { "MU", "\u00cczole Maurisio" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "M\u00e8sego" },
            { "MY", "Malezia" },
            { "MZ", "Mozanbigo" },
            { "NA", "Namibia" },
            { "NC", "Nova Caledonia" },
            { "NE", "Niger" },
            { "NF", "\u00cczola Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Paezi Basi" },
            { "NO", "Norveja" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelanda" },
            { "OM", "Oman" },
            { "PA", "P\u00e0nama" },
            { "PE", "Per\u00f9" },
            { "PF", "Polinezia franseze" },
            { "PG", "Papua Nova Guin\u00e8a" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "S. Piero e Michelon" },
            { "PN", "\u00cczole Pitcairn" },
            { "PR", "Portorico" },
            { "PS", "Teritori palestinezi" },
            { "PT", "Portogalo" },
            { "PW", "Pal\u00e0u" },
            { "PY", "Paragu\u00e0i" },
            { "QA", "Catar" },
            { "QO", "Oseania perif\u00e8rega" },
            { "RE", "\u00cczola Reunion" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saud\u00eca" },
            { "SB", "\u00cczole Salomon" },
            { "SC", "\u00cczole Seisel" },
            { "SD", "Sudan" },
            { "SE", "Zvesia" },
            { "SG", "Singapore" },
            { "SH", "\u00cczola S. \u00c8lena" },
            { "SI", "Zlovenia" },
            { "SJ", "Zv\u00e0lbard e Jan Mayen" },
            { "SK", "Zlovachia" },
            { "SL", "Siera Leon" },
            { "SM", "San Marin" },
            { "SN", "S\u00e8negal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sud Sudan" },
            { "ST", "S. Tomazo e Pr\u00ecnsipe" },
            { "SV", "El Salvador" },
            { "SX", "S. Martin (Paezi Basi)" },
            { "SY", "Siria" },
            { "SZ", "Esuatini" },
            { "TA", "Tristan de Cugna" },
            { "TC", "Turks e Caicos" },
            { "TD", "Ciad" },
            { "TF", "Teritori fransezi de\u2019l sud" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokel\u00e0u" },
            { "TL", "Timor Est" },
            { "TM", "Turkmenistan" },
            { "TN", "Tuniz\u00eca" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinid\u00e0 e Tabaco" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "\u00cczo\u0142e perif\u00e8reghe meregane" },
            { "UN", "Nasion Un\u00ece" },
            { "US", "Stadi Un\u00eci" },
            { "UY", "Urugu\u00e0i" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vategan" },
            { "VC", "S. Vincenso e Granadine" },
            { "VE", "Venesuela" },
            { "VG", "\u00cczole V\u00e8rjini brit\u00e0neghe" },
            { "VI", "\u00cczole V\u00e8rjini meregane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Sam\u00f2a" },
            { "XA", "Pseudo asenti" },
            { "XB", "Pseudo bidi" },
            { "XK", "K\u00f2sovo" },
            { "YE", "Yemen" },
            { "YT", "\u00cczole Maiote" },
            { "ZA", "Sud\u00e0frega" },
            { "ZM", "Zanbia" },
            { "ZW", "Zinbawe" },
            { "ZZ", "Rejon desconos\u00f9a" },
            { "ab", "abcazo" },
            { "af", "afregan" },
            { "ak", "akan" },
            { "am", "am\u00e0rego" },
            { "an", "aragoneze" },
            { "ar", metaValue_ar },
            { "as", "asameze" },
            { "av", "av\u00e0rego" },
            { "ay", "aimar" },
            { "az", "azerbaijan" },
            { "ba", "bashkir" },
            { "be", "beloruso" },
            { "bg", "b\u00f9lgaro" },
            { "bi", "bizlama" },
            { "bm", "banbara" },
            { "bn", "bangla" },
            { "bo", metaValue_bo },
            { "br", "br\u00e8tone" },
            { "bs", "bozn\u00ecago" },
            { "ca", "catalan" },
            { "ce", "cecen" },
            { "ch", "ciamoro" },
            { "co", "corso" },
            { "cs", "seco" },
            { "cu", "zlavo de cieza" },
            { "cv", "ciuvash" },
            { "cy", "galeze" },
            { "da", "daneze" },
            { "de", "todesco" },
            { "dv", "maldivian" },
            { "dz", "dzongka" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "ingleze" },
            { "eo", "esperanto" },
            { "es", "spagnolo" },
            { "et", "estonian" },
            { "eu", "basco" },
            { "fa", "persian" },
            { "ff", "fula" },
            { "fi", "filandeze" },
            { "fj", "fijan" },
            { "fo", "faroeze" },
            { "fr", "franseze" },
            { "fy", "fr\u00eczone osidentale" },
            { "ga", "irlandeze" },
            { "gd", "ga\u00e8lego scoseze" },
            { "gl", "galisian" },
            { "gn", "guaran\u00ec" },
            { "gu", metaValue_gu },
            { "gv", "maneze" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hr", "cro\u00e0" },
            { "ht", "haitian" },
            { "hu", "ongareze" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlengua" },
            { "id", "indonezian" },
            { "ig", "igbo" },
            { "ii", "yi de Sichuan" },
            { "io", "ido" },
            { "is", "izlandeze" },
            { "it", "italian" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "groelandeze" },
            { "km", metaValue_km },
            { "kn", "canareze" },
            { "ko", metaValue_ko },
            { "kr", "canuri" },
            { "ks", "cashmiri" },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "c\u00f2rnego" },
            { "ky", "kirghizo" },
            { "la", metaValue_la },
            { "lb", "lusenburgheze" },
            { "lg", "ganda" },
            { "li", "linburgheze" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituan" },
            { "lu", "luba katanga" },
            { "lv", "l\u00e8tone" },
            { "mg", "malgaso" },
            { "mh", "marshaleze" },
            { "mi", "maori" },
            { "mk", "mas\u00e8done" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "maleze" },
            { "mt", "malteze" },
            { "my", metaValue_my },
            { "na", "nauruan" },
            { "nb", "norvejeze bokmal" },
            { "nd", "ndebele de\u2019l nord" },
            { "ne", "nepaleze" },
            { "ng", "ndonga" },
            { "nl", "olandeze" },
            { "nn", "norvejeze nynorsk" },
            { "no", "norvejeze" },
            { "nr", "ndebele de\u2019l sud" },
            { "nv", "navajo" },
            { "ny", "chewa" },
            { "oc", "ositan" },
            { "om", "oromo" },
            { "or", "or\u00eca" },
            { "os", "os\u00e8tego" },
            { "pa", "punjabi" },
            { "pl", "polaco" },
            { "ps", "pashto" },
            { "pt", "portogheze" },
            { "qu", "cuechua" },
            { "rm", "romancio" },
            { "rn", "rundi" },
            { "ro", "romen" },
            { "ru", "ruso" },
            { "rw", "kiniarwanda" },
            { "sa", "s\u00e0nscrito" },
            { "sc", "sardo" },
            { "sd", "sindi" },
            { "se", "sami setentrionale" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "zlovaco" },
            { "sl", "zloven" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "s\u00f2malo" },
            { "sq", "albaneze" },
            { "sr", "serbo" },
            { "ss", "zwati" },
            { "st", "soto meridionale" },
            { "su", metaValue_su },
            { "sv", "zvedeze" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "t\u00e0jego" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "tk", "turcoman" },
            { "tn", "tswana" },
            { "to", "tongan" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "t\u00e0taro" },
            { "ty", "taitian" },
            { "ug", "uigur" },
            { "uk", "ucrain" },
            { "ur", "urdu" },
            { "uz", "uzbego" },
            { "ve", "venda" },
            { "vi", "vietnameze" },
            { "vo", "volap\u00fck" },
            { "wa", "valon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yidish" },
            { "yo", "yoruba" },
            { "zh", "sineze" },
            { "zu", "zulu" },
            { "ace", "acineze" },
            { "ada", "adangme" },
            { "ady", "adighe" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "ale", "aleutian" },
            { "alt", "alt\u00e0i meridionale" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "\u00e0rabo levantin" },
            { "arn", "mapudungun" },
            { "arp", "arap\u00e0o" },
            { "ars", "\u00e0rabo najdi" },
            { "asa", "asu" },
            { "ast", "asturian" },
            { "atj", "atikamec" },
            { "awa", "awadi" },
            { "ban", metaValue_ban },
            { "bas", "basa" },
            { "bem", "benba" },
            { "bez", "bena" },
            { "bgc", "harianvi" },
            { "bho", "bojpuri" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "brx", "bodo" },
            { "bug", metaValue_bug },
            { "byn", "blin" },
            { "cay", "cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebuan" },
            { "cgg", "ciga" },
            { "chk", "ciukeze" },
            { "chm", "mari" },
            { "cho", "ci\u00f2ctaw" },
            { "chp", "c\u00ecpejan" },
            { "chr", "cerokee" },
            { "chy", "ceyen" },
            { "ckb", "curdo sentrale" },
            { "clc", "c\u00eclcotin" },
            { "crg", "mecif" },
            { "crj", "cree sud orientale" },
            { "crk", "cree de le pianure" },
            { "crl", "cree nord orientale" },
            { "crm", "cree mose" },
            { "crr", "algonchin de la Carolina" },
            { "csw", "cree de le paludi" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", metaValue_doi },
            { "dsb", "baso sorabo" },
            { "dua", "duala" },
            { "dyo", "jola foni" },
            { "dzg", "dazaga" },
            { "ebu", "enbu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipin" },
            { "fon", "fon" },
            { "frc", "cadian" },
            { "frr", "fr\u00eczone setentrionale" },
            { "fur", "furlan" },
            { "gaa", "ga" },
            { "gez", "geez" },
            { "gil", "gilberteze" },
            { "gor", "gorontalo" },
            { "gsw", "todesco zv\u00ecsaro" },
            { "guz", "gusi" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "haw", "hawaian" },
            { "hax", "haida meridionale" },
            { "hil", "hiligheno" },
            { "hmn", "hmong" },
            { "hsb", "alto sorabo" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadeze osidentale" },
            { "ilo", "ilocan" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngonba" },
            { "jmc", "machame" },
            { "kab", "cabil" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kanba" },
            { "kbd", "cabardian" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "caoverdian" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "khq", "koyra cini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kinbundu" },
            { "kok", "konkani" },
            { "kpe", "kpele" },
            { "krc", "karaci\u00e0i balkar" },
            { "krl", "carelian" },
            { "kru", "kuruk" },
            { "ksb", "shanbala" },
            { "ksf", "bafia" },
            { "ksh", "colognian" },
            { "kum", "kumyk" },
            { "kwk", "Kwakwala" },
            { "lad", "ladin" },
            { "lag", "langi" },
            { "lez", "lezghian" },
            { "lij", "l\u00ecguro" },
            { "lil", "liluet" },
            { "lkt", "lacota" },
            { "lmo", "lonbardo" },
            { "lou", "cr\u00e8olo de la Luiziana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrionale" },
            { "lsm", "samia" },
            { "lua", "luba lulua" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luja" },
            { "mad", "madureze" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "mas", "mas\u00e0i" },
            { "mdf", "moksha" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "maurisian" },
            { "mgh", "mak\u00f9a" },
            { "mgo", "meta" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manipur" },
            { "moe", "inu aimun" },
            { "moh", "mohawk" },
            { "mos", "mosi" },
            { "mua", "mundang" },
            { "mul", "multilengua" },
            { "mus", "crek" },
            { "mwl", "mirandeze" },
            { "myv", "erzyen" },
            { "mzn", "mazandarani" },
            { "nap", "napoletan" },
            { "naq", "nama" },
            { "nds", "baso todesco" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niuean" },
            { "nmg", "kwazio" },
            { "nnh", "ngienbon" },
            { "nog", "nog\u00e0i" },
            { "nqo", metaValue_nqo },
            { "nso", "soto setentrionale" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwa nord osidentale" },
            { "ojc", "ojibwa sentrale" },
            { "ojs", "oji cree" },
            { "ojw", "ojibwa osidentale" },
            { "oka", "okanagan" },
            { "pag", "pangasinan" },
            { "pam", "panpanga" },
            { "pap", "papiamento" },
            { "pau", "palauan" },
            { "pcm", "pidgin nijerian" },
            { "pis", "pijin" },
            { "pqm", "malesita pasamacuody" },
            { "prg", "prusian" },
            { "raj", "rajastani" },
            { "rap", "rapanui" },
            { "rar", "rarotongan" },
            { "rhg", "roinga" },
            { "rif", "rifegno" },
            { "rof", "ronbo" },
            { "rup", "aromen" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakuto" },
            { "saq", "sanburu" },
            { "sat", "santali" },
            { "sba", "nganbay" },
            { "sbp", "sangu" },
            { "scn", "sisilian" },
            { "sco", "scoseze" },
            { "seh", "sena" },
            { "ses", "koyraboro seni" },
            { "shi", "tashelit" },
            { "shn", "shan" },
            { "slh", "lushootseed meridionale" },
            { "smn", "sami inarian" },
            { "sms", "sami skolt" },
            { "snk", "sonink\u00e9" },
            { "srn", "sranan tongo" },
            { "str", "salish streto" },
            { "suk", "sukuma" },
            { "swb", "comorian" },
            { "syr", metaValue_syr },
            { "tce", "tutchone meridionale" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "t\u00e9tum" },
            { "tgx", "tagish" },
            { "tht", "taltan" },
            { "tig", "tigr\u00e9" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "ttm", "tutchone setentrionale" },
            { "tum", "tunbuka" },
            { "tvl", "tuvaluan" },
            { "twq", "tasawac" },
            { "tyv", "tuvinian" },
            { "tzm", "tamazigh de l\u2019Atlante sentrale" },
            { "udm", "udmurto" },
            { "umb", "unbundu" },
            { "und", "lengua desconosc\u00f9a" },
            { "vai", metaValue_vai },
            { "vec", "veneto" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "wuu", "wu" },
            { "xal", "kalmik" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yenba" },
            { "yrl", "nengatu" },
            { "yue", "cantoneze" },
            { "zgh", "tamazight standard de\u2019l Maroco" },
            { "zun", "zuni" },
            { "zxx", "gnaun contegn\u00f9o lengu\u00ecstego" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Aghb", "albaneze cauc\u00e0zego" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "am\u00e0rego inperiale" },
            { "Armn", metaValue_hy },
            { "Avst", "av\u00e8stego" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamun" },
            { "Bass", "vah" },
            { "Batk", "batak" },
            { "Beng", "bengaleze" },
            { "Bhks", "baiksuki" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabaro abor\u00ecjeno canadeze unifeg\u00e0" },
            { "Cari", "cario" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Chrs", "corazmian" },
            { "Copt", "copto" },
            { "Cpmn", "sipro min\u00f2ego" },
            { "Cprt", "siprioto" },
            { "Cyrl", "sir\u00eclego" },
            { "Deva", "devan\u00e0gari" },
            { "Diak", "dives akuru" },
            { "Dogr", metaValue_doi },
            { "Dsrt", "deseret" },
            { "Dupl", "duployan stenograf\u00e0" },
            { "Egyp", "jerogl\u00ecfeghi ejisiani" },
            { "Elba", "elbasan" },
            { "Elym", "elim\u00e0ego" },
            { "Ethi", "eti\u00f2pego" },
            { "Geor", metaValue_ka },
            { "Glag", "glagol\u00ectego" },
            { "Gong", "gunjala" },
            { "Gonm", "gondi masaram" },
            { "Goth", "g\u00f2tego" },
            { "Gran", "granta" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuki" },
            { "Hanb", "han co bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "senpio" },
            { "Hant", "tradisionale" },
            { "Hatr", "hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "jerogl\u00ecfeghi anat\u00f2leghi" },
            { "Hmng", "pahaw hmong" },
            { "Hmnp", "niakeng puachu hmong" },
            { "Hrkt", "silabari japonezi" },
            { "Hung", "ongareze antigo" },
            { "Ital", "it\u00e0lego antigo" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katanaka" },
            { "Kawi", "kawi" },
            { "Khar", "karosti" },
            { "Khmr", metaValue_km },
            { "Khoj", "kojiki" },
            { "Kits", "kitan celo" },
            { "Knda", "kanada" },
            { "Kore", metaValue_ko },
            { "Kthi", "kaiti" },
            { "Lana", "lana" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "linbu" },
            { "Lina", "linear A" },
            { "Linb", "linear B" },
            { "Lisu", "fraser" },
            { "Lyci", "lisio" },
            { "Lydi", "lidio" },
            { "Mahj", "mahajan" },
            { "Maka", metaValue_mak },
            { "Mand", "mand\u00e0ego" },
            { "Mani", "manigh\u00e8o" },
            { "Marc", "marchen" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "mero\u00ectego corsivo" },
            { "Mero", "mero\u00ectego" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "mro" },
            { "Mtei", "meit\u00e9i" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Nagm", "nag mundari" },
            { "Nand", "nandinagari" },
            { "Narb", "\u00e0rabo antigo de\u2019l nord" },
            { "Nbat", "nabat\u00e8o" },
            { "Newa", "newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nushu" },
            { "Ogam", "ogam" },
            { "Olck", "ol ciki" },
            { "Orkh", "orcon" },
            { "Orya", "orija" },
            { "Osge", "osage" },
            { "Osma", "ozmania" },
            { "Ougr", "uigur antigo" },
            { "Palm", "palmiren" },
            { "Pauc", "pau cin hau" },
            { "Perm", "p\u00e8rmego antigo" },
            { "Phag", "pagspa" },
            { "Phli", "palavo de le iscrision" },
            { "Phlp", "palavo saltero" },
            { "Phnx", "feniso" },
            { "Plrd", "fon\u00e8tego de Pollard" },
            { "Prti", "parto de le iscrision" },
            { "Qaag", "zovghi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Runr", "r\u00f9nego" },
            { "Samr", "samaritan" },
            { "Sarb", "\u00e0rabo antigo de\u2019l sud" },
            { "Saur", "saurashtra" },
            { "Sgnw", "scritura de i segni" },
            { "Shaw", "shavian" },
            { "Shrd", "sharada" },
            { "Sidd", "sidam" },
            { "Sind", "kudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "sogdian" },
            { "Sogo", "sogdian antigo" },
            { "Sora", "sora sonpeng" },
            { "Soyo", "soyonbo" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lu senpio" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinag" },
            { "Tglg", "tagalog" },
            { "Thaa", "thana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tiruta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", "ugar\u00ectego" },
            { "Vaii", metaValue_vai },
            { "Vith", "beita kukju" },
            { "Wara", "warang siti" },
            { "Wcho", "wancho" },
            { "Xpeo", "persian antigo" },
            { "Xsux", "cugniforme sumero acadian" },
            { "Yezi", "yezidi" },
            { "Yiii", "yi" },
            { "Zanb", "zanabazar cuadr\u00e0" },
            { "Zinh", "redit\u00e0" },
            { "Zmth", "notasion matem\u00e0tega" },
            { "Zsye", "emoji" },
            { "Zsym", "s\u00ecnboli" },
            { "Zxxx", "miga scrito" },
            { "Zyyy", "comun" },
            { "Zzzz", "desconos\u00f9o" },
            { "de_AT", "todesco austr\u00ecago" },
            { "de_CH", "alto todesco zv\u00ecsaro" },
            { "en_AU", "ingleze australian" },
            { "en_CA", "ingleze canadeze" },
            { "en_GB", "ingleze brit\u00e0nego" },
            { "en_US", "ingleze meregan" },
            { "fa_AF", "dari" },
            { "fr_CA", "franseze canadeze" },
            { "fr_CH", "franseze zv\u00ecsaro" },
            { "nl_BE", "fiamingo" },
            { "pt_BR", "portogheze brazi\u0142ian" },
            { "pt_PT", "portogheze europ\u00e8o" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "swahili de\u2019l Congo" },
            { "%%1996", "ortograf\u00eca todesca de\u2019l 1996" },
            { "ar_001", "\u00e0rabo moderno standard" },
            { "key.cf", "Form\u00e0 moneda" },
            { "key.cu", "Moneda" },
            { "key.hc", "Sistema ore (12/24)" },
            { "key.lb", "Stile de cao de linea" },
            { "key.ms", "Sistema de mezurasion" },
            { "key.nu", "N\u00f9mari" },
            { "nds_NL", "s\u00e0sone baso" },
            { "%%ALUKU", "dialeto aluku" },
            { "%%BARLA", "dialeto barlavento de\u2019l caoverdian" },
            { "%%BOONT", "bontling" },
            { "%%KKCOR", "ortograf\u00eca comun" },
            { "%%NJIVA", "dialeto Gniva" },
            { "%%POSIX", "inform\u00e0tega" },
            { "%%RIGIK", "volapuk cl\u00e0sego" },
            { "%%DAJNKO", "alfabeto Dajnko" },
            { "%%FONIPA", "alfabeto fon\u00e8tego internasionale IPA" },
            { "%%ALALC97", "romanizasion ALA-LC, varsion 1997" },
            { "%%BALANKA", "dialeto balanka de l\u2019Anii" },
            { "%%BOHORIC", "alfabeto bohoric" },
            { "%%EMODENG", "ingleze moderno bonorivo" },
            { "%%HEPBURN", "romanizasion Hepburn" },
            { "%%1606NICT", "franseze mezo tardivo fin el 1606" },
            { "%%1694ACAD", "franseze moderno bonorivo" },
            { "%%1959ACAD", "acad\u00e8mego" },
            { "type.hc.h11", "Sistema a 12 ore (0\u201311)" },
            { "type.hc.h12", "Sistema a 12 ore (1\u201312)" },
            { "type.hc.h23", "Sistema a 24 ore (0\u201323)" },
            { "type.hc.h24", "Sistema a 12 ore (1\u201324)" },
            { "type.nu.arab", "N\u00f9mari in indo \u00e0rabo" },
            { "type.nu.armn", "N\u00f9mari in armen" },
            { "type.nu.beng", "N\u00f9mari in bengaleze" },
            { "type.nu.cakm", "N\u00f9mari in ciakma" },
            { "type.nu.deva", "N\u00f9mari in devan\u00e0gari" },
            { "type.nu.ethi", "N\u00f9mari in eti\u00f2pego" },
            { "type.nu.geor", "N\u00f9mari in jeorjan" },
            { "type.nu.grek", "N\u00f9mari in grego" },
            { "type.nu.gujr", "N\u00f9mari in gujarati" },
            { "type.nu.guru", "N\u00f9mari in gurmuki" },
            { "type.nu.hans", "N\u00f9mari in sineze senpio" },
            { "type.nu.hant", "N\u00f9mari in sineze tradisionale" },
            { "type.nu.hebr", "N\u00f9mari in ebr\u00e0ego" },
            { "type.nu.java", "N\u00f9mari in javaneze" },
            { "type.nu.jpan", "N\u00f9mari in japoneze" },
            { "type.nu.khmr", "N\u00f9mari in kmer" },
            { "type.nu.knda", "N\u00f9mari in kanada" },
            { "type.nu.laoo", "N\u00f9mari in lao" },
            { "type.nu.latn", "N\u00f9mari osidentali" },
            { "type.nu.mlym", "N\u00f9mari in malay\u00e0lam" },
            { "type.nu.mtei", "N\u00f9mari in meit\u00e9i" },
            { "type.nu.mymr", "N\u00f9mari in birman" },
            { "type.nu.olck", "N\u00f9mari in ol ciki" },
            { "type.nu.orya", "N\u00f9mari in orija" },
            { "type.nu.taml", "N\u00f9mari in tamil tradisionale" },
            { "type.nu.telu", "N\u00f9mari in telugo" },
            { "type.nu.thai", "N\u00f9mari in tailandeze" },
            { "type.nu.tibt", "N\u00f9mari tibetani" },
            { "type.nu.vaii", "N\u00f9mari in vai" },
            { "type.lb.loose", "Cao de linea opsionale" },
            { "type.nu.roman", "N\u00f9mari romani" },
            { "type.co.search", "Reserca jen\u00e8rega" },
            { "type.lb.normal", "Cao de linea normale" },
            { "type.lb.strict", "Cao de linea fors\u00e0" },
            { "type.ms.metric", "Sistema m\u00e8trego" },
            { "type.ca.iso8601", "calendaro ISO-8601" },
            { "type.cf.account", "Form\u00e0 moneda cont\u00e0bile" },
            { "type.nu.arabext", "N\u00f9mari estendesti in indo \u00e0rabo" },
            { "type.nu.armnlow", "N\u00f9mari min\u00f9scoli in armen" },
            { "type.nu.greklow", "N\u00f9mari min\u00f9scoli in grego" },
            { "type.nu.hanidec", "N\u00f9mari desimali in sineze" },
            { "type.nu.hansfin", "N\u00f9mari finansiari in sineze senpio" },
            { "type.nu.hantfin", "N\u00f9mari finansiari in sineze tradisionale" },
            { "type.nu.jpanfin", "N\u00f9mari finansiari in japoneze" },
            { "type.nu.tamldec", "N\u00f9mari in tamil" },
            { "type.cf.standard", "Form\u00e0 moneda standard" },
            { "type.co.standard", "\u00f2rdane standard" },
            { "type.ms.uksystem", "Sistema inperiale" },
            { "type.ms.ussystem", "Sistema meregan" },
            { "type.nu.fullwide", "N\u00f9mari a larghesa piena" },
            { "type.nu.romanlow", "N\u00f9mari min\u00f9scoli romani" },
            { "type.ca.gregorian", "calendaro gregorian" },
        };
        return data;
    }
}
