---
name: Feature requests and proposals
about: What to do if you have a feature request or proposal
title: ''
labels: Feature request
assignees: ''

---

<!---
Before submitting your proposal, read the https://github.com/idris-lang/Idris2/blob/master/CONTRIBUTING.md page , it should give you an idea of what kind of proposal is likely to be accepted. Additionally, you can talk about your idea on the idris community discord server https://discord.gg/UX68fDs2jc or on the mailing list. Also check that your idea hasn't already been proposed or isn't already being worked on, make use of the Github search feature, someone is sure to tell you if you participate in the mailing list or discord. There is a checklist to remind you to do this before submitting your proposal :)

If you are confident in your idea, please follow the following template to describe your proposal. Follow the directive for each section, you have some liberty to update the “Proposal” section to better match your idea but leave the rest unchanged to keep the format uniform.

We cannot guarantee your proposal will be implemented in a timely manner (or at all) given how few people work on Idris2. Similarly with comments, few people have the time to read through and ingest a complex proposal. Try to be as clear and concise as you can so that it’s easy for the community to understand and comment on your idea.

--->

- [ ] I have read [CONTRIBUTING.md](https://github.com/idris-lang/Idris2/blob/main/CONTRIBUTING.md).
- [ ] I have checked that there is no existing PR/issue about my proposal.

## Summary

<!---
Describe your proposal in slightly more detail than the title, it should be easy to understand and pique the interest of the reader.
--->

## Motivation

<!---
Explain why this change is necessary and why the existing solutions are unsuitable.
--->

## The proposal

<!---
Explain your solution in detail, provide examples and highlight breaking changes, if any. Expose as many examples are you need to properly showcase the solution and help readers build a mental model of how and why it would work. This section can benefit from additional subsections about different aspects of the design of your solution (typically how does your proposal fit in the type theory, or how it can benefit from linearity). By default, we have 2 subsections: Examples and Technical implementation but feel free to restructure them, if you want the examples inlined for example.
--->

### Examples

### Technical implementation

## Alternatives considered

<!---
Show the research you conducted and the other alternatives that could have also solved the problem. Explain why you picked the one you presented and attempt to answer all the questions you already know you’re going to get. It’s a good idea to look at other programming languages and see how they solved similar problems and see if their rationale can be ported to Idris or not.
--->

## Conclusion

<!---
End your proposal with why you expect the community to accept this proposal. This is a good time to also highlight future work, potential new research avenues and longer-term benefits.
--->
