// SPDX-FileCopyrightText: Copyright The Miniflux Authors. All rights reserved.
// SPDX-License-Identifier: Apache-2.0

/*
Package client implements a client library for the Miniflux REST API.

# Examples

This example fetches the list of users:

	import (
		miniflux "miniflux.app/v2/client"
	)

	client := miniflux.NewClient("https://api.example.org", "admin", "secret")
	users, err := client.Users()
	if err != nil {
		fmt.Println(err)
		return
	}
	fmt.Println(users, err)

This example discovers subscriptions on a website:

	subscriptions, err := client.Discover("https://example.org/")
	if err != nil {
		fmt.Println(err)
		return
	}
	fmt.Println(subscriptions)
*/
package client // import "miniflux.app/v2/client"
