/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.1.0
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the TestCostBreakdownApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &TestCostBreakdownApiModel{}

// TestCostBreakdownApiModel Breakdown details of the test cost.
type TestCostBreakdownApiModel struct {
	ProtocolVuh          ProtocolVuh `json:"protocol_vuh"`
	BrowserVuh           BrowserVuh  `json:"browser_vuh"`
	AdditionalProperties map[string]interface{}
}

type _TestCostBreakdownApiModel TestCostBreakdownApiModel

// NewTestCostBreakdownApiModel instantiates a new TestCostBreakdownApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTestCostBreakdownApiModel(protocolVuh ProtocolVuh, browserVuh BrowserVuh) *TestCostBreakdownApiModel {
	this := TestCostBreakdownApiModel{}
	this.ProtocolVuh = protocolVuh
	this.BrowserVuh = browserVuh
	return &this
}

// NewTestCostBreakdownApiModelWithDefaults instantiates a new TestCostBreakdownApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTestCostBreakdownApiModelWithDefaults() *TestCostBreakdownApiModel {
	this := TestCostBreakdownApiModel{}
	return &this
}

// GetProtocolVuh returns the ProtocolVuh field value
func (o *TestCostBreakdownApiModel) GetProtocolVuh() ProtocolVuh {
	if o == nil {
		var ret ProtocolVuh
		return ret
	}

	return o.ProtocolVuh
}

// GetProtocolVuhOk returns a tuple with the ProtocolVuh field value
// and a boolean to check if the value has been set.
func (o *TestCostBreakdownApiModel) GetProtocolVuhOk() (*ProtocolVuh, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ProtocolVuh, true
}

// SetProtocolVuh sets field value
func (o *TestCostBreakdownApiModel) SetProtocolVuh(v ProtocolVuh) {
	o.ProtocolVuh = v
}

// GetBrowserVuh returns the BrowserVuh field value
func (o *TestCostBreakdownApiModel) GetBrowserVuh() BrowserVuh {
	if o == nil {
		var ret BrowserVuh
		return ret
	}

	return o.BrowserVuh
}

// GetBrowserVuhOk returns a tuple with the BrowserVuh field value
// and a boolean to check if the value has been set.
func (o *TestCostBreakdownApiModel) GetBrowserVuhOk() (*BrowserVuh, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BrowserVuh, true
}

// SetBrowserVuh sets field value
func (o *TestCostBreakdownApiModel) SetBrowserVuh(v BrowserVuh) {
	o.BrowserVuh = v
}

func (o TestCostBreakdownApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o TestCostBreakdownApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["protocol_vuh"] = o.ProtocolVuh
	toSerialize["browser_vuh"] = o.BrowserVuh

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *TestCostBreakdownApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"protocol_vuh",
		"browser_vuh",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varTestCostBreakdownApiModel := _TestCostBreakdownApiModel{}

	err = json.Unmarshal(data, &varTestCostBreakdownApiModel)

	if err != nil {
		return err
	}

	*o = TestCostBreakdownApiModel(varTestCostBreakdownApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "protocol_vuh")
		delete(additionalProperties, "browser_vuh")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableTestCostBreakdownApiModel struct {
	value *TestCostBreakdownApiModel
	isSet bool
}

func (v NullableTestCostBreakdownApiModel) Get() *TestCostBreakdownApiModel {
	return v.value
}

func (v *NullableTestCostBreakdownApiModel) Set(val *TestCostBreakdownApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableTestCostBreakdownApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableTestCostBreakdownApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTestCostBreakdownApiModel(val *TestCostBreakdownApiModel) *NullableTestCostBreakdownApiModel {
	return &NullableTestCostBreakdownApiModel{value: val, isSet: true}
}

func (v NullableTestCostBreakdownApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTestCostBreakdownApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
