/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"

	"gopkg.in/validator.v2"
)

// OptionsCloud - Cloud-specific k6 options.
type OptionsCloud struct {
	CloudOptions *CloudOptions
}

// CloudOptionsAsOptionsCloud is a convenience function that returns CloudOptions wrapped in OptionsCloud
func CloudOptionsAsOptionsCloud(v *CloudOptions) OptionsCloud {
	return OptionsCloud{
		CloudOptions: v,
	}
}

// Unmarshal JSON data into one of the pointers in the struct
func (dst *OptionsCloud) UnmarshalJSON(data []byte) error {
	var err error
	// this object is nullable so check if the payload is null or empty string
	if string(data) == "" || string(data) == "{}" {
		return nil
	}

	match := 0
	// try to unmarshal data into CloudOptions
	err = newStrictDecoder(data).Decode(&dst.CloudOptions)
	if err == nil {
		jsonCloudOptions, _ := json.Marshal(dst.CloudOptions)
		if string(jsonCloudOptions) == "{}" { // empty struct
			dst.CloudOptions = nil
		} else {
			if err = validator.Validate(dst.CloudOptions); err != nil {
				dst.CloudOptions = nil
			} else {
				match++
			}
		}
	} else {
		dst.CloudOptions = nil
	}

	if match > 1 { // more than 1 match
		// reset to nil
		dst.CloudOptions = nil

		return fmt.Errorf("data matches more than one schema in oneOf(OptionsCloud)")
	} else if match == 1 {
		return nil // exactly one match
	} else { // no match
		return fmt.Errorf("data failed to match schemas in oneOf(OptionsCloud)")
	}
}

// Marshal data from the first non-nil pointers in the struct to JSON
func (src OptionsCloud) MarshalJSON() ([]byte, error) {
	if src.CloudOptions != nil {
		return json.Marshal(&src.CloudOptions)
	}

	return nil, nil // no data in oneOf schemas
}

// Get the actual instance
func (obj *OptionsCloud) GetActualInstance() interface{} {
	if obj == nil {
		return nil
	}
	if obj.CloudOptions != nil {
		return obj.CloudOptions
	}

	// all schemas are nil
	return nil
}

type NullableOptionsCloud struct {
	value *OptionsCloud
	isSet bool
}

func (v NullableOptionsCloud) Get() *OptionsCloud {
	return v.value
}

func (v *NullableOptionsCloud) Set(val *OptionsCloud) {
	v.value = val
	v.isSet = true
}

func (v NullableOptionsCloud) IsSet() bool {
	return v.isSet
}

func (v *NullableOptionsCloud) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableOptionsCloud(val *OptionsCloud) *NullableOptionsCloud {
	return &NullableOptionsCloud{value: val, isSet: true}
}

func (v NullableOptionsCloud) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableOptionsCloud) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
