/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the LoadZoneDistributionApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &LoadZoneDistributionApiModel{}

// LoadZoneDistributionApiModel Distribution details for a specific load zone.
type LoadZoneDistributionApiModel struct {
	// Percentage of the total load handled by this load zone.
	Percentage int32 `json:"percentage"`
	// List of nodes allocated to this load zone.
	Nodes                []NodeApiModel `json:"nodes"`
	AdditionalProperties map[string]interface{}
}

type _LoadZoneDistributionApiModel LoadZoneDistributionApiModel

// NewLoadZoneDistributionApiModel instantiates a new LoadZoneDistributionApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewLoadZoneDistributionApiModel(percentage int32, nodes []NodeApiModel) *LoadZoneDistributionApiModel {
	this := LoadZoneDistributionApiModel{}
	this.Percentage = percentage
	this.Nodes = nodes
	return &this
}

// NewLoadZoneDistributionApiModelWithDefaults instantiates a new LoadZoneDistributionApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewLoadZoneDistributionApiModelWithDefaults() *LoadZoneDistributionApiModel {
	this := LoadZoneDistributionApiModel{}
	return &this
}

// GetPercentage returns the Percentage field value
func (o *LoadZoneDistributionApiModel) GetPercentage() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Percentage
}

// GetPercentageOk returns a tuple with the Percentage field value
// and a boolean to check if the value has been set.
func (o *LoadZoneDistributionApiModel) GetPercentageOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Percentage, true
}

// SetPercentage sets field value
func (o *LoadZoneDistributionApiModel) SetPercentage(v int32) {
	o.Percentage = v
}

// GetNodes returns the Nodes field value
func (o *LoadZoneDistributionApiModel) GetNodes() []NodeApiModel {
	if o == nil {
		var ret []NodeApiModel
		return ret
	}

	return o.Nodes
}

// GetNodesOk returns a tuple with the Nodes field value
// and a boolean to check if the value has been set.
func (o *LoadZoneDistributionApiModel) GetNodesOk() ([]NodeApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return o.Nodes, true
}

// SetNodes sets field value
func (o *LoadZoneDistributionApiModel) SetNodes(v []NodeApiModel) {
	o.Nodes = v
}

func (o LoadZoneDistributionApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o LoadZoneDistributionApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["percentage"] = o.Percentage
	toSerialize["nodes"] = o.Nodes

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *LoadZoneDistributionApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"percentage",
		"nodes",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varLoadZoneDistributionApiModel := _LoadZoneDistributionApiModel{}

	err = json.Unmarshal(data, &varLoadZoneDistributionApiModel)

	if err != nil {
		return err
	}

	*o = LoadZoneDistributionApiModel(varLoadZoneDistributionApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "percentage")
		delete(additionalProperties, "nodes")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableLoadZoneDistributionApiModel struct {
	value *LoadZoneDistributionApiModel
	isSet bool
}

func (v NullableLoadZoneDistributionApiModel) Get() *LoadZoneDistributionApiModel {
	return v.value
}

func (v *NullableLoadZoneDistributionApiModel) Set(val *LoadZoneDistributionApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableLoadZoneDistributionApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableLoadZoneDistributionApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableLoadZoneDistributionApiModel(val *LoadZoneDistributionApiModel) *NullableLoadZoneDistributionApiModel {
	return &NullableLoadZoneDistributionApiModel{value: val, isSet: true}
}

func (v NullableLoadZoneDistributionApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableLoadZoneDistributionApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
