/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the AllowedProjectToUpdateApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AllowedProjectToUpdateApiModel{}

// AllowedProjectToUpdateApiModel struct for AllowedProjectToUpdateApiModel
type AllowedProjectToUpdateApiModel struct {
	// ID of the project.
	Id                   int32 `json:"id"`
	AdditionalProperties map[string]interface{}
}

type _AllowedProjectToUpdateApiModel AllowedProjectToUpdateApiModel

// NewAllowedProjectToUpdateApiModel instantiates a new AllowedProjectToUpdateApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAllowedProjectToUpdateApiModel(id int32) *AllowedProjectToUpdateApiModel {
	this := AllowedProjectToUpdateApiModel{}
	this.Id = id
	return &this
}

// NewAllowedProjectToUpdateApiModelWithDefaults instantiates a new AllowedProjectToUpdateApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAllowedProjectToUpdateApiModelWithDefaults() *AllowedProjectToUpdateApiModel {
	this := AllowedProjectToUpdateApiModel{}
	return &this
}

// GetId returns the Id field value
func (o *AllowedProjectToUpdateApiModel) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *AllowedProjectToUpdateApiModel) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *AllowedProjectToUpdateApiModel) SetId(v int32) {
	o.Id = v
}

func (o AllowedProjectToUpdateApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AllowedProjectToUpdateApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AllowedProjectToUpdateApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varAllowedProjectToUpdateApiModel := _AllowedProjectToUpdateApiModel{}

	err = json.Unmarshal(data, &varAllowedProjectToUpdateApiModel)

	if err != nil {
		return err
	}

	*o = AllowedProjectToUpdateApiModel(varAllowedProjectToUpdateApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAllowedProjectToUpdateApiModel struct {
	value *AllowedProjectToUpdateApiModel
	isSet bool
}

func (v NullableAllowedProjectToUpdateApiModel) Get() *AllowedProjectToUpdateApiModel {
	return v.value
}

func (v *NullableAllowedProjectToUpdateApiModel) Set(val *AllowedProjectToUpdateApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableAllowedProjectToUpdateApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableAllowedProjectToUpdateApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAllowedProjectToUpdateApiModel(val *AllowedProjectToUpdateApiModel) *NullableAllowedProjectToUpdateApiModel {
	return &NullableAllowedProjectToUpdateApiModel{value: val, isSet: true}
}

func (v NullableAllowedProjectToUpdateApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAllowedProjectToUpdateApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
