Feature: swapping a feature branch verbosely

  Background:
    Given a Git repo with origin
    And the branches
      | NAME     | TYPE    | PARENT   | LOCATIONS     |
      | branch-1 | feature | main     | local, origin |
      | branch-2 | feature | branch-1 | local, origin |
      | branch-3 | feature | branch-2 | local, origin |
    And the commits
      | BRANCH   | LOCATION      | MESSAGE     |
      | main     | local, origin | main commit |
      | branch-1 | local, origin | commit 1    |
      | branch-2 | local, origin | commit 2    |
      | branch-3 | local, origin | commit 3    |
    And Git setting "color.ui" is "always"
    And the current branch is "branch-2"
    When I run "git-town swap --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | git remote                                                                                                                                                                                                                                                                                                                                       |
      |          | git branch --show-current                                                                                                                                                                                                                                                                                                                        |
      | branch-2 | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | git log --merges --format=%H branch-1..branch-2                                                                                                                                                                                                                                                                                                  |
      |          | git log --merges --format=%H main..branch-1                                                                                                                                                                                                                                                                                                      |
      |          | git -c rebase.updateRefs=false rebase --onto main branch-1                                                                                                                                                                                                                                                                                       |
      |          | git rev-parse branch-2 origin/branch-2                                                                                                                                                                                                                                                                                                           |
      |          | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |          | git checkout branch-1                                                                                                                                                                                                                                                                                                                            |
      | branch-1 | git -c rebase.updateRefs=false rebase --onto branch-2 main                                                                                                                                                                                                                                                                                       |
      |          | git rev-parse branch-1 origin/branch-1                                                                                                                                                                                                                                                                                                           |
      |          | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |          | git checkout branch-3                                                                                                                                                                                                                                                                                                                            |
      | branch-3 | git -c rebase.updateRefs=false rebase --onto branch-1 {{ sha-initial 'commit 2' }}                                                                                                                                                                                                                                                               |
      |          | git rev-parse branch-3 origin/branch-3                                                                                                                                                                                                                                                                                                           |
      |          | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |          | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
      |          | git config git-town-branch.branch-2.parent main                                                                                                                                                                                                                                                                                                  |
      |          | git config git-town-branch.branch-1.parent branch-2                                                                                                                                                                                                                                                                                              |
      |          | git config git-town-branch.branch-3.parent branch-1                                                                                                                                                                                                                                                                                              |
      |          | git rev-parse --verify -q refs/heads/branch-3                                                                                                                                                                                                                                                                                                    |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 37 shell commands.
      """

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git remote                                                                                                                                                                                                                                                                                                                                       |
      |          | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | git config git-town-branch.branch-1.parent main                                                                                                                                                                                                                                                                                                  |
      |          | git config git-town-branch.branch-2.parent branch-1                                                                                                                                                                                                                                                                                              |
      |          | git config git-town-branch.branch-3.parent branch-2                                                                                                                                                                                                                                                                                              |
      | branch-2 | git checkout branch-1                                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | branch-1 | git reset --hard {{ sha 'commit 1' }}                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse branch-1 origin/branch-1                                                                                                                                                                                                                                                                                                           |
      |          | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |          | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | branch-2 | git reset --hard {{ sha 'commit 2' }}                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse branch-2 origin/branch-2                                                                                                                                                                                                                                                                                                           |
      |          | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |          | git checkout branch-3                                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | branch-3 | git reset --hard {{ sha 'commit 3' }}                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse branch-3 origin/branch-3                                                                                                                                                                                                                                                                                                           |
      |          | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |          | git rev-parse --verify -q refs/heads/branch-2                                                                                                                                                                                                                                                                                                    |
      |          | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
    And Git Town prints:
      """
      Ran 33 shell commands.
      """
