Feature: ship a parent branch and update proposals

  Background:
    Given a Git repo with origin
    And the origin is "git@github.com:git-town/git-town.git"
    And the branches
      | NAME   | TYPE    | PARENT | LOCATIONS     |
      | parent | feature | main   | local, origin |
      | child  | feature | parent | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE       |
      | parent | local, origin | parent commit |
      | child  | local, origin | child commit  |
    And the proposals
      | ID | SOURCE BRANCH | TARGET BRANCH | TITLE           | BODY        | URL                      |
      | 1  | parent        | main          | parent proposal | parent body | https://example.com/pr/1 |
      | 2  | child         | parent        | child proposal  | child body  | https://example.com/pr/2 |
    And Git setting "git-town.proposal-breadcrumb" is "branches"
    And Git setting "git-town.ship-strategy" is "squash-merge"
    And the current branch is "parent"
    When I run "git-town ship -m 'parent done'"
    And origin closes proposal #1

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                         |
      | parent | git fetch --prune --tags                                        |
      |        | Finding proposal from child into parent ... #2 (child proposal) |
      |        | git checkout main                                               |
      |        | Updating target branch of proposal #2 to main ... ok            |
      | main   | git merge --squash --ff parent                                  |
      |        | git commit -m "parent done"                                     |
      |        | git push                                                        |
      |        | git push origin :parent                                         |
      |        | git branch -D parent                                            |
      |        | Finding all proposals for child ... main                        |
      |        | Finding proposal from child into main ... #2 (child proposal)   |
      |        | Update body for #2 ... ok                                       |
      |        | Finding all proposals for parent ... main                       |
      |        | Update body for #1 ... ok                                       |
    And Git Town prints:
      """
      branch child is now a child of main
      """
    And this lineage exists now
      """
      main
        child
      """
    And these commits exist now
      | BRANCH | LOCATION      | MESSAGE      |
      | main   | local, origin | parent done  |
      | child  | local, origin | child commit |
    And the proposals are now
      """
      url: https://example.com/pr/2
      number: 2
      source: child
      target: main
      body:
        child body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/2 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->
      """

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                |
      | main   | git revert {{ sha 'parent done' }}                     |
      |        | git push                                               |
      |        | git branch parent {{ sha 'parent commit' }}            |
      |        | git push -u origin parent                              |
      |        | Updating target branch of proposal #2 to parent ... ok |
      |        | git checkout parent                                    |
      |        | Finding all proposals for child ... parent             |
      |        | Finding proposal from child into main ... none         |
      |        | Update body for #2 ... ok                              |
      |        | Finding all proposals for parent ... none              |
    And the initial branches and lineage exist now
    And these commits exist now
      | BRANCH | LOCATION      | MESSAGE              |
      | main   | local, origin | parent done          |
      |        |               | Revert "parent done" |
      | parent | local, origin | parent commit        |
      | child  | local, origin | child commit         |
    And the proposals are now
      """
      url: https://example.com/pr/2
      number: 2
      source: child
      target: parent
      body:
        child body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - child :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->
      """
