# v0.30 - Wiretap

![](./v0.30/banner.png)

Tapping into other shells for additional completions.

## Implicit Bridges

With `CARAPACE_BRIDGES` default bridges can be enabled for commands not provided by carapace.

```sh
set-env CARAPACE_BRIDGES 'zsh,fish,bash,inshellisense'
```

![](./v0.30/implicit-bridges.cast)

> Order defines the precedence (e.g. if zsh has a `git` completer it will be used instead of the one in fish).

## Explicit Bridges

Additionally to user specs `~/.config/carapace/bridges.yaml` provides a simpler configuration of bridges.

```yaml
gh: cobra
opentofu: complete
tsh: kingpin
```

![](./v0.30/explicit-bridges.cast)

> `bridges.yaml` has a higher precedence than [Implicit Bridges](#implicit-bridges) but lower than internal completers and specs.
> So disable an internal completer with [Excludes](#excludes) if you want to replace it with a bridge.

Currently available bridges:
- [argcomplete](https://github.com/kislyuk/argcomplete)
- [bash](https://www.gnu.org/software/bash/)
- [carapace](https://github.com/carapace-sh/carapace)
- [clap](https://github.com/clap-rs/clap)
- [click](https://github.com/pallets/click)
- [cobra](https://github.com/spf13/cobra)
- [complete](https://github.com/posener/complete)
- [fish](https://fishshell.com/)
- [inshellisense](https://github.com/microsoft/inshellisense)
- [kingpin](https://github.com/alecthomas/kingpin)
- [powershell](https://microsoft.com/powershell)
- [urfavecli](https://github.com/urfave/cli)
- [yargs](https://github.com/yargs/yargs)
- [zsh](https://www.zsh.org/)

> Bridging frameworks should be preferred to shells (e.g. zsh) as these generally work better and have less overhead.

## Excludes

With `CARAPACE_EXCLUDES` internal completers can be excluded.

![](./v0.30/excludes.cast)

## Explicit Parsing Mode

So far flag parsing was implicitly disabled for bridge macros in specs.
From now on this needs to be done explicitly.

```yaml
# yaml-language-server: $schema=https://carapace.sh/schemas/command.json
name: az
description: Azure Command-Line Interface
parsing: disabled
completion:
  positionalany: ["$carapace.bridge.Argcomplete([az])"]
```

- `interspersed` -  mixed flags and positional arguments (default)
- `non-interspersed` - flag parsing stopped after first positional argument
- `disabled` - flag parsing disabled
