#!/bin/sh -e

for pkg in $(git grep func\ | grep .go: | cut -d: -f1 | uniq | xargs -n1 dirname | uniq); do
    echo "+ generate $pkg/logger.gen.go"
    logname="assh."$(echo $pkg | tr / .)
    pkgname=$(basename $pkg)

    if [ "$pkg" = "api/node/graphql/models" ]; then
        logname="vendor.graphql.models"
    fi

    if grep "package main" $pkg/*.go >/dev/null 2>/dev/null; then
        pkgname="main"
    fi

    logname="$(echo $logname | sed 's/\.\././g;s/\.$//')"

    cat > $pkg/logger.gen.go <<EOF
// Code generated by moul.io/assh/contrib/generate-loggers.sh

package $pkgname

import "go.uber.org/zap"

func logger() *zap.Logger {
    return zap.L().Named("$logname")
}

EOF
done

set -x
goimports -w .
