!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeformats_uv
  use cubetools_parameters
  use cubetools_setup_types
  use cubedag_node_type
  use cubeformats_messaging
  use cubeformats_table
  !---------------------------------------------------------------------
  ! Support module for UV tables
  !---------------------------------------------------------------------
  !
  public :: uv_t
  public :: cubeformats_uv_register
  public :: cubeformats_uv_allocate
  private
  !
  type, extends(table_t) :: uv_t
    ! ...
  contains
    ! ...
  end type uv_t
  !
  type(cube_setup_t), pointer :: uv_setup => null()
  !
contains
  !
  subroutine cubeformats_uv_register(cubset,ftype,error)
    use cubedag_type
    !-------------------------------------------------------------------
    ! Register the type(uv_t) (and its allocation/deallocation
    ! subroutines) in the DAG.
    !-------------------------------------------------------------------
    type(cube_setup_t), target, intent(in)    :: cubset
    integer(kind=code_k),       intent(out)   :: ftype
    logical,                    intent(inout) :: error
    !
    call cubedag_type_register('UV','uv',  &
                               cubeformats_uvnode_allocate,  &
                               cubeformats_uvnode_deallocate,  &
                               ftype,error)
    if (error) return
    !
    ! Memorize the cube_setup_t
    uv_setup => cubset
  end subroutine cubeformats_uv_register
  !
  function cubeformats_uv_allocate(setup,error)
    use gkernel_interfaces
    use cubetools_setup_types
    !-------------------------------------------------------------------
    ! Allocate a new uv_t in memory and return a pointer to this
    ! allocation
    !-------------------------------------------------------------------
    type(uv_t), pointer :: cubeformats_uv_allocate
    type(cube_setup_t), intent(in)    :: setup
    logical,            intent(inout) :: error
    !
    integer(kind=4) :: ier
    character(len=*), parameter :: rname='ALLOCATE>NEW'
    !
    allocate(cubeformats_uv_allocate,stat=ier)
    if (failed_allocate(rname,'object',ier,error)) return
    call cubeformats_uv_allocate%init(setup,error)
    if (error)  return
    !
    ! Override the node_t methods with cube_t specific ones
    cubeformats_uv_allocate%ltype    => uv_ltype
    cubeformats_uv_allocate%memsize  => uv_memsize
    cubeformats_uv_allocate%disksize => uv_disksize
    cubeformats_uv_allocate%datasize => uv_datasize
  end function cubeformats_uv_allocate
  !
  subroutine cubeformats_uvnode_allocate(object,error)
    !-------------------------------------------------------------------
    ! Same as cubeformats_uv_allocate but return a cubedag_node_object_t
    ! pointer.
    ! ---
    ! Remark: while cubeformats_cube_allocate allows to use different
    ! cube_setup_t from one cube to another,
    ! cubeformats_cubenode_allocate uses a single (pre-registered)
    ! instance. We face this "problem" when the DAG reloads a snapshot
    ! by itself.
    !-------------------------------------------------------------------
    class(cubedag_node_object_t), pointer :: object
    logical, intent(inout) :: error
    !
    object => cubeformats_uv_allocate(uv_setup,error)
    if (error) return
  end subroutine cubeformats_uvnode_allocate
  !
  subroutine cubeformats_uvnode_deallocate(object,error)
    !-------------------------------------------------------------------
    ! Finalize and deallocate a 'uv_t' in memory
    !-------------------------------------------------------------------
    class(cubedag_node_object_t), pointer       :: object
    logical,                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='FORMATS>DEALLOCATE'
    !
    call cubeformats_message(seve%t,rname,'Welcome')
    !
    if (.not.associated(object)) then
      call cubeformats_message(seve%e,rname,'Internal error: object is not allocated')
      error = .true.
      return
    endif
    deallocate(object)  ! NB: deallocation is polymorphic: we are deallocating
                        ! a uv_t, which invokes implicitly its FINAL procedure
  end subroutine cubeformats_uvnode_deallocate
  !
  !---------------------------------------------------------------------
  !
  function uv_ltype(obj)
    use cubetools_axset_types
    character(len=2) :: uv_ltype
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (uv_t)
      uv_ltype = 'UV'
    class default
      uv_ltype = '??'
    end select
  end function uv_ltype

  function uv_memsize(obj)
    integer(kind=size_length) :: uv_memsize
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (uv_t)
      uv_memsize = obj%tuple%memsize()
    class default
      uv_memsize = 0
    end select
  end function uv_memsize

  function uv_disksize(obj)
    use cubedag_tuple
    integer(kind=size_length) :: uv_disksize
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (uv_t)
      uv_disksize = obj%node%tuple%disksizes()
    class default
      uv_disksize = 0
    end select
  end function uv_disksize

  function uv_datasize(obj)
    integer(kind=size_length) :: uv_datasize
    class(cubedag_node_object_t), intent(in) :: obj
    logical :: error
    select type (obj)
    type is (uv_t)
      error = .false.
      call obj%head%arr%datasize(uv_datasize,error)
    class default
      uv_datasize = 0
    end select
  end function uv_datasize
  !
end module cubeformats_uv
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
