import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from 'react';
import { Text, Box } from 'ink';
import { theme } from '../../semantic-colors.js';
import { SCREEN_READER_USER_PREFIX } from '../../textConstants.js';
import { isSlashCommand as checkIsSlashCommand } from '../../utils/commandUtils.js';
import { calculateTransformationsForLine, calculateTransformedLine, } from '../shared/text-buffer.js';
import { HalfLinePaddedBox } from '../shared/HalfLinePaddedBox.js';
import { DEFAULT_BACKGROUND_OPACITY } from '../../constants.js';
import { useConfig } from '../../contexts/ConfigContext.js';
export const UserMessage = ({ text, width }) => {
    const prefix = '> ';
    const prefixWidth = prefix.length;
    const isSlashCommand = checkIsSlashCommand(text);
    const config = useConfig();
    const useBackgroundColor = config.getUseBackgroundColor();
    const textColor = isSlashCommand ? theme.text.accent : theme.text.secondary;
    const displayText = useMemo(() => {
        if (!text)
            return text;
        return text
            .split('\n')
            .map((line) => {
            const transformations = calculateTransformationsForLine(line);
            // We pass a cursor position of [-1, -1] so that no transformations are expanded (e.g. images remain collapsed)
            const { transformedLine } = calculateTransformedLine(line, 0, // line index doesn't matter since cursor is [-1, -1]
            [-1, -1], transformations);
            return transformedLine;
        })
            .join('\n');
    }, [text]);
    return (_jsx(HalfLinePaddedBox, { backgroundBaseColor: theme.text.secondary, backgroundOpacity: DEFAULT_BACKGROUND_OPACITY, useBackgroundColor: useBackgroundColor, children: _jsxs(Box, { flexDirection: "row", paddingY: 0, marginY: useBackgroundColor ? 0 : 1, paddingX: useBackgroundColor ? 1 : 0, alignSelf: "flex-start", width: width, children: [_jsx(Box, { width: prefixWidth, flexShrink: 0, children: _jsx(Text, { color: theme.text.accent, "aria-label": SCREEN_READER_USER_PREFIX, children: prefix }) }), _jsx(Box, { flexGrow: 1, children: _jsx(Text, { wrap: "wrap", color: textColor, children: displayText }) })] }) }));
};
//# sourceMappingURL=UserMessage.js.map