/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
export declare const CSS_NAME_TO_HEX_MAP: Readonly<Record<string, string>>;
export declare const INK_SUPPORTED_NAMES: Set<string>;
/**
 * Checks if a color string is valid (hex, Ink-supported color name, or CSS color name).
 * This function uses the same validation logic as the Theme class's _resolveColor method
 * to ensure consistency between validation and resolution.
 * @param color The color string to validate.
 * @returns True if the color is valid.
 */
export declare function isValidColor(color: string): boolean;
/**
 * Resolves a CSS color value (name or hex) into an Ink-compatible color string.
 * @param colorValue The raw color string (e.g., 'blue', '#ff0000', 'darkkhaki').
 * @returns An Ink-compatible color string (hex or name), or undefined if not resolvable.
 */
export declare function resolveColor(colorValue: string): string | undefined;
/**
 * Returns a "safe" background color to use in low-color terminals if the
 * terminal background is a standard black or white.
 * Returns undefined if no safe background color is available for the given
 * terminal background.
 */
export declare function getSafeLowColorBackground(terminalBg: string): string | undefined;
export declare function interpolateColor(color1: string, color2: string, factor: number): string;
export declare function getThemeTypeFromBackgroundColor(backgroundColor: string | undefined): 'light' | 'dark' | undefined;
