/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.nio.BaseBufferReadbackStrategy;
import com.terracottatech.frs.io.nio.ChannelOpener;
import com.terracottatech.frs.io.nio.MarkerIndex;
import com.terracottatech.frs.io.nio.ReadbackStrategy;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinimalReadbackStrategy
extends BaseBufferReadbackStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadbackStrategy.class);
    private final MarkerIndex index;
    private final ReentrantReadWriteLock block;
    private final long firstKey;
    private long length = 0L;
    private final long start;
    private int position = Integer.MIN_VALUE;

    public MinimalReadbackStrategy(Direction dir, long first, FileChannel channel, BufferSource source, ChannelOpener opener) throws IOException {
        super(dir, channel, source, opener);
        this.firstKey = first;
        this.start = this.length = channel.position();
        this.index = new MarkerIndex(source);
        boolean sealed = this.createIndex();
        this.block = !sealed ? new ReentrantReadWriteLock() : null;
        this.position = dir == Direction.REVERSE ? this.index.size() : 0;
    }

    public MinimalReadbackStrategy(Direction dir, long first, FileChannel channel, BufferSource source) throws IOException {
        this(dir, first, channel, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long locate(long mark) throws IOException {
        if (mark > this.getMaximumMarker()) {
            return Long.MIN_VALUE;
        }
        if (mark < this.firstKey) {
            throw new AssertionError();
        }
        int low = 0;
        int high = this.index.size() - 1;
        int cur = 0;
        ByteBuffer buf = this.allocate(8);
        buf.mark();
        try {
            long retValue;
            long comp = -1L;
            long lowmark = -1L;
            while (comp != mark) {
                if (comp < mark) {
                    low = cur;
                    lowmark = comp;
                    cur = low + (high - low) / 2;
                } else {
                    high = cur;
                    cur = high - (high - low) / 2;
                }
                if (high - low <= 1) {
                    if (lowmark < 0L) {
                        buf.reset();
                        lowmark = this.readMark(low, buf);
                    }
                    if (mark <= lowmark) {
                        cur = low;
                        break;
                    }
                    cur = high;
                    break;
                }
                buf.reset();
                comp = this.readMark(cur, buf);
            }
            buf.reset();
            if (this.readMark(cur, buf) < mark) {
                throw new AssertionError();
            }
            buf.reset();
            if (cur > 0 && this.readMark(cur - 1, buf) > mark) {
                throw new AssertionError();
            }
            long l = retValue = cur == 0 ? this.start : this.index.position(cur - 1);
            if (retValue < 0L) {
                throw new AssertionError();
            }
            long l2 = retValue;
            return l2;
        }
        finally {
            this.free(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMark(int pos, ByteBuffer buf) throws IOException {
        ByteBuffer rsrc = buf;
        long marker = this.index.mark(pos);
        if (marker > 0L) {
            return marker;
        }
        if (rsrc == null) {
            rsrc = this.allocate(8);
        }
        try {
            this.readDirect(this.index.position(pos) - 12L, rsrc);
            marker = rsrc.getLong();
            this.index.cache(pos, marker);
            long l = marker;
            return l;
        }
        finally {
            if (buf == null) {
                this.free(rsrc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createIndex() throws IOException {
        ByteBuffer buffer;
        FileChannel channel = this.getChannel();
        long[] jumpList = null;
        long capacity = channel.size();
        if (capacity > 8192L) {
            ByteBuffer grab;
            long stretch;
            int jump;
            int num;
            buffer = this.allocate(8);
            try {
                this.readDirect(capacity - 8L, buffer);
                num = buffer.getInt();
                jump = buffer.getInt();
            }
            finally {
                this.free(buffer);
            }
            if (num >= 0 && SegmentHeaders.JUMP_LIST.validate(jump) && (stretch = (long)num * 4L + 8L + 4L) < capacity && (grab = this.allocate((int)stretch)) != null) {
                try {
                    this.readDirect(capacity - stretch, grab);
                    jumpList = this.readJumpList(grab);
                }
                finally {
                    this.free(grab);
                }
            }
        }
        if (jumpList == null) {
            return this.updateIndex();
        }
        this.index.append(jumpList);
        buffer = this.allocate(16);
        try {
            long lastKey = this.readMark(jumpList.length - 1, buffer);
            this.seal(true, lastKey);
        }
        finally {
            this.free(buffer);
        }
        this.length = channel.size();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateIndex() throws IOException {
        FileChannel channel = this.getChannel();
        if (this.length + 4L > channel.size()) {
            return this.isConsistent();
        }
        channel.position(this.length);
        ByteBuffer buffer = this.allocate(32);
        int b = buffer.position();
        int e = buffer.limit();
        int chunkStart = 0;
        long last = this.length;
        long currentPos = this.length;
        try {
            try {
                currentPos = this.readFullyFromPos(4, buffer, currentPos);
            }
            catch (IOException ioe) {
                System.out.println("bad length " + this.length + " " + channel.position() + " " + channel.size());
                throw ioe;
            }
            chunkStart = buffer.getInt();
            ArrayList<Long> list = new ArrayList<Long>();
            while (SegmentHeaders.CHUNK_START.validate(chunkStart)) {
                try {
                    currentPos = this.readFullyFromPos(8, buffer, currentPos);
                    long len = buffer.getLong();
                    currentPos += len;
                    currentPos = this.readFullyFromPos(20, buffer, currentPos);
                    if (len != buffer.getLong()) {
                        throw new IOException("chunk corruption - head and tail lengths do not match");
                    }
                    long marker = buffer.getLong();
                    list.add(currentPos);
                    if (!SegmentHeaders.FILE_CHUNK.validate(buffer.getInt())) {
                        throw new IOException("chunk corruption - file chunk magic is missing");
                    }
                    buffer.position(b).limit(e);
                    last = currentPos;
                    if (currentPos >= channel.size()) break;
                    currentPos = this.readFullyFromPos(4, buffer, currentPos);
                    chunkStart = buffer.getInt();
                }
                catch (IOException ioe) {
                    this.length = last;
                    break;
                }
            }
            this.index.append(list);
        }
        finally {
            this.free(buffer);
        }
        this.length = last;
        if (!this.isConsistent()) {
            long lastKey = this.readMark(this.index.size() - 1, null);
            this.seal(SegmentHeaders.CLOSE_FILE.validate(chunkStart), lastKey);
        }
        return this.isConsistent();
    }

    @Override
    public boolean hasMore(Direction dir) throws IOException {
        return dir == Direction.FORWARD ? this.position < this.index.size() : this.position > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk iterate(Direction dir) throws IOException {
        if (dir == Direction.REVERSE) {
            --this.position;
        }
        try {
            long begin = this.position == 0 ? this.start : this.index.position(this.position - 1);
            BaseBufferReadbackStrategy.VirtualChunk virtualChunk = new BaseBufferReadbackStrategy.VirtualChunk(begin, this.index.position(this.position) - begin - 20L);
            return virtualChunk;
        }
        finally {
            if (dir == Direction.FORWARD) {
                ++this.position;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk scan(long marker) throws IOException {
        Lock lock = null;
        try {
            long pos;
            if (!this.isConsistent()) {
                lock = this.block.readLock();
                lock.lock();
                while (marker > this.getMaximumMarker() && !this.isConsistent()) {
                    lock.unlock();
                    ReentrantReadWriteLock.WriteLock writer = this.block.writeLock();
                    try {
                        writer.lock();
                        this.updateIndex();
                    }
                    finally {
                        writer.unlock();
                        lock.lock();
                    }
                }
            }
            if ((pos = this.locate(marker)) < 0L) {
                Chunk chunk = null;
                return chunk;
            }
            BaseBufferReadbackStrategy.VirtualChunk virtualChunk = new BaseBufferReadbackStrategy.VirtualChunk(pos);
            return virtualChunk;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.index.close();
    }
}

