/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLABBufferSource
implements BufferSource {
    public static final int HEADERSZ = 4;
    private final int slabsize;
    private final int maxslabs;
    private SLAB[] list;
    private volatile int pointer = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(SLABBufferSource.class);
    private final AtomicInteger out = new AtomicInteger();

    public SLABBufferSource() {
        this(0x800000, 128);
    }

    public SLABBufferSource(int maxSize) {
        this(0x800000, maxSize / 0x800000);
    }

    public SLABBufferSource(int slabsize, int maxslabs) {
        this.slabsize = slabsize;
        if (maxslabs <= 0) {
            maxslabs = 1;
        }
        this.maxslabs = maxslabs;
        int startslabs = this.maxslabs / 4;
        if (startslabs == 0) {
            startslabs = this.maxslabs;
        }
        this.list = new SLAB[startslabs];
    }

    public int getSlabSize() {
        return this.slabsize;
    }

    public int getSize() {
        int total = 0;
        for (SLAB s : this.list) {
            if (s == null) continue;
            total += this.slabsize;
        }
        return total;
    }

    public int verify() {
        return this.out.get();
    }

    private int amountRemaining() {
        int total = 0;
        for (SLAB s : this.list) {
            if (s == null) continue;
            total += s.remaining();
        }
        return total;
    }

    private boolean isCapacityAvailable(int size) {
        int sizeToCheck = size + 4;
        for (SLAB s : this.list) {
            if (s != null) {
                if (s.remaining() < sizeToCheck) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private int count() {
        int total = 0;
        for (SLAB s : this.list) {
            if (s == null) continue;
            total += s.count();
        }
        return total;
    }

    private int point(int size) throws OutOfDirectMemoryException {
        boolean sweep = false;
        for (int x = this.pointer; x < this.list.length; ++x) {
            if (this.list[x] == null) {
                if (sweep) {
                    if (!this.installSlab(x)) {
                        sweep = false;
                        --x;
                        continue;
                    }
                } else {
                    sweep = true;
                    x = -1;
                    continue;
                }
            }
            if (this.list[x].reserve(size)) {
                if (this.list[this.pointer].remaining() < size) {
                    if (this.pointer != x) {
                        LOGGER.debug("POINTER: " + this.pointer + " " + x);
                    }
                    this.pointer = x;
                }
                return x;
            }
            if (x + 1 != this.list.length || sweep) continue;
            sweep = true;
            x = -1;
        }
        return this.expandRange() ? -1 : -2;
    }

    private synchronized boolean expandRange() {
        if (this.list.length == this.maxslabs) {
            return false;
        }
        int newsize = this.list.length * 2;
        if (newsize > this.maxslabs) {
            newsize = this.maxslabs;
        }
        this.list = Arrays.copyOf(this.list, newsize);
        return true;
    }

    private synchronized boolean installSlab(int position) throws OutOfDirectMemoryException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("allocating a new slab with " + this.amountRemaining());
        }
        if (this.list[position] == null) {
            this.list[position] = new SLAB(position, this.slabsize);
            return true;
        }
        return false;
    }

    @Override
    public ByteBuffer getBuffer(int size) {
        SLAB target = null;
        if (size > this.slabsize) {
            return null;
        }
        try {
            while (target == null) {
                int p = this.point(size);
                if (p >= 0) {
                    target = this.list[p];
                    if (target.getId() != p) {
                        throw new AssertionError((Object)"bad pointer");
                    }
                    this.out.incrementAndGet();
                    return target.allocateReserved(size);
                }
                if (p >= -1 || this.amountRemaining() >= this.slabsize && this.isCapacityAvailable(size)) continue;
                return null;
            }
        }
        catch (OutOfDirectMemoryException oome) {
            return null;
        }
        return null;
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
        int pos = buffer.getInt(0);
        if (pos < 0) {
            return;
        }
        if (pos >= this.list.length) {
            throw new AssertionError((Object)(pos + " " + buffer.capacity()));
        }
        SLAB parent = this.list[pos];
        if (parent.getId() != pos) {
            throw new AssertionError((Object)"bad pointer");
        }
        if (this.out.decrementAndGet() == 0 && this.count() == 0) {
            throw new AssertionError();
        }
        if (parent.release(buffer)) {
            // empty if block
        }
    }

    @Override
    public void reclaim() {
        for (SLAB b : this.list) {
            if (b == null) continue;
            b.clear();
        }
        this.out.set(0);
    }

    public String toString() {
        int x = 0;
        for (x = 0; x < this.list.length && this.list[x] != null; ++x) {
        }
        return "SLABBufferSource{slabsize=" + this.slabsize + ", maxslabs=" + this.maxslabs + ", list=" + x + ", pointer=" + this.pointer + ", out=" + this.out + '}';
    }

    private static class OutOfDirectMemoryException
    extends Exception {
        public OutOfDirectMemoryException(Throwable cause) {
            super(cause);
        }
    }

    private static class SLAB
    extends ReentrantLock {
        private int reserve = 0;
        private final int id;
        private int count = 0;
        private final ByteBuffer buffer;

        SLAB(int id, int slabsize) throws OutOfDirectMemoryException {
            try {
                this.buffer = ByteBuffer.allocateDirect(slabsize);
            }
            catch (OutOfMemoryError oome) {
                throw new OutOfDirectMemoryException(oome);
            }
            this.id = id;
        }

        public boolean reserve(int size) {
            size += 4;
            if (this.tryLock()) {
                try {
                    if (this.count == 0) {
                        this.buffer.clear();
                    }
                    if (this.buffer.remaining() - this.reserve - size >= 0) {
                        this.reserve += size;
                        LOGGER.debug("RESERVE WIN: " + this.id + "  " + size);
                        boolean bl = true;
                        return bl;
                    }
                    LOGGER.debug("RESERVE FAIL: no reserve " + this.id + "  " + this.count);
                }
                finally {
                    this.unlock();
                }
            } else {
                LOGGER.debug("RESERVE FAIL: unable to lock  " + this.id + "  " + this.count);
            }
            return false;
        }

        public boolean release(ByteBuffer buffer) {
            this.lock();
            try {
                if (buffer.getInt(0) != this.id) {
                    throw new AssertionError();
                }
                boolean bl = --this.count == 0;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer allocateReserved(int size) {
            size += 4;
            this.lock();
            try {
                if (this.count == 0) {
                    this.buffer.clear();
                }
                if (size <= this.reserve) {
                    this.reserve -= size;
                    this.buffer.limit(this.buffer.position() + size);
                    ByteBuffer child = this.buffer.slice();
                    this.buffer.position(this.buffer.limit()).limit(this.buffer.capacity());
                    child.putInt(this.id);
                    ++this.count;
                    ByteBuffer byteBuffer = child;
                    return byteBuffer;
                }
            }
            finally {
                this.unlock();
            }
            throw new RuntimeException("allocation not reserved first");
        }

        public void clear() {
            this.count = 0;
            this.reserve = 0;
            this.buffer.clear();
        }

        public int remaining() {
            return this.buffer.remaining() - this.reserve;
        }

        public int getId() {
            return this.id;
        }

        public int count() {
            return this.count;
        }
    }
}

