#[cfg(feature = "UI_Composition_Core")]
#[doc = "Required features: `\"UI_Composition_Core\"`"]
pub mod Core;
#[cfg(feature = "UI_Composition_Desktop")]
#[doc = "Required features: `\"UI_Composition_Desktop\"`"]
pub mod Desktop;
#[cfg(feature = "UI_Composition_Diagnostics")]
#[doc = "Required features: `\"UI_Composition_Diagnostics\"`"]
pub mod Diagnostics;
#[cfg(feature = "UI_Composition_Effects")]
#[doc = "Required features: `\"UI_Composition_Effects\"`"]
pub mod Effects;
#[cfg(feature = "UI_Composition_Interactions")]
#[doc = "Required features: `\"UI_Composition_Interactions\"`"]
pub mod Interactions;
#[cfg(feature = "UI_Composition_Scenes")]
#[doc = "Required features: `\"UI_Composition_Scenes\"`"]
pub mod Scenes;
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IAmbientLight(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IAmbientLight {
    type Vtable = IAmbientLight_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IAmbientLight {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa48130a1_b7c4_46f7_b9bf_daf43a44e6ee);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAmbientLight_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IAmbientLight2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IAmbientLight2 {
    type Vtable = IAmbientLight2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IAmbientLight2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3b64a6bf_5f97_4c94_86e5_042dd386b27d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAmbientLight2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Intensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetIntensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IAnimationController(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IAnimationController {
    type Vtable = IAnimationController_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IAnimationController {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc934efd2_0722_4f5f_a4e2_9510f3d43bf7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAnimationController_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub PlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetPlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Progress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub ProgressBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationControllerProgressBehavior) -> ::windows_core::HRESULT,
    pub SetProgressBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationControllerProgressBehavior) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IAnimationControllerStatics(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IAnimationControllerStatics {
    type Vtable = IAnimationControllerStatics_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IAnimationControllerStatics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe71164df_651b_4800_b9e5_6a3bcfed3365);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAnimationControllerStatics_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub MaxPlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub MinPlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IAnimationObject(::windows_core::IUnknown);
impl IAnimationObject {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
}
::windows_core::imp::interface_hierarchy!(IAnimationObject, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::RuntimeType for IAnimationObject {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"{e7141e0a-04b8-4fc5-a4dc-195392e57807}");
}
unsafe impl ::windows_core::Interface for IAnimationObject {
    type Vtable = IAnimationObject_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IAnimationObject {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe7141e0a_04b8_4fc5_a4dc_195392e57807);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAnimationObject_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub PopulatePropertyInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, propertyinfo: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IAnimationPropertyInfo(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IAnimationPropertyInfo {
    type Vtable = IAnimationPropertyInfo_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IAnimationPropertyInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf4716f05_ed77_4e3c_b328_5c3985b3738f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAnimationPropertyInfo_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub AccessMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationPropertyAccessMode) -> ::windows_core::HRESULT,
    pub SetAccessMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationPropertyAccessMode) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IAnimationPropertyInfo2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IAnimationPropertyInfo2 {
    type Vtable = IAnimationPropertyInfo2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IAnimationPropertyInfo2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x591720b4_7472_5218_8b39_dffe615ae6da);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAnimationPropertyInfo2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub GetResolvedCompositionObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetResolvedCompositionObjectProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IBackEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IBackEasingFunction {
    type Vtable = IBackEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IBackEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb8560da4_5e3c_545d_b263_7987a2bd27cb);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBackEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEasingFunctionMode) -> ::windows_core::HRESULT,
    pub Amplitude: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IBooleanKeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IBooleanKeyFrameAnimation {
    type Vtable = IBooleanKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IBooleanKeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x95e23a08_d1f4_4972_9770_3efe68d82e14);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBooleanKeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: bool) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IBounceEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IBounceEasingFunction {
    type Vtable = IBounceEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IBounceEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe7fdb44b_aad5_5174_9421_eef8b75a6a43);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBounceEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEasingFunctionMode) -> ::windows_core::HRESULT,
    pub Bounces: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub Bounciness: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IBounceScalarNaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IBounceScalarNaturalMotionAnimation {
    type Vtable = IBounceScalarNaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IBounceScalarNaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbaa30dcc_a633_4618_9b06_7f7c72c87cff);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBounceScalarNaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Acceleration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetAcceleration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Restitution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRestitution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IBounceVector2NaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IBounceVector2NaturalMotionAnimation {
    type Vtable = IBounceVector2NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IBounceVector2NaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xda344196_2154_4b3c_88aa_47361204eccd);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBounceVector2NaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Acceleration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetAcceleration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Restitution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRestitution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IBounceVector3NaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IBounceVector3NaturalMotionAnimation {
    type Vtable = IBounceVector3NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IBounceVector3NaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x47dabc31_10d3_4518_86f1_09caf742d113);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBounceVector3NaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Acceleration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetAcceleration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Restitution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRestitution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICircleEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICircleEasingFunction {
    type Vtable = ICircleEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICircleEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1e07222a_6f82_5a28_8748_2e92fc46ee2b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICircleEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEasingFunctionMode) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IColorKeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IColorKeyFrameAnimation {
    type Vtable = IColorKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IColorKeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x93adb5e9_8e05_4593_84a3_dca152781e56);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColorKeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub InterpolationColorSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionColorSpace) -> ::windows_core::HRESULT,
    pub SetInterpolationColorSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionColorSpace) -> ::windows_core::HRESULT,
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::Color) -> ::windows_core::HRESULT,
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::Color, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionAnimation {
    type Vtable = ICompositionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x464c4c2c_1caa_4061_9b40_e13fde1503ca);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub ClearAllParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ClearParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub SetColorParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::Color) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetMatrix3x2Parameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetMatrix3x2Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetMatrix4x4Parameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetMatrix4x4Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetQuaternionParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetQuaternionParameter: usize,
    pub SetReferenceParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, compositionobject: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetScalarParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetVector2Parameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetVector2Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetVector3Parameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetVector3Parameter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetVector4Parameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetVector4Parameter: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionAnimation2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionAnimation2 {
    type Vtable = ICompositionAnimation2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionAnimation2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x369b603e_a80f_4948_93e3_ed23fb38c6cb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionAnimation2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub SetBooleanParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: bool) -> ::windows_core::HRESULT,
    pub Target: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub SetTarget: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionAnimation3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionAnimation3 {
    type Vtable = ICompositionAnimation3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionAnimation3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd51e030d_7da4_4bd7_bc2d_f4517529f43a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionAnimation3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Collections")]
    pub InitialValueExpressions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    InitialValueExpressions: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionAnimation4(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionAnimation4 {
    type Vtable = ICompositionAnimation4_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionAnimation4 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x770137be_76bc_4e23_bfed_fe9cc20f6ec9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionAnimation4_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub SetExpressionReferenceParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, parametername: ::std::mem::MaybeUninit<::windows_core::HSTRING>, source: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionAnimationBase(::windows_core::IUnknown);
impl ICompositionAnimationBase {}
::windows_core::imp::interface_hierarchy!(ICompositionAnimationBase, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::RuntimeType for ICompositionAnimationBase {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"{1c2c2999-e818-48d3-a6dd-d78c82f8ace9}");
}
unsafe impl ::windows_core::Interface for ICompositionAnimationBase {
    type Vtable = ICompositionAnimationBase_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionAnimationBase {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1c2c2999_e818_48d3_a6dd_d78c82f8ace9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionAnimationBase_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionAnimationFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionAnimationFactory {
    type Vtable = ICompositionAnimationFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionAnimationFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x10f6c4fb_6e51_4c25_bbd3_586a9bec3ef4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionAnimationFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionAnimationGroup(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionAnimationGroup {
    type Vtable = ICompositionAnimationGroup_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionAnimationGroup {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5e7cc90c_cd14_4e07_8a55_c72527aabdac);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionAnimationGroup_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionBackdropBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionBackdropBrush {
    type Vtable = ICompositionBackdropBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionBackdropBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc5acae58_3898_499e_8d7f_224e91286a5d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionBackdropBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionBatchCompletedEventArgs(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionBatchCompletedEventArgs {
    type Vtable = ICompositionBatchCompletedEventArgs_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionBatchCompletedEventArgs {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0d00dad0_9464_450a_a562_2e2698b0a812);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionBatchCompletedEventArgs_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionBrush {
    type Vtable = ICompositionBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xab0d7608_30c0_40e9_b568_b60a6bd1fb46);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionBrushFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionBrushFactory {
    type Vtable = ICompositionBrushFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionBrushFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xda53fb4c_4650_47c4_ad76_765379607ed6);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionBrushFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionCapabilities(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionCapabilities {
    type Vtable = ICompositionCapabilities_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionCapabilities {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8253353e_b517_48bc_b1e8_4b3561a2e181);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionCapabilities_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub AreEffectsSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub AreEffectsFast: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub Changed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handler: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Changed: usize,
    #[cfg(feature = "Foundation")]
    pub RemoveChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    RemoveChanged: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionCapabilitiesStatics(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionCapabilitiesStatics {
    type Vtable = ICompositionCapabilitiesStatics_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionCapabilitiesStatics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf7b7a86e_6416_49e5_8ddf_afe949e20562);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionCapabilitiesStatics_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub GetForCurrentView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionClip(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionClip {
    type Vtable = ICompositionClip_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionClip {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1ccd2a52_cfc7_4ace_9983_146bb8eb6a3c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionClip_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionClip2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionClip2 {
    type Vtable = ICompositionClip2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionClip2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5893e069_3516_40e1_89e0_5ba924927235);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionClip2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub AnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    AnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetAnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetAnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub CenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub RotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Scale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Scale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetScale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TransformMatrix: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransformMatrix: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionClipFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionClipFactory {
    type Vtable = ICompositionClipFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionClipFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb9484caf_20c7_4aed_ac4a_9c78ba1302cf);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionClipFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionColorBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionColorBrush {
    type Vtable = ICompositionColorBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionColorBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x2b264c5e_bf35_4831_8642_cf70c20fff2f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionColorBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionColorGradientStop(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionColorGradientStop {
    type Vtable = ICompositionColorGradientStop_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionColorGradientStop {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6f00ca92_c801_4e41_9a8f_a53e20f57778);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionColorGradientStop_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionColorGradientStopCollection(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionColorGradientStopCollection {
    type Vtable = ICompositionColorGradientStopCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionColorGradientStopCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9f1d20ec_7b04_4b1d_90bc_9fa32c0cfd26);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionColorGradientStopCollection_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionCommitBatch(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionCommitBatch {
    type Vtable = ICompositionCommitBatch_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionCommitBatch {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0d00dad0_ca07_4400_8c8e_cb5db08559cc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionCommitBatch_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub IsActive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub IsEnded: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub Completed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handler: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Completed: usize,
    #[cfg(feature = "Foundation")]
    pub RemoveCompleted: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    RemoveCompleted: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionContainerShape(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionContainerShape {
    type Vtable = ICompositionContainerShape_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionContainerShape {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4f5e859b_2e5b_44a8_982c_aa0f69c16059);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionContainerShape_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Collections")]
    pub Shapes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    Shapes: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionDrawingSurface(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionDrawingSurface {
    type Vtable = ICompositionDrawingSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionDrawingSurface {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa166c300_fad0_4d11_9e67_e433162ff49e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionDrawingSurface_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub AlphaMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Graphics::DirectX::DirectXAlphaMode) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    AlphaMode: usize,
    #[cfg(feature = "Graphics_DirectX")]
    pub PixelFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Graphics::DirectX::DirectXPixelFormat) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    PixelFormat: usize,
    #[cfg(feature = "Foundation")]
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Size) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Size: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionDrawingSurface2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionDrawingSurface2 {
    type Vtable = ICompositionDrawingSurface2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionDrawingSurface2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfad0e88b_e354_44e8_8e3d_c4880d5a213f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionDrawingSurface2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics")]
    pub SizeInt32: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Graphics::SizeInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    SizeInt32: usize,
    #[cfg(feature = "Graphics")]
    pub Resize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sizepixels: super::super::Graphics::SizeInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Resize: usize,
    #[cfg(feature = "Graphics")]
    pub Scroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: super::super::Graphics::PointInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Scroll: usize,
    #[cfg(feature = "Graphics")]
    pub ScrollRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: super::super::Graphics::PointInt32, scrollrect: super::super::Graphics::RectInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    ScrollRect: usize,
    #[cfg(feature = "Graphics")]
    pub ScrollWithClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    ScrollWithClip: usize,
    #[cfg(feature = "Graphics")]
    pub ScrollRectWithClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32, scrollrect: super::super::Graphics::RectInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    ScrollRectWithClip: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionDrawingSurfaceFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionDrawingSurfaceFactory {
    type Vtable = ICompositionDrawingSurfaceFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionDrawingSurfaceFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9497b00a_312d_46b9_9db3_412fd79464c8);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionDrawingSurfaceFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEasingFunction {
    type Vtable = ICompositionEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5145e356_bf79_4ea8_8cc2_6b5b472e6c9a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEasingFunctionFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEasingFunctionFactory {
    type Vtable = ICompositionEasingFunctionFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEasingFunctionFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x60840774_3da0_4949_8200_7206c00190a0);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEasingFunctionFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEasingFunctionStatics(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEasingFunctionStatics {
    type Vtable = ICompositionEasingFunctionStatics_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEasingFunctionStatics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x17a766b6_2936_53ea_b5af_c642f4a61083);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEasingFunctionStatics_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub CreateCubicBezierEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, controlpoint1: super::super::Foundation::Numerics::Vector2, controlpoint2: super::super::Foundation::Numerics::Vector2, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CreateCubicBezierEasingFunction: usize,
    pub CreateLinearEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateStepEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateStepEasingFunctionWithStepCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, stepcount: i32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateBackEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, mode: CompositionEasingFunctionMode, amplitude: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateBounceEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, mode: CompositionEasingFunctionMode, bounces: i32, bounciness: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateCircleEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, mode: CompositionEasingFunctionMode, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateElasticEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, mode: CompositionEasingFunctionMode, oscillations: i32, springiness: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateExponentialEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, mode: CompositionEasingFunctionMode, exponent: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreatePowerEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, mode: CompositionEasingFunctionMode, power: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSineEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, owner: *mut ::core::ffi::c_void, mode: CompositionEasingFunctionMode, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEffectBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEffectBrush {
    type Vtable = ICompositionEffectBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEffectBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbf7f795e_83cc_44bf_a447_3e3c071789ec);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEffectBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub GetSourceParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, name: ::std::mem::MaybeUninit<::windows_core::HSTRING>, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSourceParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, name: ::std::mem::MaybeUninit<::windows_core::HSTRING>, source: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEffectFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEffectFactory {
    type Vtable = ICompositionEffectFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEffectFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbe5624af_ba7e_4510_9850_41c0b4ff74df);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEffectFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ExtendedError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut ::windows_core::HRESULT) -> ::windows_core::HRESULT,
    pub LoadStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEffectFactoryLoadStatus) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEffectSourceParameter(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEffectSourceParameter {
    type Vtable = ICompositionEffectSourceParameter_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEffectSourceParameter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x858ab13a_3292_4e4e_b3bb_2b6c6544a6ee);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEffectSourceParameter_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEffectSourceParameterFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEffectSourceParameterFactory {
    type Vtable = ICompositionEffectSourceParameterFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEffectSourceParameterFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb3d9f276_aba3_4724_acf3_d0397464db1c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEffectSourceParameterFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Create: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, name: ::std::mem::MaybeUninit<::windows_core::HSTRING>, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionEllipseGeometry(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionEllipseGeometry {
    type Vtable = ICompositionEllipseGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionEllipseGeometry {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4801f884_f6ad_4b93_afa9_897b64e57b1f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionEllipseGeometry_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub Center: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Center: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Radius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Radius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetRadius: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGeometricClip(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGeometricClip {
    type Vtable = ICompositionGeometricClip_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGeometricClip {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc840b581_81c9_4444_a2c1_ccaece3a50e5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGeometricClip_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Geometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ViewBox: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetViewBox: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGeometry(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGeometry {
    type Vtable = ICompositionGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGeometry {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe985217c_6a17_4207_abd8_5fd3dd612a9d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGeometry_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub TrimEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetTrimEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub TrimOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetTrimOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub TrimStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetTrimStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGeometryFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGeometryFactory {
    type Vtable = ICompositionGeometryFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGeometryFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbffebfe1_8c25_480b_9f56_fed6b288055d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGeometryFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGradientBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGradientBrush {
    type Vtable = ICompositionGradientBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGradientBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1d9709e0_ffc6_4c0e_a9ab_34144d4c9098);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGradientBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub AnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    AnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetAnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetAnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub CenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenterPoint: usize,
    pub ColorStops: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ExtendMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionGradientExtendMode) -> ::windows_core::HRESULT,
    pub SetExtendMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionGradientExtendMode) -> ::windows_core::HRESULT,
    pub InterpolationSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionColorSpace) -> ::windows_core::HRESULT,
    pub SetInterpolationSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionColorSpace) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub RotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Scale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Scale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetScale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TransformMatrix: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransformMatrix: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGradientBrush2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGradientBrush2 {
    type Vtable = ICompositionGradientBrush2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGradientBrush2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x899dd5a1_b4c7_4b33_a1b6_264addc26d10);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGradientBrush2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub MappingMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionMappingMode) -> ::windows_core::HRESULT,
    pub SetMappingMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionMappingMode) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGradientBrushFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGradientBrushFactory {
    type Vtable = ICompositionGradientBrushFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGradientBrushFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56d765d7_f189_48c9_9c8d_94daf1bec010);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGradientBrushFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGraphicsDevice(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGraphicsDevice {
    type Vtable = ICompositionGraphicsDevice_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGraphicsDevice {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfb22c6e1_80a2_4667_9936_dbeaf6eefe95);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGraphicsDevice_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(all(feature = "Foundation", feature = "Graphics_DirectX"))]
    pub CreateDrawingSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sizepixels: super::super::Foundation::Size, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Foundation", feature = "Graphics_DirectX")))]
    CreateDrawingSurface: usize,
    #[cfg(feature = "Foundation")]
    pub RenderingDeviceReplaced: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handler: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    RenderingDeviceReplaced: usize,
    #[cfg(feature = "Foundation")]
    pub RemoveRenderingDeviceReplaced: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    RemoveRenderingDeviceReplaced: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGraphicsDevice2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGraphicsDevice2 {
    type Vtable = ICompositionGraphicsDevice2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGraphicsDevice2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0fb8bdf6_c0f0_4bcc_9fb8_084982490d7d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGraphicsDevice2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub CreateDrawingSurface2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CreateDrawingSurface2: usize,
    #[cfg(feature = "Graphics_DirectX")]
    pub CreateVirtualDrawingSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CreateVirtualDrawingSurface: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGraphicsDevice3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGraphicsDevice3 {
    type Vtable = ICompositionGraphicsDevice3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGraphicsDevice3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x37f67514_d3ef_49d1_b69d_0d8eabeb3626);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGraphicsDevice3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics_DirectX")]
    pub CreateMipmapSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    CreateMipmapSurface: usize,
    pub Trim: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionGraphicsDevice4(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionGraphicsDevice4 {
    type Vtable = ICompositionGraphicsDevice4_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionGraphicsDevice4 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5a73bff9_a97f_4cf5_ba46_98ef358e71b1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionGraphicsDevice4_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(all(feature = "Foundation", feature = "Graphics_DirectX"))]
    pub CaptureAsync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, capturevisual: *mut ::core::ffi::c_void, size: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode, sdrboost: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Foundation", feature = "Graphics_DirectX")))]
    CaptureAsync: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionLight(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionLight {
    type Vtable = ICompositionLight_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionLight {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x41a6d7c2_2e5d_4bc1_b09e_8f0a03e3d8d3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionLight_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Targets: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionLight2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionLight2 {
    type Vtable = ICompositionLight2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionLight2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa7bcda72_f35d_425d_9b98_23f4205f6669);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionLight2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub ExclusionsFromTargets: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionLight3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionLight3 {
    type Vtable = ICompositionLight3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionLight3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4b0b00e4_df07_4959_b7a4_4f7e4233f838);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionLight3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub IsEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionLightFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionLightFactory {
    type Vtable = ICompositionLightFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionLightFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x069cf306_da3c_4b44_838a_5e03d51ace55);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionLightFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionLineGeometry(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionLineGeometry {
    type Vtable = ICompositionLineGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionLineGeometry {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdd7615a4_0c9a_4b67_8dce_440a5bf9cdec);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionLineGeometry_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub Start: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Start: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetStart: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub End: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    End: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEnd: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionLinearGradientBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionLinearGradientBrush {
    type Vtable = ICompositionLinearGradientBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionLinearGradientBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x983bc519_a9db_413c_a2d8_2a9056fc525e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionLinearGradientBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub EndPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    EndPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEndPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEndPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub StartPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    StartPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetStartPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetStartPoint: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionMaskBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionMaskBrush {
    type Vtable = ICompositionMaskBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionMaskBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x522cf09e_be6b_4f41_be49_f9226d471b4a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionMaskBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Source: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionMipmapSurface(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionMipmapSurface {
    type Vtable = ICompositionMipmapSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionMipmapSurface {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4863675c_cf4a_4b1c_9ece_c5ec0c2b2fe6);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionMipmapSurface_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub LevelCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Graphics_DirectX")]
    pub AlphaMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Graphics::DirectX::DirectXAlphaMode) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    AlphaMode: usize,
    #[cfg(feature = "Graphics_DirectX")]
    pub PixelFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Graphics::DirectX::DirectXPixelFormat) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_DirectX"))]
    PixelFormat: usize,
    #[cfg(feature = "Graphics")]
    pub SizeInt32: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Graphics::SizeInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    SizeInt32: usize,
    pub GetDrawingSurfaceForLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, level: u32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionNineGridBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionNineGridBrush {
    type Vtable = ICompositionNineGridBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionNineGridBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf25154e4_bc8c_4be7_b80f_8685b83c0186);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionNineGridBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub BottomInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetBottomInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub BottomInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetBottomInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub IsCenterHollow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsCenterHollow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
    pub LeftInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetLeftInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub LeftInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetLeftInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RightInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRightInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RightInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRightInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Source: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub TopInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetTopInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub TopInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetTopInsetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub SetInsets: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, inset: f32) -> ::windows_core::HRESULT,
    pub SetInsetsWithValues: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, left: f32, top: f32, right: f32, bottom: f32) -> ::windows_core::HRESULT,
    pub SetInsetScales: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scale: f32) -> ::windows_core::HRESULT,
    pub SetInsetScalesWithValues: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, left: f32, top: f32, right: f32, bottom: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionObject(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionObject {
    type Vtable = ICompositionObject_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionObject {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbcb4ad45_7609_4550_934f_16002a68fded);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionObject_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Compositor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "UI_Core")]
    pub Dispatcher: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "UI_Core"))]
    Dispatcher: usize,
    pub Properties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub StartAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, animation: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub StopAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionObject2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionObject2 {
    type Vtable = ICompositionObject2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionObject2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xef874ea1_5cff_4b68_9e30_a1519d08ba03);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionObject2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Comment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub SetComment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub ImplicitAnimations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetImplicitAnimations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub StartAnimationGroup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub StopAnimationGroup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionObject3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionObject3 {
    type Vtable = ICompositionObject3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionObject3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4bc27925_dacd_4cf2_98b1_986b76e7ebe6);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionObject3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "System")]
    pub DispatcherQueue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "System"))]
    DispatcherQueue: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionObject4(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionObject4 {
    type Vtable = ICompositionObject4_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionObject4 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0bb3784c_346b_4a7c_966b_7310966553d5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionObject4_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub TryGetAnimationController: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionObject5(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionObject5 {
    type Vtable = ICompositionObject5_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionObject5 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1d7f391b_a130_5265_a62b_60b8e668965a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionObject5_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub StartAnimationWithController: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, animation: *mut ::core::ffi::c_void, animationcontroller: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionObjectFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionObjectFactory {
    type Vtable = ICompositionObjectFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionObjectFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x51205c5e_558a_4f2a_8d39_37bfe1e20ddd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionObjectFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionObjectStatics(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionObjectStatics {
    type Vtable = ICompositionObjectStatics_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionObjectStatics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc1ed052f_1ba2_44ba_a904_6a882a0a5adb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionObjectStatics_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub StartAnimationWithIAnimationObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, target: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, animation: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub StartAnimationGroupWithIAnimationObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, target: *mut ::core::ffi::c_void, animation: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionPath(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionPath {
    type Vtable = ICompositionPath_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionPath {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x66da1d5f_2e10_4f22_8a06_0a8151919e60);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionPath_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionPathFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionPathFactory {
    type Vtable = ICompositionPathFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionPathFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9c1e8c6a_0f33_4751_9437_eb3fb9d3ab07);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionPathFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics")]
    pub Create: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, source: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Create: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionPathGeometry(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionPathGeometry {
    type Vtable = ICompositionPathGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionPathGeometry {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0b6a417e_2c77_4c23_af5e_6304c147bb61);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionPathGeometry_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Path: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetPath: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionProjectedShadow(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionProjectedShadow {
    type Vtable = ICompositionProjectedShadow_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionProjectedShadow {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x285b8e72_4328_523f_bcf2_5557c52c3b25);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionProjectedShadow_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub BlurRadiusMultiplier: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetBlurRadiusMultiplier: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Casters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LightSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetLightSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub MaxBlurRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetMaxBlurRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub MinBlurRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetMinBlurRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Receivers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionProjectedShadowCaster(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionProjectedShadowCaster {
    type Vtable = ICompositionProjectedShadowCaster_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionProjectedShadowCaster {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb1d7d426_1e36_5a62_be56_a16112fdd148);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionProjectedShadowCaster_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Brush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CastingVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetCastingVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionProjectedShadowCasterCollection(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionProjectedShadowCasterCollection {
    type Vtable = ICompositionProjectedShadowCasterCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionProjectedShadowCasterCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd2525c0c_e07f_58a3_ac91_37f73ee91740);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionProjectedShadowCasterCollection_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub InsertAbove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newcaster: *mut ::core::ffi::c_void, reference: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub InsertAtBottom: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newcaster: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub InsertAtTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newcaster: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub InsertBelow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newcaster: *mut ::core::ffi::c_void, reference: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, caster: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionProjectedShadowCasterCollectionStatics(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionProjectedShadowCasterCollectionStatics {
    type Vtable = ICompositionProjectedShadowCasterCollectionStatics_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionProjectedShadowCasterCollectionStatics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56fbb136_e94f_5299_ab5b_6e15e38bd899);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionProjectedShadowCasterCollectionStatics_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub MaxRespectedCasters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionProjectedShadowReceiver(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionProjectedShadowReceiver {
    type Vtable = ICompositionProjectedShadowReceiver_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionProjectedShadowReceiver {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1377985a_6a49_536a_9be4_a96a8e5298a9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionProjectedShadowReceiver_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub ReceivingVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetReceivingVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionProjectedShadowReceiverUnorderedCollection(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionProjectedShadowReceiverUnorderedCollection {
    type Vtable = ICompositionProjectedShadowReceiverUnorderedCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionProjectedShadowReceiverUnorderedCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x02b3e3b7_27d2_599f_ac4b_ab787cdde6fd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionProjectedShadowReceiverUnorderedCollection_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionPropertySet(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionPropertySet {
    type Vtable = ICompositionPropertySet_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionPropertySet {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc9d6d202_5f67_4453_9117_9eadd430d3c2);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionPropertySet_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub InsertColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::Color) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertMatrix3x2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertMatrix3x2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertMatrix4x4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertMatrix4x4: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertQuaternion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertQuaternion: usize,
    pub InsertScalar: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertVector2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertVector2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertVector3: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertVector3: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertVector4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertVector4: usize,
    pub TryGetColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut super::Color, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetMatrix3x2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut super::super::Foundation::Numerics::Matrix3x2, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetMatrix3x2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetMatrix4x4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut super::super::Foundation::Numerics::Matrix4x4, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetMatrix4x4: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetQuaternion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut super::super::Foundation::Numerics::Quaternion, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetQuaternion: usize,
    pub TryGetScalar: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut f32, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetVector2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut super::super::Foundation::Numerics::Vector2, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetVector2: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetVector3: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut super::super::Foundation::Numerics::Vector3, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetVector3: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TryGetVector4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut super::super::Foundation::Numerics::Vector4, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TryGetVector4: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionPropertySet2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionPropertySet2 {
    type Vtable = ICompositionPropertySet2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionPropertySet2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xde80731e_a211_4455_8880_7d0f3f6a44fd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionPropertySet2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub InsertBoolean: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: bool) -> ::windows_core::HRESULT,
    pub TryGetBoolean: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyname: ::std::mem::MaybeUninit<::windows_core::HSTRING>, value: *mut bool, result__: *mut CompositionGetValueStatus) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionRadialGradientBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionRadialGradientBrush {
    type Vtable = ICompositionRadialGradientBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionRadialGradientBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3d3b50c5_e3fa_4ce2_b9fc_3ee12561788f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionRadialGradientBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub EllipseCenter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    EllipseCenter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEllipseCenter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEllipseCenter: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub EllipseRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    EllipseRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetEllipseRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetEllipseRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub GradientOriginOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    GradientOriginOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetGradientOriginOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetGradientOriginOffset: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionRectangleGeometry(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionRectangleGeometry {
    type Vtable = ICompositionRectangleGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionRectangleGeometry {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0cd51428_5356_4246_aecf_7a0b76975400);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionRectangleGeometry_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Size: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSize: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionRoundedRectangleGeometry(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionRoundedRectangleGeometry {
    type Vtable = ICompositionRoundedRectangleGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionRoundedRectangleGeometry {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8770c822_1d50_4b8b_b013_7c9a0e46935f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionRoundedRectangleGeometry_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub CornerRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CornerRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCornerRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCornerRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Size: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSize: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionScopedBatch(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionScopedBatch {
    type Vtable = ICompositionScopedBatch_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionScopedBatch {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0d00dad0_fb07_46fd_8c72_6280d1a3d1dd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionScopedBatch_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub IsActive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub IsEnded: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub End: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Suspend: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub Completed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handler: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Completed: usize,
    #[cfg(feature = "Foundation")]
    pub RemoveCompleted: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    RemoveCompleted: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionShadow(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionShadow {
    type Vtable = ICompositionShadow_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionShadow {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x329e52e2_4335_49cc_b14a_37782d10f0c4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionShadow_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionShadowFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionShadowFactory {
    type Vtable = ICompositionShadowFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionShadowFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x221f492f_dcba_4b91_999e_1dc217a01530);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionShadowFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionShape(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionShape {
    type Vtable = ICompositionShape_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionShape {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb47ce2f7_9a88_42c4_9e87_2e500ca8688c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionShape_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub CenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub RotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Scale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Scale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetScale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TransformMatrix: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransformMatrix: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionShapeFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionShapeFactory {
    type Vtable = ICompositionShapeFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionShapeFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1dfc36d0_b05a_44ef_82b0_12118bcd4cd0);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionShapeFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionSpriteShape(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionSpriteShape {
    type Vtable = ICompositionSpriteShape_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionSpriteShape {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x401b61bb_0007_4363_b1f3_6bcc003fb83e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionSpriteShape_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub FillBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetFillBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Geometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub IsStrokeNonScaling: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsStrokeNonScaling: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
    pub StrokeBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetStrokeBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Collections")]
    pub StrokeDashArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    StrokeDashArray: usize,
    pub StrokeDashCap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionStrokeCap) -> ::windows_core::HRESULT,
    pub SetStrokeDashCap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionStrokeCap) -> ::windows_core::HRESULT,
    pub StrokeDashOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetStrokeDashOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub StrokeEndCap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionStrokeCap) -> ::windows_core::HRESULT,
    pub SetStrokeEndCap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionStrokeCap) -> ::windows_core::HRESULT,
    pub StrokeLineJoin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionStrokeLineJoin) -> ::windows_core::HRESULT,
    pub SetStrokeLineJoin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionStrokeLineJoin) -> ::windows_core::HRESULT,
    pub StrokeMiterLimit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetStrokeMiterLimit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub StrokeStartCap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionStrokeCap) -> ::windows_core::HRESULT,
    pub SetStrokeStartCap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionStrokeCap) -> ::windows_core::HRESULT,
    pub StrokeThickness: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetStrokeThickness: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionSupportsSystemBackdrop(::windows_core::IUnknown);
impl ICompositionSupportsSystemBackdrop {
    pub fn SystemBackdrop(&self) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).SystemBackdrop)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetSystemBackdrop<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetSystemBackdrop)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
}
::windows_core::imp::interface_hierarchy!(ICompositionSupportsSystemBackdrop, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::RuntimeType for ICompositionSupportsSystemBackdrop {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"{397dafe4-b6c2-5bb9-951d-f5707de8b7bc}");
}
unsafe impl ::windows_core::Interface for ICompositionSupportsSystemBackdrop {
    type Vtable = ICompositionSupportsSystemBackdrop_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionSupportsSystemBackdrop {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x397dafe4_b6c2_5bb9_951d_f5707de8b7bc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionSupportsSystemBackdrop_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub SystemBackdrop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSystemBackdrop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionSurface(::windows_core::IUnknown);
impl ICompositionSurface {}
::windows_core::imp::interface_hierarchy!(ICompositionSurface, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::RuntimeType for ICompositionSurface {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"{1527540d-42c7-47a6-a408-668f79a90dfb}");
}
unsafe impl ::windows_core::Interface for ICompositionSurface {
    type Vtable = ICompositionSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionSurface {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1527540d_42c7_47a6_a408_668f79a90dfb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionSurface_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionSurfaceBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionSurfaceBrush {
    type Vtable = ICompositionSurfaceBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionSurfaceBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xad016d79_1e4c_4c0d_9c29_83338c87c162);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionSurfaceBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub BitmapInterpolationMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionBitmapInterpolationMode) -> ::windows_core::HRESULT,
    pub SetBitmapInterpolationMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionBitmapInterpolationMode) -> ::windows_core::HRESULT,
    pub HorizontalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetHorizontalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Stretch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionStretch) -> ::windows_core::HRESULT,
    pub SetStretch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionStretch) -> ::windows_core::HRESULT,
    pub Surface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub VerticalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetVerticalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionSurfaceBrush2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionSurfaceBrush2 {
    type Vtable = ICompositionSurfaceBrush2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionSurfaceBrush2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd27174d5_64f5_4692_9dc7_71b61d7e5880);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionSurfaceBrush2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub AnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    AnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetAnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetAnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub CenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub RotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Scale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Scale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetScale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TransformMatrix: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransformMatrix: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionSurfaceBrush3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionSurfaceBrush3 {
    type Vtable = ICompositionSurfaceBrush3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionSurfaceBrush3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x550bb289_1fe0_42e5_8195_1eefa87ff08e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionSurfaceBrush3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub SnapToPixels: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetSnapToPixels: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionSurfaceFacade(::windows_core::IUnknown);
impl ICompositionSurfaceFacade {
    pub fn GetRealSurface(&self) -> ::windows_core::Result<ICompositionSurface> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetRealSurface)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
}
::windows_core::imp::interface_hierarchy!(ICompositionSurfaceFacade, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::RuntimeType for ICompositionSurfaceFacade {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"{e01622c8-2332-55c7-8868-a7312c5c229d}");
}
unsafe impl ::windows_core::Interface for ICompositionSurfaceFacade {
    type Vtable = ICompositionSurfaceFacade_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionSurfaceFacade {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe01622c8_2332_55c7_8868_a7312c5c229d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionSurfaceFacade_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub GetRealSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionTarget(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionTarget {
    type Vtable = ICompositionTarget_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionTarget {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa1bea8ba_d726_4663_8129_6b5e7927ffa6);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionTarget_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Root: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionTargetFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionTargetFactory {
    type Vtable = ICompositionTargetFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionTargetFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x93cd9d2b_8516_4b14_a8ce_f49e2119ec42);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionTargetFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionTransform(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionTransform {
    type Vtable = ICompositionTransform_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionTransform {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x7cd54529_fbed_4112_abc5_185906dd927c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionTransform_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionTransformFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionTransformFactory {
    type Vtable = ICompositionTransformFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionTransformFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xaaaeca26_c149_517a_8f72_6bff7a65ce08);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionTransformFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionViewBox(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionViewBox {
    type Vtable = ICompositionViewBox_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionViewBox {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb440bf07_068f_4537_84c6_4ecbe019e1f4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionViewBox_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub HorizontalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetHorizontalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Size: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSize: usize,
    pub Stretch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionStretch) -> ::windows_core::HRESULT,
    pub SetStretch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionStretch) -> ::windows_core::HRESULT,
    pub VerticalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetVerticalAlignmentRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionVirtualDrawingSurface(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionVirtualDrawingSurface {
    type Vtable = ICompositionVirtualDrawingSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionVirtualDrawingSurface {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa9c384db_8740_4f94_8b9d_b68521e7863d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionVirtualDrawingSurface_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Graphics")]
    pub Trim: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rects_array_size: u32, rects: *const super::super::Graphics::RectInt32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics"))]
    Trim: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionVirtualDrawingSurfaceFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionVirtualDrawingSurfaceFactory {
    type Vtable = ICompositionVirtualDrawingSurfaceFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionVirtualDrawingSurfaceFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6766106c_d56b_4a49_b1df_5076a0620768);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionVirtualDrawingSurfaceFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositionVisualSurface(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositionVisualSurface {
    type Vtable = ICompositionVisualSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositionVisualSurface {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb224d803_4f6e_4a3f_8cae_3dc1cda74fc6);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositionVisualSurface_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub SourceVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSourceVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub SourceOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SourceOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSourceOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSourceOffset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SourceSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SourceSize: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSourceSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSourceSize: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor {
    type Vtable = ICompositor_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb403ca50_7f8c_4e83_985f_cc45060036d8);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateColorKeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateColorBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateColorBrushWithColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, color: super::Color, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateContainerVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub CreateCubicBezierEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, controlpoint1: super::super::Foundation::Numerics::Vector2, controlpoint2: super::super::Foundation::Numerics::Vector2, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CreateCubicBezierEasingFunction: usize,
    #[cfg(feature = "Graphics_Effects")]
    pub CreateEffectFactory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, graphicseffect: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Graphics_Effects"))]
    CreateEffectFactory: usize,
    #[cfg(all(feature = "Foundation_Collections", feature = "Graphics_Effects"))]
    pub CreateEffectFactoryWithProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, graphicseffect: *mut ::core::ffi::c_void, animatableproperties: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Foundation_Collections", feature = "Graphics_Effects")))]
    CreateEffectFactoryWithProperties: usize,
    pub CreateExpressionAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateExpressionAnimationWithExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, expression: ::std::mem::MaybeUninit<::windows_core::HSTRING>, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateInsetClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateInsetClipWithInsets: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, leftinset: f32, topinset: f32, rightinset: f32, bottominset: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateLinearEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreatePropertySet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateQuaternionKeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateScalarKeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateScopedBatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, batchtype: CompositionBatchTypes, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSpriteVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSurfaceBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSurfaceBrushWithSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, surface: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateTargetForCurrentView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateVector2KeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateVector3KeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateVector4KeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetCommitBatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, batchtype: CompositionBatchTypes, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor2 {
    type Vtable = ICompositor2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x735081dc_5e24_45da_a38f_e32cc349a9a0);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateAmbientLight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateAnimationGroup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateBackdropBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateDistantLight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateDropShadow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateImplicitAnimationCollection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateLayerVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateMaskBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateNineGridBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreatePointLight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSpotLight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateStepEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateStepEasingFunctionWithStepCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stepcount: i32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor3 {
    type Vtable = ICompositor3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc9dd8ef0_6eb1_4e3c_a658_675d9c64d4ab);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateHostBackdropBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor4(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor4 {
    type Vtable = ICompositor4_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor4 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xae47e78a_7910_4425_a482_a05b758adce9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor4_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateColorGradientStop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateColorGradientStopWithOffsetAndColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: f32, color: super::Color, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateLinearGradientBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSpringScalarAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSpringVector2Animation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSpringVector3Animation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor5(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor5 {
    type Vtable = ICompositor5_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor5 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x48ea31ad_7fcd_4076_a79c_90cc4b852c9b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor5_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Comment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub SetComment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub GlobalPlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetGlobalPlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub CreateBounceScalarAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateBounceVector2Animation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateBounceVector3Animation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateContainerShape: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateEllipseGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateLineGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreatePathGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreatePathGeometryWithPath: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, path: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreatePathKeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateRectangleGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateRoundedRectangleGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateShapeVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSpriteShape: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSpriteShapeWithGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, geometry: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateViewBox: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub RequestCommitAsync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    RequestCommitAsync: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor6(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor6 {
    type Vtable = ICompositor6_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor6 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x7a38b2bd_cec8_4eeb_830f_d8d07aedebc3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor6_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateGeometricClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateGeometricClipWithGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, geometry: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateRedirectVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateRedirectVisualWithSourceVisual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, source: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateBooleanKeyFrameAnimation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor7(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor7 {
    type Vtable = ICompositor7_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor7 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd3483fad_9a12_53ba_bfc8_88b7ff7977c6);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor7_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "System")]
    pub DispatcherQueue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "System"))]
    DispatcherQueue: usize,
    pub CreateAnimationPropertyInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateRectangleClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateRectangleClipWithSides: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, left: f32, top: f32, right: f32, bottom: f32, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub CreateRectangleClipWithSidesAndRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, left: f32, top: f32, right: f32, bottom: f32, topleftradius: super::super::Foundation::Numerics::Vector2, toprightradius: super::super::Foundation::Numerics::Vector2, bottomrightradius: super::super::Foundation::Numerics::Vector2, bottomleftradius: super::super::Foundation::Numerics::Vector2, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CreateRectangleClipWithSidesAndRadius: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositor8(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositor8 {
    type Vtable = ICompositor8_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositor8 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9a0bdee2_fe7b_5f62_a366_9cf8effe2112);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositor8_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateAnimationController: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositorStatics(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositorStatics {
    type Vtable = ICompositorStatics_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositorStatics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x080db93e_121e_4d97_8b74_1dfcf91987ea);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositorStatics_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub MaxGlobalPlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub MinGlobalPlaybackRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositorWithBlurredWallpaperBackdropBrush(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositorWithBlurredWallpaperBackdropBrush {
    type Vtable = ICompositorWithBlurredWallpaperBackdropBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositorWithBlurredWallpaperBackdropBrush {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0d8fb190_f122_5b8d_9fdd_543b0d8eb7f3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositorWithBlurredWallpaperBackdropBrush_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub TryCreateBlurredWallpaperBackdropBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositorWithProjectedShadow(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositorWithProjectedShadow {
    type Vtable = ICompositorWithProjectedShadow_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositorWithProjectedShadow {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa2e6330e_8a60_5a38_bb85_b44ea901677c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositorWithProjectedShadow_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateProjectedShadowCaster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateProjectedShadow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateProjectedShadowReceiver: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositorWithRadialGradient(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositorWithRadialGradient {
    type Vtable = ICompositorWithRadialGradient_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositorWithRadialGradient {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x98b9c1a7_8e71_4b53_b4a8_69ba5d19dc5b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositorWithRadialGradient_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateRadialGradientBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICompositorWithVisualSurface(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICompositorWithVisualSurface {
    type Vtable = ICompositorWithVisualSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICompositorWithVisualSurface {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcfa1658b_0123_4551_8891_89bdcc40322b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICompositorWithVisualSurface_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub CreateVisualSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IContainerVisual(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IContainerVisual {
    type Vtable = IContainerVisual_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IContainerVisual {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x02f6bc74_ed20_4773_afe6_d49b4a93db32);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContainerVisual_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Children: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IContainerVisualFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IContainerVisualFactory {
    type Vtable = IContainerVisualFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IContainerVisualFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0363a65b_c7da_4d9a_95f4_69b5c8df670b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContainerVisualFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ICubicBezierEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ICubicBezierEasingFunction {
    type Vtable = ICubicBezierEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ICubicBezierEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x32350666_c1e8_44f9_96b8_c98acf0ae698);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICubicBezierEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub ControlPoint1: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    ControlPoint1: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub ControlPoint2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    ControlPoint2: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IDelegatedInkTrailVisual(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IDelegatedInkTrailVisual {
    type Vtable = IDelegatedInkTrailVisual_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IDelegatedInkTrailVisual {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x856e60b1_e1ab_5b23_8e3d_d513f221c998);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDelegatedInkTrailVisual_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation")]
    pub AddTrailPoints: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, inkPoints_array_size: u32, inkpoints: *const InkTrailPoint, result__: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    AddTrailPoints: usize,
    #[cfg(feature = "Foundation")]
    pub AddTrailPointsWithPrediction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, inkPoints_array_size: u32, inkpoints: *const InkTrailPoint, predictedInkPoints_array_size: u32, predictedinkpoints: *const InkTrailPoint, result__: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    AddTrailPointsWithPrediction: usize,
    pub RemoveTrailPoints: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, generationid: u32) -> ::windows_core::HRESULT,
    pub StartNewTrail: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, color: super::Color) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IDelegatedInkTrailVisualStatics(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IDelegatedInkTrailVisualStatics {
    type Vtable = IDelegatedInkTrailVisualStatics_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IDelegatedInkTrailVisualStatics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0daf6bd5_42c6_555c_9267_e0ac663af836);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDelegatedInkTrailVisualStatics_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Create: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, compositor: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateForSwapChain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, compositor: *mut ::core::ffi::c_void, swapchain: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IDistantLight(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IDistantLight {
    type Vtable = IDistantLight_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IDistantLight {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x318cfafc_5ce3_4b55_ab5d_07a00353ac99);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDistantLight_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
    pub CoordinateSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetCoordinateSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Direction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Direction: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetDirection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetDirection: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IDistantLight2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IDistantLight2 {
    type Vtable = IDistantLight2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IDistantLight2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdbcdaa1c_294b_48d7_b60e_76df64aa392b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDistantLight2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Intensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetIntensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IDropShadow(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IDropShadow {
    type Vtable = IDropShadow_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IDropShadow {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcb977c07_a154_4851_85e7_a8924c84fad8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDropShadow_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub BlurRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetBlurRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Color: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
    pub Mask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub Opacity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetOpacity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IDropShadow2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IDropShadow2 {
    type Vtable = IDropShadow2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IDropShadow2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6c4218bc_15b9_4c2d_8d4a_0767df11977a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDropShadow2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub SourcePolicy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionDropShadowSourcePolicy) -> ::windows_core::HRESULT,
    pub SetSourcePolicy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionDropShadowSourcePolicy) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IElasticEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IElasticEasingFunction {
    type Vtable = IElasticEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IElasticEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x66de6285_054e_5594_8475_c22cb51f1bd5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IElasticEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEasingFunctionMode) -> ::windows_core::HRESULT,
    pub Oscillations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub Springiness: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IExponentialEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IExponentialEasingFunction {
    type Vtable = IExponentialEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IExponentialEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6f7d1a51_98d2_5638_a34a_00486554c750);
}
#[repr(C)]
#[doc(hidden)]
pub struct IExponentialEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEasingFunctionMode) -> ::windows_core::HRESULT,
    pub Exponent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IExpressionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IExpressionAnimation {
    type Vtable = IExpressionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IExpressionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6acc5431_7d3d_4bf3_abb6_f44bdc4888c1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IExpressionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Expression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub SetExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IImplicitAnimationCollection(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IImplicitAnimationCollection {
    type Vtable = IImplicitAnimationCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IImplicitAnimationCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0598a3ff_0a92_4c9d_a427_b25519250dbf);
}
#[repr(C)]
#[doc(hidden)]
pub struct IImplicitAnimationCollection_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IInsetClip(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IInsetClip {
    type Vtable = IInsetClip_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IInsetClip {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1e73e647_84c7_477a_b474_5880e0442e15);
}
#[repr(C)]
#[doc(hidden)]
pub struct IInsetClip_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub BottomInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetBottomInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub LeftInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetLeftInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RightInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRightInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub TopInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetTopInset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IKeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IKeyFrameAnimation {
    type Vtable = IKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IKeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x126e7f22_3ae9_4540_9a8a_deae8a4a4a84);
}
#[repr(C)]
#[doc(hidden)]
pub struct IKeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation")]
    pub DelayTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    DelayTime: usize,
    #[cfg(feature = "Foundation")]
    pub SetDelayTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetDelayTime: usize,
    #[cfg(feature = "Foundation")]
    pub Duration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Duration: usize,
    #[cfg(feature = "Foundation")]
    pub SetDuration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetDuration: usize,
    pub IterationBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationIterationBehavior) -> ::windows_core::HRESULT,
    pub SetIterationBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationIterationBehavior) -> ::windows_core::HRESULT,
    pub IterationCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub SetIterationCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32) -> ::windows_core::HRESULT,
    pub KeyFrameCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub StopBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationStopBehavior) -> ::windows_core::HRESULT,
    pub SetStopBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationStopBehavior) -> ::windows_core::HRESULT,
    pub InsertExpressionKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: ::std::mem::MaybeUninit<::windows_core::HSTRING>) -> ::windows_core::HRESULT,
    pub InsertExpressionKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: ::std::mem::MaybeUninit<::windows_core::HSTRING>, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IKeyFrameAnimation2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IKeyFrameAnimation2 {
    type Vtable = IKeyFrameAnimation2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IKeyFrameAnimation2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf4b488bb_2940_4ec0_a41a_eb6d801a2f18);
}
#[repr(C)]
#[doc(hidden)]
pub struct IKeyFrameAnimation2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Direction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationDirection) -> ::windows_core::HRESULT,
    pub SetDirection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationDirection) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IKeyFrameAnimation3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IKeyFrameAnimation3 {
    type Vtable = IKeyFrameAnimation3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IKeyFrameAnimation3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x845bf0b4_d8de_462f_8753_c80d43c6ff5a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IKeyFrameAnimation3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub DelayBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationDelayBehavior) -> ::windows_core::HRESULT,
    pub SetDelayBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationDelayBehavior) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IKeyFrameAnimationFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IKeyFrameAnimationFactory {
    type Vtable = IKeyFrameAnimationFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IKeyFrameAnimationFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbf0803f8_712a_4fc1_8c87_970859ed8d2e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IKeyFrameAnimationFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ILayerVisual(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ILayerVisual {
    type Vtable = ILayerVisual_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ILayerVisual {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xaf843985_0444_4887_8e83_b40b253f822c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILayerVisual_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Effect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetEffect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ILayerVisual2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ILayerVisual2 {
    type Vtable = ILayerVisual2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ILayerVisual2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x98f9aeeb_6f23_49f1_90b1_1f59a14fbce3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILayerVisual2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Shadow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetShadow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ILinearEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ILinearEasingFunction {
    type Vtable = ILinearEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ILinearEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9400975a_c7a6_46b3_acf7_1a268a0a117d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILinearEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct INaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for INaturalMotionAnimation {
    type Vtable = INaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for INaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x438de12d_769b_4821_a949_284a6547e873);
}
#[repr(C)]
#[doc(hidden)]
pub struct INaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub DelayBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationDelayBehavior) -> ::windows_core::HRESULT,
    pub SetDelayBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationDelayBehavior) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub DelayTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    DelayTime: usize,
    #[cfg(feature = "Foundation")]
    pub SetDelayTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetDelayTime: usize,
    pub StopBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut AnimationStopBehavior) -> ::windows_core::HRESULT,
    pub SetStopBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: AnimationStopBehavior) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct INaturalMotionAnimationFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for INaturalMotionAnimationFactory {
    type Vtable = INaturalMotionAnimationFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for INaturalMotionAnimationFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf53acb06_cf6a_4387_a3fe_5221f3e7e0e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct INaturalMotionAnimationFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IPathKeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IPathKeyFrameAnimation {
    type Vtable = IPathKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IPathKeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9d0d18c9_1576_4b3f_be60_1d5031f5e71b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IPathKeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, path: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, path: *mut ::core::ffi::c_void, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IPointLight(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IPointLight {
    type Vtable = IPointLight_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IPointLight {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb18545b3_0c5a_4ab0_bedc_4f3546948272);
}
#[repr(C)]
#[doc(hidden)]
pub struct IPointLight_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Color: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
    pub ConstantAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetConstantAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub CoordinateSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetCoordinateSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LinearAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetLinearAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub QuadraticAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetQuadraticAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IPointLight2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IPointLight2 {
    type Vtable = IPointLight2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IPointLight2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xefe98f2c_0678_4f69_b164_a810d995bcb7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IPointLight2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Intensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetIntensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IPointLight3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IPointLight3 {
    type Vtable = IPointLight3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IPointLight3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4c0a8367_d4e9_468a_87ae_7ba43ab29485);
}
#[repr(C)]
#[doc(hidden)]
pub struct IPointLight3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub MinAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetMinAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub MaxAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetMaxAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IPowerEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IPowerEasingFunction {
    type Vtable = IPowerEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IPowerEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc3ff53d6_138b_5815_891a_b7f615ccc563);
}
#[repr(C)]
#[doc(hidden)]
pub struct IPowerEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEasingFunctionMode) -> ::windows_core::HRESULT,
    pub Power: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IQuaternionKeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IQuaternionKeyFrameAnimation {
    type Vtable = IQuaternionKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IQuaternionKeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x404e5835_ecf6_4240_8520_671279cf36bc);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQuaternionKeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrame: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Quaternion, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrameWithEasingFunction: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IRectangleClip(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IRectangleClip {
    type Vtable = IRectangleClip_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IRectangleClip {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb3e7549e_00b4_5b53_8be8_353f6c433101);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRectangleClip_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Bottom: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetBottom: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub BottomLeftRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    BottomLeftRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetBottomLeftRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetBottomLeftRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub BottomRightRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    BottomRightRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetBottomRightRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetBottomRightRadius: usize,
    pub Left: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetLeft: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Right: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub Top: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub TopLeftRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TopLeftRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTopLeftRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTopLeftRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TopRightRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TopRightRadius: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTopRightRadius: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTopRightRadius: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IRedirectVisual(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IRedirectVisual {
    type Vtable = IRedirectVisual_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IRedirectVisual {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8cc6e340_8b75_5422_b06f_09ffe9f8617e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRedirectVisual_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Source: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IRenderingDeviceReplacedEventArgs(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IRenderingDeviceReplacedEventArgs {
    type Vtable = IRenderingDeviceReplacedEventArgs_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IRenderingDeviceReplacedEventArgs {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3a31ac7d_28bf_4e7a_8524_71679d480f38);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRenderingDeviceReplacedEventArgs_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub GraphicsDevice: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IScalarKeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IScalarKeyFrameAnimation {
    type Vtable = IScalarKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IScalarKeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xae288fa9_252c_4b95_a725_bf85e38000a1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IScalarKeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: f32) -> ::windows_core::HRESULT,
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: f32, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IScalarNaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IScalarNaturalMotionAnimation {
    type Vtable = IScalarNaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IScalarNaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x94a94581_bf92_495b_b5bd_d2c659430737);
}
#[repr(C)]
#[doc(hidden)]
pub struct IScalarNaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation")]
    pub FinalValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    FinalValue: usize,
    #[cfg(feature = "Foundation")]
    pub SetFinalValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetFinalValue: usize,
    #[cfg(feature = "Foundation")]
    pub InitialValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    InitialValue: usize,
    #[cfg(feature = "Foundation")]
    pub SetInitialValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetInitialValue: usize,
    pub InitialVelocity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetInitialVelocity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IScalarNaturalMotionAnimationFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IScalarNaturalMotionAnimationFactory {
    type Vtable = IScalarNaturalMotionAnimationFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IScalarNaturalMotionAnimationFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x835aa4fc_671c_41dd_af48_ae8def8b1529);
}
#[repr(C)]
#[doc(hidden)]
pub struct IScalarNaturalMotionAnimationFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IShapeVisual(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IShapeVisual {
    type Vtable = IShapeVisual_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IShapeVisual {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf2bd13c3_ba7e_4b0f_9126_ffb7536b8176);
}
#[repr(C)]
#[doc(hidden)]
pub struct IShapeVisual_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Collections")]
    pub Shapes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Collections"))]
    Shapes: usize,
    pub ViewBox: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetViewBox: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISineEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISineEasingFunction {
    type Vtable = ISineEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISineEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf1b518bf_9563_5474_bd13_44b2df4b1d58);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISineEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionEasingFunctionMode) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpotLight(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpotLight {
    type Vtable = ISpotLight_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpotLight {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5a9fe273_44a1_4f95_a422_8fa5116bdb44);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpotLight_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub ConstantAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetConstantAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub CoordinateSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetCoordinateSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Direction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Direction: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetDirection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetDirection: usize,
    pub InnerConeAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetInnerConeAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub InnerConeAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetInnerConeAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub InnerConeColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetInnerConeColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
    pub LinearAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetLinearAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub OuterConeAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetOuterConeAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub OuterConeAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetOuterConeAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub OuterConeColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::Color) -> ::windows_core::HRESULT,
    pub SetOuterConeColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::Color) -> ::windows_core::HRESULT,
    pub QuadraticAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetQuadraticAttenuation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpotLight2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpotLight2 {
    type Vtable = ISpotLight2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpotLight2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x64ee615e_0686_4dea_a9e8_bc3a8c701459);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpotLight2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub InnerConeIntensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetInnerConeIntensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub OuterConeIntensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetOuterConeIntensity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpotLight3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpotLight3 {
    type Vtable = ISpotLight3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpotLight3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe4d03eea_131f_480e_859e_b82705b74360);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpotLight3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub MinAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetMinAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub MaxAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetMaxAttenuationCutoff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpringScalarNaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpringScalarNaturalMotionAnimation {
    type Vtable = ISpringScalarNaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpringScalarNaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0572a95f_37f9_4fbe_b87b_5cd03a89501c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpringScalarNaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub DampingRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetDampingRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub Period: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Period: usize,
    #[cfg(feature = "Foundation")]
    pub SetPeriod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetPeriod: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpringVector2NaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpringVector2NaturalMotionAnimation {
    type Vtable = ISpringVector2NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpringVector2NaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x23f494b5_ee73_4f0f_a423_402b946df4b3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpringVector2NaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub DampingRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetDampingRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub Period: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Period: usize,
    #[cfg(feature = "Foundation")]
    pub SetPeriod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetPeriod: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpringVector3NaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpringVector3NaturalMotionAnimation {
    type Vtable = ISpringVector3NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpringVector3NaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6c8749df_d57b_4794_8e2d_cecb11e194e5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpringVector3NaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub DampingRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetDampingRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation")]
    pub Period: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    Period: usize,
    #[cfg(feature = "Foundation")]
    pub SetPeriod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::TimeSpan) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation"))]
    SetPeriod: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpriteVisual(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpriteVisual {
    type Vtable = ISpriteVisual_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpriteVisual {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x08e05581_1ad1_4f97_9757_402d76e4233b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpriteVisual_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Brush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ISpriteVisual2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for ISpriteVisual2 {
    type Vtable = ISpriteVisual2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ISpriteVisual2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x588c9664_997a_4850_91fe_53cb58f81ce9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpriteVisual2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Shadow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetShadow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IStepEasingFunction(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IStepEasingFunction {
    type Vtable = IStepEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IStepEasingFunction {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd0caa74b_560c_4a0b_a5f6_206ca8c3ecd6);
}
#[repr(C)]
#[doc(hidden)]
pub struct IStepEasingFunction_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub FinalStep: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub SetFinalStep: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32) -> ::windows_core::HRESULT,
    pub InitialStep: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub SetInitialStep: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32) -> ::windows_core::HRESULT,
    pub IsFinalStepSingleFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsFinalStepSingleFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
    pub IsInitialStepSingleFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsInitialStepSingleFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
    pub StepCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub SetStepCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVector2KeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVector2KeyFrameAnimation {
    type Vtable = IVector2KeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVector2KeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdf414515_4e29_4f11_b55e_bf2a6eb36294);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVector2KeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrame: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Vector2, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrameWithEasingFunction: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVector2NaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVector2NaturalMotionAnimation {
    type Vtable = IVector2NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVector2NaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0f3e0b7d_e512_479d_a00c_77c93a30a395);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVector2NaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub FinalValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    FinalValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetFinalValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetFinalValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InitialValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InitialValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetInitialValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetInitialValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InitialVelocity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InitialVelocity: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetInitialVelocity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetInitialVelocity: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVector2NaturalMotionAnimationFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVector2NaturalMotionAnimationFactory {
    type Vtable = IVector2NaturalMotionAnimationFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVector2NaturalMotionAnimationFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8c74ff61_0761_48a2_bddb_6afcc52b89d8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVector2NaturalMotionAnimationFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVector3KeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVector3KeyFrameAnimation {
    type Vtable = IVector3KeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVector3KeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc8039daa_a281_43c2_a73d_b68e3c533c40);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVector3KeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrame: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Vector3, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrameWithEasingFunction: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVector3NaturalMotionAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVector3NaturalMotionAnimation {
    type Vtable = IVector3NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVector3NaturalMotionAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9c17042c_e2ca_45ad_969e_4e78b7b9ad41);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVector3NaturalMotionAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub FinalValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    FinalValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetFinalValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetFinalValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InitialValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InitialValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetInitialValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetInitialValue: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InitialVelocity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InitialVelocity: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetInitialVelocity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetInitialVelocity: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVector3NaturalMotionAnimationFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVector3NaturalMotionAnimationFactory {
    type Vtable = IVector3NaturalMotionAnimationFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVector3NaturalMotionAnimationFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x21a81d2f_0880_457b_ac87_b609018c876d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVector3NaturalMotionAnimationFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVector4KeyFrameAnimation(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVector4KeyFrameAnimation {
    type Vtable = IVector4KeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVector4KeyFrameAnimation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x2457945b_addd_4385_9606_b6a3d5e4e1b9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVector4KeyFrameAnimation_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrame: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub InsertKeyFrameWithEasingFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, normalizedprogresskey: f32, value: super::super::Foundation::Numerics::Vector4, easingfunction: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    InsertKeyFrameWithEasingFunction: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisual(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVisual {
    type Vtable = IVisual_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisual {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x117e202d_a859_4c89_873b_c2aa566788e3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisual_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    #[cfg(feature = "Foundation_Numerics")]
    pub AnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    AnchorPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetAnchorPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetAnchorPoint: usize,
    pub BackfaceVisibility: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionBackfaceVisibility) -> ::windows_core::HRESULT,
    pub SetBackfaceVisibility: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionBackfaceVisibility) -> ::windows_core::HRESULT,
    pub BorderMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionBorderMode) -> ::windows_core::HRESULT,
    pub SetBorderMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionBorderMode) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub CenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CenterPoint: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetCenterPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetCenterPoint: usize,
    pub Clip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CompositeMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut CompositionCompositeMode) -> ::windows_core::HRESULT,
    pub SetCompositeMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CompositionCompositeMode) -> ::windows_core::HRESULT,
    pub IsVisible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsVisible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Offset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Offset: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOffset: usize,
    pub Opacity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetOpacity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub Orientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Quaternion) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Orientation: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetOrientation: usize,
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    pub RotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut f32) -> ::windows_core::HRESULT,
    pub SetRotationAngleInDegrees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: f32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub RotationAxis: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    RotationAxis: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetRotationAxis: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetRotationAxis: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Scale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Scale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetScale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetScale: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    Size: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetSize: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub TransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    TransformMatrix: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransformMatrix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransformMatrix: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisual2(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVisual2 {
    type Vtable = IVisual2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisual2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3052b611_56c3_4c3e_8bf3_f6e1ad473f06);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisual2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub ParentForTransform: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetParentForTransform: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub RelativeOffsetAdjustment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    RelativeOffsetAdjustment: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetRelativeOffsetAdjustment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetRelativeOffsetAdjustment: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub RelativeSizeAdjustment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    RelativeSizeAdjustment: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetRelativeSizeAdjustment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetRelativeSizeAdjustment: usize,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisual3(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVisual3 {
    type Vtable = IVisual3_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisual3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x30be580d_f4b6_4ab7_80dd_3738cbac9f2c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisual3_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub IsHitTestVisible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsHitTestVisible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisual4(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVisual4 {
    type Vtable = IVisual4_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisual4 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9476bf11_e24b_5bf9_9ebe_6274109b2711);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisual4_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub IsPixelSnappingEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut bool) -> ::windows_core::HRESULT,
    pub SetIsPixelSnappingEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: bool) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisualCollection(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVisualCollection {
    type Vtable = IVisualCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisualCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8b745505_fd3e_4a98_84a8_e949468c6bcb);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisualCollection_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub InsertAbove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newchild: *mut ::core::ffi::c_void, sibling: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub InsertAtBottom: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newchild: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub InsertAtTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newchild: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub InsertBelow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newchild: *mut ::core::ffi::c_void, sibling: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, child: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisualElement(::windows_core::IUnknown);
impl IVisualElement {}
::windows_core::imp::interface_hierarchy!(IVisualElement, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::RuntimeType for IVisualElement {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"{01e64612-1d82-42f4-8e3f-a722ded33fc7}");
}
unsafe impl ::windows_core::Interface for IVisualElement {
    type Vtable = IVisualElement_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisualElement {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x01e64612_1d82_42f4_8e3f_a722ded33fc7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisualElement_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisualElement2(::windows_core::IUnknown);
impl IVisualElement2 {
    pub fn GetVisualInternal(&self) -> ::windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetVisualInternal)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
}
::windows_core::imp::interface_hierarchy!(IVisualElement2, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::RuntimeType for IVisualElement2 {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"{993ae8a0-6057-5e40-918c-e06e0b7e7c64}");
}
unsafe impl ::windows_core::Interface for IVisualElement2 {
    type Vtable = IVisualElement2_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisualElement2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x993ae8a0_6057_5e40_918c_e06e0b7e7c64);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisualElement2_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub GetVisualInternal: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisualFactory(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVisualFactory {
    type Vtable = IVisualFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisualFactory {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xad0ff93e_b502_4eb5_87b4_9a38a71d0137);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisualFactory_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
}
#[doc(hidden)]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct IVisualUnorderedCollection(::windows_core::IUnknown);
unsafe impl ::windows_core::Interface for IVisualUnorderedCollection {
    type Vtable = IVisualUnorderedCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for IVisualUnorderedCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x338faa70_54c8_40a7_8029_c9ceeb0aa250);
}
#[repr(C)]
#[doc(hidden)]
pub struct IVisualUnorderedCollection_Vtbl {
    pub base__: ::windows_core::IInspectable_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut i32) -> ::windows_core::HRESULT,
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newvisual: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, visual: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct AmbientLight(::windows_core::IUnknown);
impl AmbientLight {
    pub fn Color(&self) -> ::windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Color)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetColor(&self, value: super::Color) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetColor)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Intensity(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<IAmbientLight2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Intensity)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIntensity(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IAmbientLight2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetIntensity)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Targets(&self) -> ::windows_core::Result<VisualUnorderedCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionLight>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Targets)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn ExclusionsFromTargets(&self) -> ::windows_core::Result<VisualUnorderedCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionLight2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ExclusionsFromTargets)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn IsEnabled(&self) -> ::windows_core::Result<bool> {
        let this = &::windows_core::ComInterface::cast::<ICompositionLight3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsEnabled)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIsEnabled(&self, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionLight3>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetIsEnabled)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for AmbientLight {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.AmbientLight;{a48130a1-b7c4-46f7-b9bf-daf43a44e6ee})");
}
unsafe impl ::windows_core::Interface for AmbientLight {
    type Vtable = IAmbientLight_Vtbl;
}
unsafe impl ::windows_core::ComInterface for AmbientLight {
    const IID: ::windows_core::GUID = <IAmbientLight as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for AmbientLight {
    const NAME: &'static str = "Windows.UI.Composition.AmbientLight";
}
::windows_core::imp::interface_hierarchy!(AmbientLight, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for AmbientLight {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for AmbientLight {}
impl ::windows_core::CanTryInto<CompositionLight> for AmbientLight {}
impl ::windows_core::CanTryInto<CompositionObject> for AmbientLight {}
unsafe impl ::core::marker::Send for AmbientLight {}
unsafe impl ::core::marker::Sync for AmbientLight {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct AnimationController(::windows_core::IUnknown);
impl AnimationController {
    pub fn PlaybackRate(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).PlaybackRate)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetPlaybackRate(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetPlaybackRate)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Progress(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Progress)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetProgress(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetProgress)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn ProgressBehavior(&self) -> ::windows_core::Result<AnimationControllerProgressBehavior> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ProgressBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetProgressBehavior(&self, value: AnimationControllerProgressBehavior) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetProgressBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Pause(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Pause)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Resume(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Resume)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn MaxPlaybackRate() -> ::windows_core::Result<f32> {
        Self::IAnimationControllerStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MaxPlaybackRate)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        })
    }
    pub fn MinPlaybackRate() -> ::windows_core::Result<f32> {
        Self::IAnimationControllerStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MinPlaybackRate)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        })
    }
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc(hidden)]
    pub fn IAnimationControllerStatics<R, F: FnOnce(&IAnimationControllerStatics) -> ::windows_core::Result<R>>(callback: F) -> ::windows_core::Result<R> {
        static SHARED: ::windows_core::imp::FactoryCache<AnimationController, IAnimationControllerStatics> = ::windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl ::windows_core::RuntimeType for AnimationController {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.AnimationController;{c934efd2-0722-4f5f-a4e2-9510f3d43bf7})");
}
unsafe impl ::windows_core::Interface for AnimationController {
    type Vtable = IAnimationController_Vtbl;
}
unsafe impl ::windows_core::ComInterface for AnimationController {
    const IID: ::windows_core::GUID = <IAnimationController as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for AnimationController {
    const NAME: &'static str = "Windows.UI.Composition.AnimationController";
}
::windows_core::imp::interface_hierarchy!(AnimationController, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for AnimationController {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for AnimationController {}
impl ::windows_core::CanTryInto<CompositionObject> for AnimationController {}
unsafe impl ::core::marker::Send for AnimationController {}
unsafe impl ::core::marker::Sync for AnimationController {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct AnimationPropertyInfo(::windows_core::IUnknown);
impl AnimationPropertyInfo {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn AccessMode(&self) -> ::windows_core::Result<AnimationPropertyAccessMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AccessMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetAccessMode(&self, value: AnimationPropertyAccessMode) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetAccessMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn GetResolvedCompositionObject(&self) -> ::windows_core::Result<CompositionObject> {
        let this = &::windows_core::ComInterface::cast::<IAnimationPropertyInfo2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetResolvedCompositionObject)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn GetResolvedCompositionObjectProperty(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<IAnimationPropertyInfo2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetResolvedCompositionObjectProperty)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for AnimationPropertyInfo {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.AnimationPropertyInfo;{f4716f05-ed77-4e3c-b328-5c3985b3738f})");
}
unsafe impl ::windows_core::Interface for AnimationPropertyInfo {
    type Vtable = IAnimationPropertyInfo_Vtbl;
}
unsafe impl ::windows_core::ComInterface for AnimationPropertyInfo {
    const IID: ::windows_core::GUID = <IAnimationPropertyInfo as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for AnimationPropertyInfo {
    const NAME: &'static str = "Windows.UI.Composition.AnimationPropertyInfo";
}
::windows_core::imp::interface_hierarchy!(AnimationPropertyInfo, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for AnimationPropertyInfo {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for AnimationPropertyInfo {}
impl ::windows_core::CanTryInto<CompositionObject> for AnimationPropertyInfo {}
unsafe impl ::core::marker::Send for AnimationPropertyInfo {}
unsafe impl ::core::marker::Sync for AnimationPropertyInfo {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct BackEasingFunction(::windows_core::IUnknown);
impl BackEasingFunction {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn Mode(&self) -> ::windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Mode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Amplitude(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Amplitude)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for BackEasingFunction {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.BackEasingFunction;{b8560da4-5e3c-545d-b263-7987a2bd27cb})");
}
unsafe impl ::windows_core::Interface for BackEasingFunction {
    type Vtable = IBackEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for BackEasingFunction {
    const IID: ::windows_core::GUID = <IBackEasingFunction as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for BackEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.BackEasingFunction";
}
::windows_core::imp::interface_hierarchy!(BackEasingFunction, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for BackEasingFunction {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for BackEasingFunction {}
impl ::windows_core::CanTryInto<CompositionEasingFunction> for BackEasingFunction {}
impl ::windows_core::CanTryInto<CompositionObject> for BackEasingFunction {}
unsafe impl ::core::marker::Send for BackEasingFunction {}
unsafe impl ::core::marker::Sync for BackEasingFunction {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct BooleanKeyFrameAnimation(::windows_core::IUnknown);
impl BooleanKeyFrameAnimation {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn InsertKeyFrame(&self, normalizedprogresskey: f32, value: bool) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertKeyFrame)(::windows_core::Interface::as_raw(this), normalizedprogresskey, value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearAllParameters)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &::windows_core::HSTRING, value: super::Color) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetColorParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetQuaternionParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P0>(&self, key: &::windows_core::HSTRING, compositionobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), compositionobject.try_into_param()?.abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &::windows_core::HSTRING, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScalarParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector3Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &::windows_core::HSTRING, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetBooleanParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Target)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTarget(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTarget)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> ::windows_core::Result<InitialValueExpressionCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValueExpressions)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExpressionReferenceParameter<P0>(&self, parametername: &::windows_core::HSTRING, source: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(parametername), source.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn DelayTime(&self) -> ::windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayTime)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayTime)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Duration(&self) -> ::windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Duration)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetDuration(&self, value: super::super::Foundation::TimeSpan) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDuration)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationBehavior(&self) -> ::windows_core::Result<AnimationIterationBehavior> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IterationBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIterationBehavior(&self, value: AnimationIterationBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetIterationBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationCount(&self) -> ::windows_core::Result<i32> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IterationCount)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIterationCount(&self, value: i32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetIterationCount)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn KeyFrameCount(&self) -> ::windows_core::Result<i32> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).KeyFrameCount)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StopBehavior(&self) -> ::windows_core::Result<AnimationStopBehavior> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StopBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetStopBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InsertExpressionKeyFrame(&self, normalizedprogresskey: f32, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).InsertExpressionKeyFrame)(::windows_core::Interface::as_raw(this), normalizedprogresskey, ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn InsertExpressionKeyFrameWithEasingFunction<P0>(&self, normalizedprogresskey: f32, value: &::windows_core::HSTRING, easingfunction: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionEasingFunction>,
    {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).InsertExpressionKeyFrameWithEasingFunction)(::windows_core::Interface::as_raw(this), normalizedprogresskey, ::core::mem::transmute_copy(value), easingfunction.try_into_param()?.abi()).ok() }
    }
    pub fn Direction(&self) -> ::windows_core::Result<AnimationDirection> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Direction)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetDirection(&self, value: AnimationDirection) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDirection)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn DelayBehavior(&self) -> ::windows_core::Result<AnimationDelayBehavior> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for BooleanKeyFrameAnimation {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.BooleanKeyFrameAnimation;{95e23a08-d1f4-4972-9770-3efe68d82e14})");
}
unsafe impl ::windows_core::Interface for BooleanKeyFrameAnimation {
    type Vtable = IBooleanKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for BooleanKeyFrameAnimation {
    const IID: ::windows_core::GUID = <IBooleanKeyFrameAnimation as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for BooleanKeyFrameAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BooleanKeyFrameAnimation";
}
::windows_core::imp::interface_hierarchy!(BooleanKeyFrameAnimation, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for BooleanKeyFrameAnimation {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for BooleanKeyFrameAnimation {}
impl ::windows_core::CanTryInto<ICompositionAnimationBase> for BooleanKeyFrameAnimation {}
impl ::windows_core::CanTryInto<KeyFrameAnimation> for BooleanKeyFrameAnimation {}
impl ::windows_core::CanTryInto<CompositionAnimation> for BooleanKeyFrameAnimation {}
impl ::windows_core::CanTryInto<CompositionObject> for BooleanKeyFrameAnimation {}
unsafe impl ::core::marker::Send for BooleanKeyFrameAnimation {}
unsafe impl ::core::marker::Sync for BooleanKeyFrameAnimation {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct BounceEasingFunction(::windows_core::IUnknown);
impl BounceEasingFunction {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn Mode(&self) -> ::windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Mode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Bounces(&self) -> ::windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Bounces)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Bounciness(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Bounciness)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for BounceEasingFunction {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.BounceEasingFunction;{e7fdb44b-aad5-5174-9421-eef8b75a6a43})");
}
unsafe impl ::windows_core::Interface for BounceEasingFunction {
    type Vtable = IBounceEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for BounceEasingFunction {
    const IID: ::windows_core::GUID = <IBounceEasingFunction as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for BounceEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.BounceEasingFunction";
}
::windows_core::imp::interface_hierarchy!(BounceEasingFunction, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for BounceEasingFunction {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for BounceEasingFunction {}
impl ::windows_core::CanTryInto<CompositionEasingFunction> for BounceEasingFunction {}
impl ::windows_core::CanTryInto<CompositionObject> for BounceEasingFunction {}
unsafe impl ::core::marker::Send for BounceEasingFunction {}
unsafe impl ::core::marker::Sync for BounceEasingFunction {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct BounceScalarNaturalMotionAnimation(::windows_core::IUnknown);
impl BounceScalarNaturalMotionAnimation {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn Acceleration(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Acceleration)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetAcceleration(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetAcceleration)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Restitution(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Restitution)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRestitution(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRestitution)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearAllParameters)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &::windows_core::HSTRING, value: super::Color) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetColorParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetQuaternionParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P0>(&self, key: &::windows_core::HSTRING, compositionobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), compositionobject.try_into_param()?.abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &::windows_core::HSTRING, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScalarParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector3Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &::windows_core::HSTRING, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetBooleanParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Target)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTarget(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTarget)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> ::windows_core::Result<InitialValueExpressionCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValueExpressions)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExpressionReferenceParameter<P0>(&self, parametername: &::windows_core::HSTRING, source: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(parametername), source.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn DelayBehavior(&self) -> ::windows_core::Result<AnimationDelayBehavior> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn DelayTime(&self) -> ::windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayTime)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayTime)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StopBehavior(&self) -> ::windows_core::Result<AnimationStopBehavior> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StopBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetStopBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn FinalValue(&self) -> ::windows_core::Result<super::super::Foundation::IReference<f32>> {
        let this = &::windows_core::ComInterface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).FinalValue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetFinalValue<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<super::super::Foundation::IReference<f32>>,
    {
        let this = &::windows_core::ComInterface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetFinalValue)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn InitialValue(&self) -> ::windows_core::Result<super::super::Foundation::IReference<f32>> {
        let this = &::windows_core::ComInterface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetInitialValue<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<super::super::Foundation::IReference<f32>>,
    {
        let this = &::windows_core::ComInterface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInitialValue)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn InitialVelocity(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialVelocity)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetInitialVelocity(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IScalarNaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInitialVelocity)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for BounceScalarNaturalMotionAnimation {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.BounceScalarNaturalMotionAnimation;{baa30dcc-a633-4618-9b06-7f7c72c87cff})");
}
unsafe impl ::windows_core::Interface for BounceScalarNaturalMotionAnimation {
    type Vtable = IBounceScalarNaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for BounceScalarNaturalMotionAnimation {
    const IID: ::windows_core::GUID = <IBounceScalarNaturalMotionAnimation as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for BounceScalarNaturalMotionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BounceScalarNaturalMotionAnimation";
}
::windows_core::imp::interface_hierarchy!(BounceScalarNaturalMotionAnimation, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for BounceScalarNaturalMotionAnimation {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for BounceScalarNaturalMotionAnimation {}
impl ::windows_core::CanTryInto<ICompositionAnimationBase> for BounceScalarNaturalMotionAnimation {}
impl ::windows_core::CanTryInto<ScalarNaturalMotionAnimation> for BounceScalarNaturalMotionAnimation {}
impl ::windows_core::CanTryInto<NaturalMotionAnimation> for BounceScalarNaturalMotionAnimation {}
impl ::windows_core::CanTryInto<CompositionAnimation> for BounceScalarNaturalMotionAnimation {}
impl ::windows_core::CanTryInto<CompositionObject> for BounceScalarNaturalMotionAnimation {}
unsafe impl ::core::marker::Send for BounceScalarNaturalMotionAnimation {}
unsafe impl ::core::marker::Sync for BounceScalarNaturalMotionAnimation {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct BounceVector2NaturalMotionAnimation(::windows_core::IUnknown);
impl BounceVector2NaturalMotionAnimation {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn Acceleration(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Acceleration)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetAcceleration(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetAcceleration)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Restitution(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Restitution)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRestitution(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRestitution)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearAllParameters)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &::windows_core::HSTRING, value: super::Color) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetColorParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetQuaternionParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P0>(&self, key: &::windows_core::HSTRING, compositionobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), compositionobject.try_into_param()?.abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &::windows_core::HSTRING, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScalarParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector3Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &::windows_core::HSTRING, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetBooleanParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Target)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTarget(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTarget)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> ::windows_core::Result<InitialValueExpressionCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValueExpressions)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExpressionReferenceParameter<P0>(&self, parametername: &::windows_core::HSTRING, source: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(parametername), source.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn DelayBehavior(&self) -> ::windows_core::Result<AnimationDelayBehavior> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn DelayTime(&self) -> ::windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayTime)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayTime)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StopBehavior(&self) -> ::windows_core::Result<AnimationStopBehavior> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StopBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetStopBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn FinalValue(&self) -> ::windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>> {
        let this = &::windows_core::ComInterface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).FinalValue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetFinalValue<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>>,
    {
        let this = &::windows_core::ComInterface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetFinalValue)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialValue(&self) -> ::windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>> {
        let this = &::windows_core::ComInterface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialValue<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector2>>,
    {
        let this = &::windows_core::ComInterface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInitialValue)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialVelocity(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialVelocity)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialVelocity(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IVector2NaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInitialVelocity)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for BounceVector2NaturalMotionAnimation {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.BounceVector2NaturalMotionAnimation;{da344196-2154-4b3c-88aa-47361204eccd})");
}
unsafe impl ::windows_core::Interface for BounceVector2NaturalMotionAnimation {
    type Vtable = IBounceVector2NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for BounceVector2NaturalMotionAnimation {
    const IID: ::windows_core::GUID = <IBounceVector2NaturalMotionAnimation as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for BounceVector2NaturalMotionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BounceVector2NaturalMotionAnimation";
}
::windows_core::imp::interface_hierarchy!(BounceVector2NaturalMotionAnimation, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for BounceVector2NaturalMotionAnimation {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for BounceVector2NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<ICompositionAnimationBase> for BounceVector2NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<Vector2NaturalMotionAnimation> for BounceVector2NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<NaturalMotionAnimation> for BounceVector2NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<CompositionAnimation> for BounceVector2NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<CompositionObject> for BounceVector2NaturalMotionAnimation {}
unsafe impl ::core::marker::Send for BounceVector2NaturalMotionAnimation {}
unsafe impl ::core::marker::Sync for BounceVector2NaturalMotionAnimation {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct BounceVector3NaturalMotionAnimation(::windows_core::IUnknown);
impl BounceVector3NaturalMotionAnimation {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn Acceleration(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Acceleration)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetAcceleration(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetAcceleration)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Restitution(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Restitution)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRestitution(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRestitution)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearAllParameters)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &::windows_core::HSTRING, value: super::Color) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetColorParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetQuaternionParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P0>(&self, key: &::windows_core::HSTRING, compositionobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), compositionobject.try_into_param()?.abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &::windows_core::HSTRING, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScalarParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector3Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &::windows_core::HSTRING, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetBooleanParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Target)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTarget(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTarget)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> ::windows_core::Result<InitialValueExpressionCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValueExpressions)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExpressionReferenceParameter<P0>(&self, parametername: &::windows_core::HSTRING, source: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(parametername), source.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn DelayBehavior(&self) -> ::windows_core::Result<AnimationDelayBehavior> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn DelayTime(&self) -> ::windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayTime)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayTime)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StopBehavior(&self) -> ::windows_core::Result<AnimationStopBehavior> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StopBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<INaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetStopBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn FinalValue(&self) -> ::windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>> {
        let this = &::windows_core::ComInterface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).FinalValue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetFinalValue<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>>,
    {
        let this = &::windows_core::ComInterface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetFinalValue)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialValue(&self) -> ::windows_core::Result<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>> {
        let this = &::windows_core::ComInterface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialValue<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<super::super::Foundation::IReference<super::super::Foundation::Numerics::Vector3>>,
    {
        let this = &::windows_core::ComInterface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInitialValue)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InitialVelocity(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector3> {
        let this = &::windows_core::ComInterface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialVelocity)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetInitialVelocity(&self, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IVector3NaturalMotionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInitialVelocity)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for BounceVector3NaturalMotionAnimation {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.BounceVector3NaturalMotionAnimation;{47dabc31-10d3-4518-86f1-09caf742d113})");
}
unsafe impl ::windows_core::Interface for BounceVector3NaturalMotionAnimation {
    type Vtable = IBounceVector3NaturalMotionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for BounceVector3NaturalMotionAnimation {
    const IID: ::windows_core::GUID = <IBounceVector3NaturalMotionAnimation as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for BounceVector3NaturalMotionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.BounceVector3NaturalMotionAnimation";
}
::windows_core::imp::interface_hierarchy!(BounceVector3NaturalMotionAnimation, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for BounceVector3NaturalMotionAnimation {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for BounceVector3NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<ICompositionAnimationBase> for BounceVector3NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<Vector3NaturalMotionAnimation> for BounceVector3NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<NaturalMotionAnimation> for BounceVector3NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<CompositionAnimation> for BounceVector3NaturalMotionAnimation {}
impl ::windows_core::CanTryInto<CompositionObject> for BounceVector3NaturalMotionAnimation {}
unsafe impl ::core::marker::Send for BounceVector3NaturalMotionAnimation {}
unsafe impl ::core::marker::Sync for BounceVector3NaturalMotionAnimation {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CircleEasingFunction(::windows_core::IUnknown);
impl CircleEasingFunction {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    pub fn Mode(&self) -> ::windows_core::Result<CompositionEasingFunctionMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Mode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CircleEasingFunction {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CircleEasingFunction;{1e07222a-6f82-5a28-8748-2e92fc46ee2b})");
}
unsafe impl ::windows_core::Interface for CircleEasingFunction {
    type Vtable = ICircleEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CircleEasingFunction {
    const IID: ::windows_core::GUID = <ICircleEasingFunction as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CircleEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.CircleEasingFunction";
}
::windows_core::imp::interface_hierarchy!(CircleEasingFunction, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CircleEasingFunction {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CircleEasingFunction {}
impl ::windows_core::CanTryInto<CompositionEasingFunction> for CircleEasingFunction {}
impl ::windows_core::CanTryInto<CompositionObject> for CircleEasingFunction {}
unsafe impl ::core::marker::Send for CircleEasingFunction {}
unsafe impl ::core::marker::Sync for CircleEasingFunction {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct ColorKeyFrameAnimation(::windows_core::IUnknown);
impl ColorKeyFrameAnimation {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn InterpolationColorSpace(&self) -> ::windows_core::Result<CompositionColorSpace> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InterpolationColorSpace)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetInterpolationColorSpace(&self, value: CompositionColorSpace) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetInterpolationColorSpace)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InsertKeyFrame(&self, normalizedprogresskey: f32, value: super::Color) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertKeyFrame)(::windows_core::Interface::as_raw(this), normalizedprogresskey, value).ok() }
    }
    pub fn InsertKeyFrameWithEasingFunction<P0>(&self, normalizedprogresskey: f32, value: super::Color, easingfunction: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionEasingFunction>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertKeyFrameWithEasingFunction)(::windows_core::Interface::as_raw(this), normalizedprogresskey, value, easingfunction.try_into_param()?.abi()).ok() }
    }
    pub fn ClearAllParameters(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearAllParameters)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ClearParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &::windows_core::HSTRING, value: super::Color) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetColorParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetQuaternionParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P0>(&self, key: &::windows_core::HSTRING, compositionobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), compositionobject.try_into_param()?.abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &::windows_core::HSTRING, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScalarParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector3Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetVector4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &::windows_core::HSTRING, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetBooleanParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Target)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTarget(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTarget)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> ::windows_core::Result<InitialValueExpressionCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValueExpressions)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExpressionReferenceParameter<P0>(&self, parametername: &::windows_core::HSTRING, source: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(parametername), source.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn DelayTime(&self) -> ::windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayTime)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetDelayTime(&self, value: super::super::Foundation::TimeSpan) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayTime)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Duration(&self) -> ::windows_core::Result<super::super::Foundation::TimeSpan> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Duration)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn SetDuration(&self, value: super::super::Foundation::TimeSpan) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDuration)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationBehavior(&self) -> ::windows_core::Result<AnimationIterationBehavior> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IterationBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIterationBehavior(&self, value: AnimationIterationBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetIterationBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IterationCount(&self) -> ::windows_core::Result<i32> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IterationCount)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIterationCount(&self, value: i32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetIterationCount)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn KeyFrameCount(&self) -> ::windows_core::Result<i32> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).KeyFrameCount)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StopBehavior(&self) -> ::windows_core::Result<AnimationStopBehavior> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StopBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStopBehavior(&self, value: AnimationStopBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetStopBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InsertExpressionKeyFrame(&self, normalizedprogresskey: f32, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).InsertExpressionKeyFrame)(::windows_core::Interface::as_raw(this), normalizedprogresskey, ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn InsertExpressionKeyFrameWithEasingFunction<P0>(&self, normalizedprogresskey: f32, value: &::windows_core::HSTRING, easingfunction: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionEasingFunction>,
    {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).InsertExpressionKeyFrameWithEasingFunction)(::windows_core::Interface::as_raw(this), normalizedprogresskey, ::core::mem::transmute_copy(value), easingfunction.try_into_param()?.abi()).ok() }
    }
    pub fn Direction(&self) -> ::windows_core::Result<AnimationDirection> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Direction)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetDirection(&self, value: AnimationDirection) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDirection)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn DelayBehavior(&self) -> ::windows_core::Result<AnimationDelayBehavior> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DelayBehavior)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetDelayBehavior(&self, value: AnimationDelayBehavior) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<IKeyFrameAnimation3>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetDelayBehavior)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for ColorKeyFrameAnimation {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.ColorKeyFrameAnimation;{93adb5e9-8e05-4593-84a3-dca152781e56})");
}
unsafe impl ::windows_core::Interface for ColorKeyFrameAnimation {
    type Vtable = IColorKeyFrameAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for ColorKeyFrameAnimation {
    const IID: ::windows_core::GUID = <IColorKeyFrameAnimation as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for ColorKeyFrameAnimation {
    const NAME: &'static str = "Windows.UI.Composition.ColorKeyFrameAnimation";
}
::windows_core::imp::interface_hierarchy!(ColorKeyFrameAnimation, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for ColorKeyFrameAnimation {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for ColorKeyFrameAnimation {}
impl ::windows_core::CanTryInto<ICompositionAnimationBase> for ColorKeyFrameAnimation {}
impl ::windows_core::CanTryInto<KeyFrameAnimation> for ColorKeyFrameAnimation {}
impl ::windows_core::CanTryInto<CompositionAnimation> for ColorKeyFrameAnimation {}
impl ::windows_core::CanTryInto<CompositionObject> for ColorKeyFrameAnimation {}
unsafe impl ::core::marker::Send for ColorKeyFrameAnimation {}
unsafe impl ::core::marker::Sync for ColorKeyFrameAnimation {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionAnimation(::windows_core::IUnknown);
impl CompositionAnimation {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearAllParameters(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).ClearAllParameters)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn ClearParameter(&self, key: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).ClearParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key)).ok() }
    }
    pub fn SetColorParameter(&self, key: &::windows_core::HSTRING, value: super::Color) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetColorParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix3x2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix3x2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetMatrix4x4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetMatrix4x4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetQuaternionParameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetQuaternionParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetReferenceParameter<P0>(&self, key: &::windows_core::HSTRING, compositionobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionObject>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), compositionobject.try_into_param()?.abi()).ok() }
    }
    pub fn SetScalarParameter(&self, key: &::windows_core::HSTRING, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetScalarParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector2Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetVector2Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector3Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetVector3Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetVector4Parameter(&self, key: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetVector4Parameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn SetBooleanParameter(&self, key: &::windows_core::HSTRING, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetBooleanParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(key), value).ok() }
    }
    pub fn Target(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Target)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTarget(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTarget)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InitialValueExpressions(&self) -> ::windows_core::Result<InitialValueExpressionCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InitialValueExpressions)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExpressionReferenceParameter<P0>(&self, parametername: &::windows_core::HSTRING, source: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionAnimation4>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExpressionReferenceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(parametername), source.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionAnimation {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionAnimation;{464c4c2c-1caa-4061-9b40-e13fde1503ca})");
}
unsafe impl ::windows_core::Interface for CompositionAnimation {
    type Vtable = ICompositionAnimation_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionAnimation {
    const IID: ::windows_core::GUID = <ICompositionAnimation as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionAnimation {
    const NAME: &'static str = "Windows.UI.Composition.CompositionAnimation";
}
::windows_core::imp::interface_hierarchy!(CompositionAnimation, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionAnimation {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionAnimation {}
impl ::windows_core::CanTryInto<ICompositionAnimationBase> for CompositionAnimation {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionAnimation {}
unsafe impl ::core::marker::Send for CompositionAnimation {}
unsafe impl ::core::marker::Sync for CompositionAnimation {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionAnimationGroup(::windows_core::IUnknown);
impl CompositionAnimationGroup {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Count(&self) -> ::windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Count)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Add<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Add)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn Remove<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Remove)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn RemoveAll(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAll)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn First(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionAnimation>> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IIterable<CompositionAnimation>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).First)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
}
impl ::windows_core::RuntimeType for CompositionAnimationGroup {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionAnimationGroup;{5e7cc90c-cd14-4e07-8a55-c72527aabdac})");
}
unsafe impl ::windows_core::Interface for CompositionAnimationGroup {
    type Vtable = ICompositionAnimationGroup_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionAnimationGroup {
    const IID: ::windows_core::GUID = <ICompositionAnimationGroup as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionAnimationGroup {
    const NAME: &'static str = "Windows.UI.Composition.CompositionAnimationGroup";
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for CompositionAnimationGroup {
    type Item = CompositionAnimation;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        ::core::iter::IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for &CompositionAnimationGroup {
    type Item = CompositionAnimation;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
::windows_core::imp::interface_hierarchy!(CompositionAnimationGroup, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionAnimationGroup {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionAnimationGroup {}
impl ::windows_core::CanTryInto<ICompositionAnimationBase> for CompositionAnimationGroup {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IIterable<CompositionAnimation>> for CompositionAnimationGroup {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionAnimationGroup {}
unsafe impl ::core::marker::Send for CompositionAnimationGroup {}
unsafe impl ::core::marker::Sync for CompositionAnimationGroup {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionBackdropBrush(::windows_core::IUnknown);
impl CompositionBackdropBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionBackdropBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionBackdropBrush;{c5acae58-3898-499e-8d7f-224e91286a5d})");
}
unsafe impl ::windows_core::Interface for CompositionBackdropBrush {
    type Vtable = ICompositionBackdropBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionBackdropBrush {
    const IID: ::windows_core::GUID = <ICompositionBackdropBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionBackdropBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionBackdropBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionBackdropBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionBackdropBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionBackdropBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionBackdropBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionBackdropBrush {}
unsafe impl ::core::marker::Send for CompositionBackdropBrush {}
unsafe impl ::core::marker::Sync for CompositionBackdropBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionBatchCompletedEventArgs(::windows_core::IUnknown);
impl CompositionBatchCompletedEventArgs {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionBatchCompletedEventArgs {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionBatchCompletedEventArgs;{0d00dad0-9464-450a-a562-2e2698b0a812})");
}
unsafe impl ::windows_core::Interface for CompositionBatchCompletedEventArgs {
    type Vtable = ICompositionBatchCompletedEventArgs_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionBatchCompletedEventArgs {
    const IID: ::windows_core::GUID = <ICompositionBatchCompletedEventArgs as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionBatchCompletedEventArgs {
    const NAME: &'static str = "Windows.UI.Composition.CompositionBatchCompletedEventArgs";
}
::windows_core::imp::interface_hierarchy!(CompositionBatchCompletedEventArgs, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionBatchCompletedEventArgs {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionBatchCompletedEventArgs {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionBatchCompletedEventArgs {}
unsafe impl ::core::marker::Send for CompositionBatchCompletedEventArgs {}
unsafe impl ::core::marker::Sync for CompositionBatchCompletedEventArgs {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionBrush(::windows_core::IUnknown);
impl CompositionBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionBrush;{ab0d7608-30c0-40e9-b568-b60a6bd1fb46})");
}
unsafe impl ::windows_core::Interface for CompositionBrush {
    type Vtable = ICompositionBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionBrush {
    const IID: ::windows_core::GUID = <ICompositionBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionBrush {}
unsafe impl ::core::marker::Send for CompositionBrush {}
unsafe impl ::core::marker::Sync for CompositionBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionCapabilities(::windows_core::IUnknown);
impl CompositionCapabilities {
    pub fn AreEffectsSupported(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AreEffectsSupported)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn AreEffectsFast(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AreEffectsFast)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Changed<P0>(&self, handler: P0) -> ::windows_core::Result<super::super::Foundation::EventRegistrationToken>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::TypedEventHandler<CompositionCapabilities, ::windows_core::IInspectable>>,
    {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Changed)(::windows_core::Interface::as_raw(this), handler.into_param().abi(), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn RemoveChanged(&self, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveChanged)(::windows_core::Interface::as_raw(this), token).ok() }
    }
    pub fn GetForCurrentView() -> ::windows_core::Result<CompositionCapabilities> {
        Self::ICompositionCapabilitiesStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetForCurrentView)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        })
    }
    #[doc(hidden)]
    pub fn ICompositionCapabilitiesStatics<R, F: FnOnce(&ICompositionCapabilitiesStatics) -> ::windows_core::Result<R>>(callback: F) -> ::windows_core::Result<R> {
        static SHARED: ::windows_core::imp::FactoryCache<CompositionCapabilities, ICompositionCapabilitiesStatics> = ::windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl ::windows_core::RuntimeType for CompositionCapabilities {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionCapabilities;{8253353e-b517-48bc-b1e8-4b3561a2e181})");
}
unsafe impl ::windows_core::Interface for CompositionCapabilities {
    type Vtable = ICompositionCapabilities_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionCapabilities {
    const IID: ::windows_core::GUID = <ICompositionCapabilities as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionCapabilities {
    const NAME: &'static str = "Windows.UI.Composition.CompositionCapabilities";
}
::windows_core::imp::interface_hierarchy!(CompositionCapabilities, ::windows_core::IUnknown, ::windows_core::IInspectable);
unsafe impl ::core::marker::Send for CompositionCapabilities {}
unsafe impl ::core::marker::Sync for CompositionCapabilities {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionClip(::windows_core::IUnknown);
impl CompositionClip {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AnchorPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetAnchorPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionClip {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionClip;{1ccd2a52-cfc7-4ace-9983-146bb8eb6a3c})");
}
unsafe impl ::windows_core::Interface for CompositionClip {
    type Vtable = ICompositionClip_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionClip {
    const IID: ::windows_core::GUID = <ICompositionClip as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionClip {
    const NAME: &'static str = "Windows.UI.Composition.CompositionClip";
}
::windows_core::imp::interface_hierarchy!(CompositionClip, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionClip {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionClip {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionClip {}
unsafe impl ::core::marker::Send for CompositionClip {}
unsafe impl ::core::marker::Sync for CompositionClip {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionColorBrush(::windows_core::IUnknown);
impl CompositionColorBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Color(&self) -> ::windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Color)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetColor(&self, value: super::Color) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetColor)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionColorBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionColorBrush;{2b264c5e-bf35-4831-8642-cf70c20fff2f})");
}
unsafe impl ::windows_core::Interface for CompositionColorBrush {
    type Vtable = ICompositionColorBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionColorBrush {
    const IID: ::windows_core::GUID = <ICompositionColorBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionColorBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionColorBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionColorBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionColorBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionColorBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionColorBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionColorBrush {}
unsafe impl ::core::marker::Send for CompositionColorBrush {}
unsafe impl ::core::marker::Sync for CompositionColorBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionColorGradientStop(::windows_core::IUnknown);
impl CompositionColorGradientStop {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Color(&self) -> ::windows_core::Result<super::Color> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Color)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetColor(&self, value: super::Color) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetColor)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Offset(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionColorGradientStop {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionColorGradientStop;{6f00ca92-c801-4e41-9a8f-a53e20f57778})");
}
unsafe impl ::windows_core::Interface for CompositionColorGradientStop {
    type Vtable = ICompositionColorGradientStop_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionColorGradientStop {
    const IID: ::windows_core::GUID = <ICompositionColorGradientStop as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionColorGradientStop {
    const NAME: &'static str = "Windows.UI.Composition.CompositionColorGradientStop";
}
::windows_core::imp::interface_hierarchy!(CompositionColorGradientStop, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionColorGradientStop {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionColorGradientStop {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionColorGradientStop {}
unsafe impl ::core::marker::Send for CompositionColorGradientStop {}
unsafe impl ::core::marker::Sync for CompositionColorGradientStop {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionColorGradientStopCollection(::windows_core::IUnknown);
impl CompositionColorGradientStopCollection {
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn First(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionColorGradientStop>> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IIterable<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).First)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetAt(&self, index: u32) -> ::windows_core::Result<CompositionColorGradientStop> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetAt)(::windows_core::Interface::as_raw(this), index, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Size(&self) -> ::windows_core::Result<u32> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Size)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetView(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IVectorView<CompositionColorGradientStop>> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetView)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn IndexOf<P0>(&self, value: P0, index: &mut u32) -> ::windows_core::Result<bool>
    where
        P0: ::windows_core::IntoParam<CompositionColorGradientStop>,
    {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IndexOf)(::windows_core::Interface::as_raw(this), value.into_param().abi(), index, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetAt<P0>(&self, index: u32, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionColorGradientStop>,
    {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetAt)(::windows_core::Interface::as_raw(this), index, value.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InsertAt<P0>(&self, index: u32, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionColorGradientStop>,
    {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).InsertAt)(::windows_core::Interface::as_raw(this), index, value.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn RemoveAt(&self, index: u32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAt)(::windows_core::Interface::as_raw(this), index).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Append<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionColorGradientStop>,
    {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Append)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn RemoveAtEnd(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAtEnd)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Clear(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Clear)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetMany(&self, startindex: u32, items: &mut [::core::option::Option<CompositionColorGradientStop>]) -> ::windows_core::Result<u32> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetMany)(::windows_core::Interface::as_raw(this), startindex, items.len().try_into().unwrap(), ::core::mem::transmute_copy(&items), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn ReplaceAll(&self, items: &[::core::option::Option<CompositionColorGradientStop>]) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ReplaceAll)(::windows_core::Interface::as_raw(this), items.len().try_into().unwrap(), ::core::mem::transmute(items.as_ptr())).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionColorGradientStopCollection {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionColorGradientStopCollection;{9f1d20ec-7b04-4b1d-90bc-9fa32c0cfd26})");
}
unsafe impl ::windows_core::Interface for CompositionColorGradientStopCollection {
    type Vtable = ICompositionColorGradientStopCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionColorGradientStopCollection {
    const IID: ::windows_core::GUID = <ICompositionColorGradientStopCollection as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionColorGradientStopCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionColorGradientStopCollection";
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for CompositionColorGradientStopCollection {
    type Item = CompositionColorGradientStop;
    type IntoIter = super::super::Foundation::Collections::VectorIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        ::core::iter::IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for &CompositionColorGradientStopCollection {
    type Item = CompositionColorGradientStop;
    type IntoIter = super::super::Foundation::Collections::VectorIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        super::super::Foundation::Collections::VectorIterator::new(::windows_core::ComInterface::cast(self).ok())
    }
}
::windows_core::imp::interface_hierarchy!(CompositionColorGradientStopCollection, ::windows_core::IUnknown, ::windows_core::IInspectable);
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IIterable<CompositionColorGradientStop>> for CompositionColorGradientStopCollection {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IVector<CompositionColorGradientStop>> for CompositionColorGradientStopCollection {}
unsafe impl ::core::marker::Send for CompositionColorGradientStopCollection {}
unsafe impl ::core::marker::Sync for CompositionColorGradientStopCollection {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionCommitBatch(::windows_core::IUnknown);
impl CompositionCommitBatch {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn IsActive(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsActive)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn IsEnded(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsEnded)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Completed<P0>(&self, handler: P0) -> ::windows_core::Result<super::super::Foundation::EventRegistrationToken>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::TypedEventHandler<::windows_core::IInspectable, CompositionBatchCompletedEventArgs>>,
    {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Completed)(::windows_core::Interface::as_raw(this), handler.into_param().abi(), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn RemoveCompleted(&self, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveCompleted)(::windows_core::Interface::as_raw(this), token).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionCommitBatch {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionCommitBatch;{0d00dad0-ca07-4400-8c8e-cb5db08559cc})");
}
unsafe impl ::windows_core::Interface for CompositionCommitBatch {
    type Vtable = ICompositionCommitBatch_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionCommitBatch {
    const IID: ::windows_core::GUID = <ICompositionCommitBatch as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionCommitBatch {
    const NAME: &'static str = "Windows.UI.Composition.CompositionCommitBatch";
}
::windows_core::imp::interface_hierarchy!(CompositionCommitBatch, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionCommitBatch {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionCommitBatch {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionCommitBatch {}
unsafe impl ::core::marker::Send for CompositionCommitBatch {}
unsafe impl ::core::marker::Sync for CompositionCommitBatch {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionContainerShape(::windows_core::IUnknown);
impl CompositionContainerShape {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Shapes(&self) -> ::windows_core::Result<CompositionShapeCollection> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Shapes)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionContainerShape {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionContainerShape;{4f5e859b-2e5b-44a8-982c-aa0f69c16059})");
}
unsafe impl ::windows_core::Interface for CompositionContainerShape {
    type Vtable = ICompositionContainerShape_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionContainerShape {
    const IID: ::windows_core::GUID = <ICompositionContainerShape as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionContainerShape {
    const NAME: &'static str = "Windows.UI.Composition.CompositionContainerShape";
}
::windows_core::imp::interface_hierarchy!(CompositionContainerShape, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionContainerShape {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionContainerShape {}
impl ::windows_core::CanTryInto<CompositionShape> for CompositionContainerShape {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionContainerShape {}
unsafe impl ::core::marker::Send for CompositionContainerShape {}
unsafe impl ::core::marker::Sync for CompositionContainerShape {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionDrawingSurface(::windows_core::IUnknown);
impl CompositionDrawingSurface {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Graphics_DirectX\"`"]
    #[cfg(feature = "Graphics_DirectX")]
    pub fn AlphaMode(&self) -> ::windows_core::Result<super::super::Graphics::DirectX::DirectXAlphaMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AlphaMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics_DirectX\"`"]
    #[cfg(feature = "Graphics_DirectX")]
    pub fn PixelFormat(&self) -> ::windows_core::Result<super::super::Graphics::DirectX::DirectXPixelFormat> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).PixelFormat)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Size(&self) -> ::windows_core::Result<super::super::Foundation::Size> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Size)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn SizeInt32(&self) -> ::windows_core::Result<super::super::Graphics::SizeInt32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).SizeInt32)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn Resize(&self, sizepixels: super::super::Graphics::SizeInt32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Resize)(::windows_core::Interface::as_raw(this), sizepixels).ok() }
    }
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn Scroll(&self, offset: super::super::Graphics::PointInt32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Scroll)(::windows_core::Interface::as_raw(this), offset).ok() }
    }
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn ScrollRect(&self, offset: super::super::Graphics::PointInt32, scrollrect: super::super::Graphics::RectInt32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ScrollRect)(::windows_core::Interface::as_raw(this), offset, scrollrect).ok() }
    }
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn ScrollWithClip(&self, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ScrollWithClip)(::windows_core::Interface::as_raw(this), offset, cliprect).ok() }
    }
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn ScrollRectWithClip(&self, offset: super::super::Graphics::PointInt32, cliprect: super::super::Graphics::RectInt32, scrollrect: super::super::Graphics::RectInt32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionDrawingSurface2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).ScrollRectWithClip)(::windows_core::Interface::as_raw(this), offset, cliprect, scrollrect).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionDrawingSurface {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionDrawingSurface;{a166c300-fad0-4d11-9e67-e433162ff49e})");
}
unsafe impl ::windows_core::Interface for CompositionDrawingSurface {
    type Vtable = ICompositionDrawingSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionDrawingSurface {
    const IID: ::windows_core::GUID = <ICompositionDrawingSurface as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionDrawingSurface {
    const NAME: &'static str = "Windows.UI.Composition.CompositionDrawingSurface";
}
::windows_core::imp::interface_hierarchy!(CompositionDrawingSurface, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionDrawingSurface {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionDrawingSurface {}
impl ::windows_core::CanTryInto<ICompositionSurface> for CompositionDrawingSurface {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionDrawingSurface {}
unsafe impl ::core::marker::Send for CompositionDrawingSurface {}
unsafe impl ::core::marker::Sync for CompositionDrawingSurface {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionEasingFunction(::windows_core::IUnknown);
impl CompositionEasingFunction {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CreateCubicBezierEasingFunction<P0>(owner: P0, controlpoint1: super::super::Foundation::Numerics::Vector2, controlpoint2: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<CubicBezierEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateCubicBezierEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), controlpoint1, controlpoint2, &mut result__).from_abi(result__)
        })
    }
    pub fn CreateLinearEasingFunction<P0>(owner: P0) -> ::windows_core::Result<LinearEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateLinearEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), &mut result__).from_abi(result__)
        })
    }
    pub fn CreateStepEasingFunction<P0>(owner: P0) -> ::windows_core::Result<StepEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateStepEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), &mut result__).from_abi(result__)
        })
    }
    pub fn CreateStepEasingFunctionWithStepCount<P0>(owner: P0, stepcount: i32) -> ::windows_core::Result<StepEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateStepEasingFunctionWithStepCount)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), stepcount, &mut result__).from_abi(result__)
        })
    }
    pub fn CreateBackEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, amplitude: f32) -> ::windows_core::Result<BackEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateBackEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), mode, amplitude, &mut result__).from_abi(result__)
        })
    }
    pub fn CreateBounceEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, bounces: i32, bounciness: f32) -> ::windows_core::Result<BounceEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateBounceEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), mode, bounces, bounciness, &mut result__).from_abi(result__)
        })
    }
    pub fn CreateCircleEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode) -> ::windows_core::Result<CircleEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateCircleEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), mode, &mut result__).from_abi(result__)
        })
    }
    pub fn CreateElasticEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, oscillations: i32, springiness: f32) -> ::windows_core::Result<ElasticEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateElasticEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), mode, oscillations, springiness, &mut result__).from_abi(result__)
        })
    }
    pub fn CreateExponentialEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, exponent: f32) -> ::windows_core::Result<ExponentialEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateExponentialEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), mode, exponent, &mut result__).from_abi(result__)
        })
    }
    pub fn CreatePowerEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode, power: f32) -> ::windows_core::Result<PowerEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreatePowerEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), mode, power, &mut result__).from_abi(result__)
        })
    }
    pub fn CreateSineEasingFunction<P0>(owner: P0, mode: CompositionEasingFunctionMode) -> ::windows_core::Result<SineEasingFunction>
    where
        P0: ::windows_core::IntoParam<Compositor>,
    {
        Self::ICompositionEasingFunctionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateSineEasingFunction)(::windows_core::Interface::as_raw(this), owner.into_param().abi(), mode, &mut result__).from_abi(result__)
        })
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc(hidden)]
    pub fn ICompositionEasingFunctionStatics<R, F: FnOnce(&ICompositionEasingFunctionStatics) -> ::windows_core::Result<R>>(callback: F) -> ::windows_core::Result<R> {
        static SHARED: ::windows_core::imp::FactoryCache<CompositionEasingFunction, ICompositionEasingFunctionStatics> = ::windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl ::windows_core::RuntimeType for CompositionEasingFunction {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionEasingFunction;{5145e356-bf79-4ea8-8cc2-6b5b472e6c9a})");
}
unsafe impl ::windows_core::Interface for CompositionEasingFunction {
    type Vtable = ICompositionEasingFunction_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionEasingFunction {
    const IID: ::windows_core::GUID = <ICompositionEasingFunction as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionEasingFunction {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEasingFunction";
}
::windows_core::imp::interface_hierarchy!(CompositionEasingFunction, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionEasingFunction {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionEasingFunction {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionEasingFunction {}
unsafe impl ::core::marker::Send for CompositionEasingFunction {}
unsafe impl ::core::marker::Sync for CompositionEasingFunction {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionEffectBrush(::windows_core::IUnknown);
impl CompositionEffectBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn GetSourceParameter(&self, name: &::windows_core::HSTRING) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetSourceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(name), &mut result__).from_abi(result__)
        }
    }
    pub fn SetSourceParameter<P0>(&self, name: &::windows_core::HSTRING, source: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetSourceParameter)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(name), source.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionEffectBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionEffectBrush;{bf7f795e-83cc-44bf-a447-3e3c071789ec})");
}
unsafe impl ::windows_core::Interface for CompositionEffectBrush {
    type Vtable = ICompositionEffectBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionEffectBrush {
    const IID: ::windows_core::GUID = <ICompositionEffectBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionEffectBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEffectBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionEffectBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionEffectBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionEffectBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionEffectBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionEffectBrush {}
unsafe impl ::core::marker::Send for CompositionEffectBrush {}
unsafe impl ::core::marker::Sync for CompositionEffectBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionEffectFactory(::windows_core::IUnknown);
impl CompositionEffectFactory {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn CreateBrush(&self) -> ::windows_core::Result<CompositionEffectBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateBrush)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn ExtendedError(&self) -> ::windows_core::Result<::windows_core::HRESULT> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ExtendedError)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn LoadStatus(&self) -> ::windows_core::Result<CompositionEffectFactoryLoadStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).LoadStatus)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionEffectFactory {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionEffectFactory;{be5624af-ba7e-4510-9850-41c0b4ff74df})");
}
unsafe impl ::windows_core::Interface for CompositionEffectFactory {
    type Vtable = ICompositionEffectFactory_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionEffectFactory {
    const IID: ::windows_core::GUID = <ICompositionEffectFactory as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionEffectFactory {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEffectFactory";
}
::windows_core::imp::interface_hierarchy!(CompositionEffectFactory, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionEffectFactory {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionEffectFactory {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionEffectFactory {}
unsafe impl ::core::marker::Send for CompositionEffectFactory {}
unsafe impl ::core::marker::Sync for CompositionEffectFactory {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionEffectSourceParameter(::windows_core::IUnknown);
impl CompositionEffectSourceParameter {
    pub fn Name(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Name)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Create(name: &::windows_core::HSTRING) -> ::windows_core::Result<CompositionEffectSourceParameter> {
        Self::ICompositionEffectSourceParameterFactory(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Create)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(name), &mut result__).from_abi(result__)
        })
    }
    #[doc(hidden)]
    pub fn ICompositionEffectSourceParameterFactory<R, F: FnOnce(&ICompositionEffectSourceParameterFactory) -> ::windows_core::Result<R>>(callback: F) -> ::windows_core::Result<R> {
        static SHARED: ::windows_core::imp::FactoryCache<CompositionEffectSourceParameter, ICompositionEffectSourceParameterFactory> = ::windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl ::windows_core::RuntimeType for CompositionEffectSourceParameter {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionEffectSourceParameter;{858ab13a-3292-4e4e-b3bb-2b6c6544a6ee})");
}
unsafe impl ::windows_core::Interface for CompositionEffectSourceParameter {
    type Vtable = ICompositionEffectSourceParameter_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionEffectSourceParameter {
    const IID: ::windows_core::GUID = <ICompositionEffectSourceParameter as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionEffectSourceParameter {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEffectSourceParameter";
}
::windows_core::imp::interface_hierarchy!(CompositionEffectSourceParameter, ::windows_core::IUnknown, ::windows_core::IInspectable);
#[cfg(feature = "Graphics_Effects")]
impl ::windows_core::CanTryInto<super::super::Graphics::Effects::IGraphicsEffectSource> for CompositionEffectSourceParameter {}
unsafe impl ::core::marker::Send for CompositionEffectSourceParameter {}
unsafe impl ::core::marker::Sync for CompositionEffectSourceParameter {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionEllipseGeometry(::windows_core::IUnknown);
impl CompositionEllipseGeometry {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Center(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Center)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenter(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetCenter)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Radius(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Radius)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetRadius(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRadius)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimEnd(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimEnd)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimEnd)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimStart)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimStart)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionEllipseGeometry {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionEllipseGeometry;{4801f884-f6ad-4b93-afa9-897b64e57b1f})");
}
unsafe impl ::windows_core::Interface for CompositionEllipseGeometry {
    type Vtable = ICompositionEllipseGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionEllipseGeometry {
    const IID: ::windows_core::GUID = <ICompositionEllipseGeometry as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionEllipseGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionEllipseGeometry";
}
::windows_core::imp::interface_hierarchy!(CompositionEllipseGeometry, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionEllipseGeometry {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionEllipseGeometry {}
impl ::windows_core::CanTryInto<CompositionGeometry> for CompositionEllipseGeometry {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionEllipseGeometry {}
unsafe impl ::core::marker::Send for CompositionEllipseGeometry {}
unsafe impl ::core::marker::Sync for CompositionEllipseGeometry {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionGeometricClip(::windows_core::IUnknown);
impl CompositionGeometricClip {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AnchorPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetAnchorPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionClip2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Geometry(&self) -> ::windows_core::Result<CompositionGeometry> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Geometry)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetGeometry<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionGeometry>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetGeometry)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn ViewBox(&self) -> ::windows_core::Result<CompositionViewBox> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ViewBox)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetViewBox<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionViewBox>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetViewBox)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionGeometricClip {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionGeometricClip;{c840b581-81c9-4444-a2c1-ccaece3a50e5})");
}
unsafe impl ::windows_core::Interface for CompositionGeometricClip {
    type Vtable = ICompositionGeometricClip_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionGeometricClip {
    const IID: ::windows_core::GUID = <ICompositionGeometricClip as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionGeometricClip {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGeometricClip";
}
::windows_core::imp::interface_hierarchy!(CompositionGeometricClip, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionGeometricClip {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionGeometricClip {}
impl ::windows_core::CanTryInto<CompositionClip> for CompositionGeometricClip {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionGeometricClip {}
unsafe impl ::core::marker::Send for CompositionGeometricClip {}
unsafe impl ::core::marker::Sync for CompositionGeometricClip {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionGeometry(::windows_core::IUnknown);
impl CompositionGeometry {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimEnd)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimEnd)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimStart)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimStart)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionGeometry {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionGeometry;{e985217c-6a17-4207-abd8-5fd3dd612a9d})");
}
unsafe impl ::windows_core::Interface for CompositionGeometry {
    type Vtable = ICompositionGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionGeometry {
    const IID: ::windows_core::GUID = <ICompositionGeometry as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGeometry";
}
::windows_core::imp::interface_hierarchy!(CompositionGeometry, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionGeometry {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionGeometry {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionGeometry {}
unsafe impl ::core::marker::Send for CompositionGeometry {}
unsafe impl ::core::marker::Sync for CompositionGeometry {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionGradientBrush(::windows_core::IUnknown);
impl CompositionGradientBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AnchorPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetAnchorPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn ColorStops(&self) -> ::windows_core::Result<CompositionColorGradientStopCollection> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ColorStops)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn ExtendMode(&self) -> ::windows_core::Result<CompositionGradientExtendMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ExtendMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExtendMode(&self, value: CompositionGradientExtendMode) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetExtendMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InterpolationSpace(&self) -> ::windows_core::Result<CompositionColorSpace> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InterpolationSpace)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetInterpolationSpace(&self, value: CompositionColorSpace) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetInterpolationSpace)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MappingMode(&self) -> ::windows_core::Result<CompositionMappingMode> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MappingMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetMappingMode(&self, value: CompositionMappingMode) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMappingMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionGradientBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionGradientBrush;{1d9709e0-ffc6-4c0e-a9ab-34144d4c9098})");
}
unsafe impl ::windows_core::Interface for CompositionGradientBrush {
    type Vtable = ICompositionGradientBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionGradientBrush {
    const IID: ::windows_core::GUID = <ICompositionGradientBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionGradientBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGradientBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionGradientBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionGradientBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionGradientBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionGradientBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionGradientBrush {}
unsafe impl ::core::marker::Send for CompositionGradientBrush {}
unsafe impl ::core::marker::Sync for CompositionGradientBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionGraphicsDevice(::windows_core::IUnknown);
impl CompositionGraphicsDevice {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`, `\"Graphics_DirectX\"`"]
    #[cfg(all(feature = "Foundation", feature = "Graphics_DirectX"))]
    pub fn CreateDrawingSurface(&self, sizepixels: super::super::Foundation::Size, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> ::windows_core::Result<CompositionDrawingSurface> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateDrawingSurface)(::windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn RenderingDeviceReplaced<P0>(&self, handler: P0) -> ::windows_core::Result<super::super::Foundation::EventRegistrationToken>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::TypedEventHandler<CompositionGraphicsDevice, RenderingDeviceReplacedEventArgs>>,
    {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RenderingDeviceReplaced)(::windows_core::Interface::as_raw(this), handler.into_param().abi(), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn RemoveRenderingDeviceReplaced(&self, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveRenderingDeviceReplaced)(::windows_core::Interface::as_raw(this), token).ok() }
    }
    #[doc = "Required features: `\"Graphics_DirectX\"`"]
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CreateDrawingSurface2(&self, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> ::windows_core::Result<CompositionDrawingSurface> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGraphicsDevice2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateDrawingSurface2)(::windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics_DirectX\"`"]
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CreateVirtualDrawingSurface(&self, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> ::windows_core::Result<CompositionVirtualDrawingSurface> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGraphicsDevice2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateVirtualDrawingSurface)(::windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics_DirectX\"`"]
    #[cfg(feature = "Graphics_DirectX")]
    pub fn CreateMipmapSurface(&self, sizepixels: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode) -> ::windows_core::Result<CompositionMipmapSurface> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGraphicsDevice3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CreateMipmapSurface)(::windows_core::Interface::as_raw(this), sizepixels, pixelformat, alphamode, &mut result__).from_abi(result__)
        }
    }
    pub fn Trim(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGraphicsDevice3>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Trim)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`, `\"Graphics_DirectX\"`"]
    #[cfg(all(feature = "Foundation", feature = "Graphics_DirectX"))]
    pub fn CaptureAsync<P0>(&self, capturevisual: P0, size: super::super::Graphics::SizeInt32, pixelformat: super::super::Graphics::DirectX::DirectXPixelFormat, alphamode: super::super::Graphics::DirectX::DirectXAlphaMode, sdrboost: f32) -> ::windows_core::Result<super::super::Foundation::IAsyncOperation<ICompositionSurface>>
    where
        P0: ::windows_core::TryIntoParam<Visual>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionGraphicsDevice4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CaptureAsync)(::windows_core::Interface::as_raw(this), capturevisual.try_into_param()?.abi(), size, pixelformat, alphamode, sdrboost, &mut result__).from_abi(result__)
        }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionGraphicsDevice {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionGraphicsDevice;{fb22c6e1-80a2-4667-9936-dbeaf6eefe95})");
}
unsafe impl ::windows_core::Interface for CompositionGraphicsDevice {
    type Vtable = ICompositionGraphicsDevice_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionGraphicsDevice {
    const IID: ::windows_core::GUID = <ICompositionGraphicsDevice as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionGraphicsDevice {
    const NAME: &'static str = "Windows.UI.Composition.CompositionGraphicsDevice";
}
::windows_core::imp::interface_hierarchy!(CompositionGraphicsDevice, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionGraphicsDevice {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionGraphicsDevice {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionGraphicsDevice {}
unsafe impl ::core::marker::Send for CompositionGraphicsDevice {}
unsafe impl ::core::marker::Sync for CompositionGraphicsDevice {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionLight(::windows_core::IUnknown);
impl CompositionLight {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Targets(&self) -> ::windows_core::Result<VisualUnorderedCollection> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Targets)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn ExclusionsFromTargets(&self) -> ::windows_core::Result<VisualUnorderedCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionLight2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ExclusionsFromTargets)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn IsEnabled(&self) -> ::windows_core::Result<bool> {
        let this = &::windows_core::ComInterface::cast::<ICompositionLight3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsEnabled)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIsEnabled(&self, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionLight3>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetIsEnabled)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionLight {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionLight;{41a6d7c2-2e5d-4bc1-b09e-8f0a03e3d8d3})");
}
unsafe impl ::windows_core::Interface for CompositionLight {
    type Vtable = ICompositionLight_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionLight {
    const IID: ::windows_core::GUID = <ICompositionLight as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionLight {
    const NAME: &'static str = "Windows.UI.Composition.CompositionLight";
}
::windows_core::imp::interface_hierarchy!(CompositionLight, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionLight {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionLight {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionLight {}
unsafe impl ::core::marker::Send for CompositionLight {}
unsafe impl ::core::marker::Sync for CompositionLight {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionLineGeometry(::windows_core::IUnknown);
impl CompositionLineGeometry {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimEnd)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimEnd)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimStart)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimStart)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Start(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Start)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetStart(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStart)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn End(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).End)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEnd(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetEnd)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionLineGeometry {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionLineGeometry;{dd7615a4-0c9a-4b67-8dce-440a5bf9cdec})");
}
unsafe impl ::windows_core::Interface for CompositionLineGeometry {
    type Vtable = ICompositionLineGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionLineGeometry {
    const IID: ::windows_core::GUID = <ICompositionLineGeometry as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionLineGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionLineGeometry";
}
::windows_core::imp::interface_hierarchy!(CompositionLineGeometry, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionLineGeometry {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionLineGeometry {}
impl ::windows_core::CanTryInto<CompositionGeometry> for CompositionLineGeometry {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionLineGeometry {}
unsafe impl ::core::marker::Send for CompositionLineGeometry {}
unsafe impl ::core::marker::Sync for CompositionLineGeometry {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionLinearGradientBrush(::windows_core::IUnknown);
impl CompositionLinearGradientBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AnchorPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetAnchorPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn ColorStops(&self) -> ::windows_core::Result<CompositionColorGradientStopCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ColorStops)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn ExtendMode(&self) -> ::windows_core::Result<CompositionGradientExtendMode> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ExtendMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExtendMode(&self, value: CompositionGradientExtendMode) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExtendMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InterpolationSpace(&self) -> ::windows_core::Result<CompositionColorSpace> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InterpolationSpace)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetInterpolationSpace(&self, value: CompositionColorSpace) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInterpolationSpace)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MappingMode(&self) -> ::windows_core::Result<CompositionMappingMode> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MappingMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetMappingMode(&self, value: CompositionMappingMode) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMappingMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn EndPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).EndPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEndPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetEndPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn StartPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StartPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetStartPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStartPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionLinearGradientBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionLinearGradientBrush;{983bc519-a9db-413c-a2d8-2a9056fc525e})");
}
unsafe impl ::windows_core::Interface for CompositionLinearGradientBrush {
    type Vtable = ICompositionLinearGradientBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionLinearGradientBrush {
    const IID: ::windows_core::GUID = <ICompositionLinearGradientBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionLinearGradientBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionLinearGradientBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionLinearGradientBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionLinearGradientBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionLinearGradientBrush {}
impl ::windows_core::CanTryInto<CompositionGradientBrush> for CompositionLinearGradientBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionLinearGradientBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionLinearGradientBrush {}
unsafe impl ::core::marker::Send for CompositionLinearGradientBrush {}
unsafe impl ::core::marker::Sync for CompositionLinearGradientBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionMaskBrush(::windows_core::IUnknown);
impl CompositionMaskBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Mask(&self) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Mask)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetMask<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetMask)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn Source(&self) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Source)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetSource<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetSource)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionMaskBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionMaskBrush;{522cf09e-be6b-4f41-be49-f9226d471b4a})");
}
unsafe impl ::windows_core::Interface for CompositionMaskBrush {
    type Vtable = ICompositionMaskBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionMaskBrush {
    const IID: ::windows_core::GUID = <ICompositionMaskBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionMaskBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionMaskBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionMaskBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionMaskBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionMaskBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionMaskBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionMaskBrush {}
unsafe impl ::core::marker::Send for CompositionMaskBrush {}
unsafe impl ::core::marker::Sync for CompositionMaskBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionMipmapSurface(::windows_core::IUnknown);
impl CompositionMipmapSurface {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn LevelCount(&self) -> ::windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).LevelCount)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics_DirectX\"`"]
    #[cfg(feature = "Graphics_DirectX")]
    pub fn AlphaMode(&self) -> ::windows_core::Result<super::super::Graphics::DirectX::DirectXAlphaMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AlphaMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics_DirectX\"`"]
    #[cfg(feature = "Graphics_DirectX")]
    pub fn PixelFormat(&self) -> ::windows_core::Result<super::super::Graphics::DirectX::DirectXPixelFormat> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).PixelFormat)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn SizeInt32(&self) -> ::windows_core::Result<super::super::Graphics::SizeInt32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).SizeInt32)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn GetDrawingSurfaceForLevel(&self, level: u32) -> ::windows_core::Result<CompositionDrawingSurface> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetDrawingSurfaceForLevel)(::windows_core::Interface::as_raw(this), level, &mut result__).from_abi(result__)
        }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionMipmapSurface {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionMipmapSurface;{4863675c-cf4a-4b1c-9ece-c5ec0c2b2fe6})");
}
unsafe impl ::windows_core::Interface for CompositionMipmapSurface {
    type Vtable = ICompositionMipmapSurface_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionMipmapSurface {
    const IID: ::windows_core::GUID = <ICompositionMipmapSurface as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionMipmapSurface {
    const NAME: &'static str = "Windows.UI.Composition.CompositionMipmapSurface";
}
::windows_core::imp::interface_hierarchy!(CompositionMipmapSurface, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionMipmapSurface {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionMipmapSurface {}
impl ::windows_core::CanTryInto<ICompositionSurface> for CompositionMipmapSurface {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionMipmapSurface {}
unsafe impl ::core::marker::Send for CompositionMipmapSurface {}
unsafe impl ::core::marker::Sync for CompositionMipmapSurface {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionNineGridBrush(::windows_core::IUnknown);
impl CompositionNineGridBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn BottomInset(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).BottomInset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetBottomInset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetBottomInset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn BottomInsetScale(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).BottomInsetScale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetBottomInsetScale(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetBottomInsetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn IsCenterHollow(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsCenterHollow)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIsCenterHollow(&self, value: bool) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetIsCenterHollow)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn LeftInset(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).LeftInset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetLeftInset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetLeftInset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn LeftInsetScale(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).LeftInsetScale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetLeftInsetScale(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetLeftInsetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RightInset(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RightInset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRightInset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRightInset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RightInsetScale(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RightInsetScale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRightInsetScale(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRightInsetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Source(&self) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Source)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetSource<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetSource)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn TopInset(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TopInset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTopInset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetTopInset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TopInsetScale(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TopInsetScale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTopInsetScale(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetTopInsetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn SetInsets(&self, inset: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetInsets)(::windows_core::Interface::as_raw(this), inset).ok() }
    }
    pub fn SetInsetsWithValues(&self, left: f32, top: f32, right: f32, bottom: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetInsetsWithValues)(::windows_core::Interface::as_raw(this), left, top, right, bottom).ok() }
    }
    pub fn SetInsetScales(&self, scale: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetInsetScales)(::windows_core::Interface::as_raw(this), scale).ok() }
    }
    pub fn SetInsetScalesWithValues(&self, left: f32, top: f32, right: f32, bottom: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetInsetScalesWithValues)(::windows_core::Interface::as_raw(this), left, top, right, bottom).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionNineGridBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionNineGridBrush;{f25154e4-bc8c-4be7-b80f-8685b83c0186})");
}
unsafe impl ::windows_core::Interface for CompositionNineGridBrush {
    type Vtable = ICompositionNineGridBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionNineGridBrush {
    const IID: ::windows_core::GUID = <ICompositionNineGridBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionNineGridBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionNineGridBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionNineGridBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionNineGridBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionNineGridBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionNineGridBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionNineGridBrush {}
unsafe impl ::core::marker::Send for CompositionNineGridBrush {}
unsafe impl ::core::marker::Sync for CompositionNineGridBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionObject(::windows_core::IUnknown);
impl CompositionObject {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn StartAnimationWithIAnimationObject<P0, P1>(target: P0, propertyname: &::windows_core::HSTRING, animation: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
        P1: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        Self::ICompositionObjectStatics(|this| unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithIAnimationObject)(::windows_core::Interface::as_raw(this), target.try_into_param()?.abi(), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() })
    }
    pub fn StartAnimationGroupWithIAnimationObject<P0, P1>(target: P0, animation: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<IAnimationObject>,
        P1: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        Self::ICompositionObjectStatics(|this| unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroupWithIAnimationObject)(::windows_core::Interface::as_raw(this), target.try_into_param()?.abi(), animation.try_into_param()?.abi()).ok() })
    }
    #[doc(hidden)]
    pub fn ICompositionObjectStatics<R, F: FnOnce(&ICompositionObjectStatics) -> ::windows_core::Result<R>>(callback: F) -> ::windows_core::Result<R> {
        static SHARED: ::windows_core::imp::FactoryCache<CompositionObject, ICompositionObjectStatics> = ::windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl ::windows_core::RuntimeType for CompositionObject {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionObject;{bcb4ad45-7609-4550-934f-16002a68fded})");
}
unsafe impl ::windows_core::Interface for CompositionObject {
    type Vtable = ICompositionObject_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionObject {
    const IID: ::windows_core::GUID = <ICompositionObject as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionObject {
    const NAME: &'static str = "Windows.UI.Composition.CompositionObject";
}
::windows_core::imp::interface_hierarchy!(CompositionObject, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionObject {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionObject {}
unsafe impl ::core::marker::Send for CompositionObject {}
unsafe impl ::core::marker::Sync for CompositionObject {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionPath(::windows_core::IUnknown);
impl CompositionPath {
    #[doc = "Required features: `\"Graphics\"`"]
    #[cfg(feature = "Graphics")]
    pub fn Create<P0>(source: P0) -> ::windows_core::Result<CompositionPath>
    where
        P0: ::windows_core::TryIntoParam<super::super::Graphics::IGeometrySource2D>,
    {
        Self::ICompositionPathFactory(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Create)(::windows_core::Interface::as_raw(this), source.try_into_param()?.abi(), &mut result__).from_abi(result__)
        })
    }
    #[doc(hidden)]
    pub fn ICompositionPathFactory<R, F: FnOnce(&ICompositionPathFactory) -> ::windows_core::Result<R>>(callback: F) -> ::windows_core::Result<R> {
        static SHARED: ::windows_core::imp::FactoryCache<CompositionPath, ICompositionPathFactory> = ::windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl ::windows_core::RuntimeType for CompositionPath {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionPath;{66da1d5f-2e10-4f22-8a06-0a8151919e60})");
}
unsafe impl ::windows_core::Interface for CompositionPath {
    type Vtable = ICompositionPath_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionPath {
    const IID: ::windows_core::GUID = <ICompositionPath as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionPath {
    const NAME: &'static str = "Windows.UI.Composition.CompositionPath";
}
::windows_core::imp::interface_hierarchy!(CompositionPath, ::windows_core::IUnknown, ::windows_core::IInspectable);
#[cfg(feature = "Graphics")]
impl ::windows_core::CanTryInto<super::super::Graphics::IGeometrySource2D> for CompositionPath {}
unsafe impl ::core::marker::Send for CompositionPath {}
unsafe impl ::core::marker::Sync for CompositionPath {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionPathGeometry(::windows_core::IUnknown);
impl CompositionPathGeometry {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimEnd)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimEnd)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimStart)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimStart)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn Path(&self) -> ::windows_core::Result<CompositionPath> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Path)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetPath<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionPath>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetPath)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionPathGeometry {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionPathGeometry;{0b6a417e-2c77-4c23-af5e-6304c147bb61})");
}
unsafe impl ::windows_core::Interface for CompositionPathGeometry {
    type Vtable = ICompositionPathGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionPathGeometry {
    const IID: ::windows_core::GUID = <ICompositionPathGeometry as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionPathGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionPathGeometry";
}
::windows_core::imp::interface_hierarchy!(CompositionPathGeometry, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionPathGeometry {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionPathGeometry {}
impl ::windows_core::CanTryInto<CompositionGeometry> for CompositionPathGeometry {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionPathGeometry {}
unsafe impl ::core::marker::Send for CompositionPathGeometry {}
unsafe impl ::core::marker::Sync for CompositionPathGeometry {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionProjectedShadow(::windows_core::IUnknown);
impl CompositionProjectedShadow {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn BlurRadiusMultiplier(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).BlurRadiusMultiplier)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetBlurRadiusMultiplier(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetBlurRadiusMultiplier)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Casters(&self) -> ::windows_core::Result<CompositionProjectedShadowCasterCollection> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Casters)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn LightSource(&self) -> ::windows_core::Result<CompositionLight> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).LightSource)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetLightSource<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionLight>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetLightSource)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn MaxBlurRadius(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MaxBlurRadius)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetMaxBlurRadius(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetMaxBlurRadius)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MinBlurRadius(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MinBlurRadius)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetMinBlurRadius(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetMinBlurRadius)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Receivers(&self) -> ::windows_core::Result<CompositionProjectedShadowReceiverUnorderedCollection> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Receivers)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
}
impl ::windows_core::RuntimeType for CompositionProjectedShadow {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionProjectedShadow;{285b8e72-4328-523f-bcf2-5557c52c3b25})");
}
unsafe impl ::windows_core::Interface for CompositionProjectedShadow {
    type Vtable = ICompositionProjectedShadow_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionProjectedShadow {
    const IID: ::windows_core::GUID = <ICompositionProjectedShadow as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionProjectedShadow {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadow";
}
::windows_core::imp::interface_hierarchy!(CompositionProjectedShadow, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionProjectedShadow {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionProjectedShadow {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionProjectedShadow {}
unsafe impl ::core::marker::Send for CompositionProjectedShadow {}
unsafe impl ::core::marker::Sync for CompositionProjectedShadow {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionProjectedShadowCaster(::windows_core::IUnknown);
impl CompositionProjectedShadowCaster {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn Brush(&self) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Brush)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetBrush<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetBrush)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn CastingVisual(&self) -> ::windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CastingVisual)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetCastingVisual<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<Visual>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetCastingVisual)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionProjectedShadowCaster {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionProjectedShadowCaster;{b1d7d426-1e36-5a62-be56-a16112fdd148})");
}
unsafe impl ::windows_core::Interface for CompositionProjectedShadowCaster {
    type Vtable = ICompositionProjectedShadowCaster_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionProjectedShadowCaster {
    const IID: ::windows_core::GUID = <ICompositionProjectedShadowCaster as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionProjectedShadowCaster {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowCaster";
}
::windows_core::imp::interface_hierarchy!(CompositionProjectedShadowCaster, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionProjectedShadowCaster {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionProjectedShadowCaster {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionProjectedShadowCaster {}
unsafe impl ::core::marker::Send for CompositionProjectedShadowCaster {}
unsafe impl ::core::marker::Sync for CompositionProjectedShadowCaster {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionProjectedShadowCasterCollection(::windows_core::IUnknown);
impl CompositionProjectedShadowCasterCollection {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn Count(&self) -> ::windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Count)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn InsertAbove<P0, P1>(&self, newcaster: P0, reference: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionProjectedShadowCaster>,
        P1: ::windows_core::IntoParam<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertAbove)(::windows_core::Interface::as_raw(this), newcaster.into_param().abi(), reference.into_param().abi()).ok() }
    }
    pub fn InsertAtBottom<P0>(&self, newcaster: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertAtBottom)(::windows_core::Interface::as_raw(this), newcaster.into_param().abi()).ok() }
    }
    pub fn InsertAtTop<P0>(&self, newcaster: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertAtTop)(::windows_core::Interface::as_raw(this), newcaster.into_param().abi()).ok() }
    }
    pub fn InsertBelow<P0, P1>(&self, newcaster: P0, reference: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionProjectedShadowCaster>,
        P1: ::windows_core::IntoParam<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertBelow)(::windows_core::Interface::as_raw(this), newcaster.into_param().abi(), reference.into_param().abi()).ok() }
    }
    pub fn Remove<P0>(&self, caster: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionProjectedShadowCaster>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Remove)(::windows_core::Interface::as_raw(this), caster.into_param().abi()).ok() }
    }
    pub fn RemoveAll(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAll)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn MaxRespectedCasters() -> ::windows_core::Result<i32> {
        Self::ICompositionProjectedShadowCasterCollectionStatics(|this| unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MaxRespectedCasters)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        })
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn First(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionProjectedShadowCaster>> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IIterable<CompositionProjectedShadowCaster>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).First)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc(hidden)]
    pub fn ICompositionProjectedShadowCasterCollectionStatics<R, F: FnOnce(&ICompositionProjectedShadowCasterCollectionStatics) -> ::windows_core::Result<R>>(callback: F) -> ::windows_core::Result<R> {
        static SHARED: ::windows_core::imp::FactoryCache<CompositionProjectedShadowCasterCollection, ICompositionProjectedShadowCasterCollectionStatics> = ::windows_core::imp::FactoryCache::new();
        SHARED.call(callback)
    }
}
impl ::windows_core::RuntimeType for CompositionProjectedShadowCasterCollection {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionProjectedShadowCasterCollection;{d2525c0c-e07f-58a3-ac91-37f73ee91740})");
}
unsafe impl ::windows_core::Interface for CompositionProjectedShadowCasterCollection {
    type Vtable = ICompositionProjectedShadowCasterCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionProjectedShadowCasterCollection {
    const IID: ::windows_core::GUID = <ICompositionProjectedShadowCasterCollection as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionProjectedShadowCasterCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowCasterCollection";
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for CompositionProjectedShadowCasterCollection {
    type Item = CompositionProjectedShadowCaster;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        ::core::iter::IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for &CompositionProjectedShadowCasterCollection {
    type Item = CompositionProjectedShadowCaster;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
::windows_core::imp::interface_hierarchy!(CompositionProjectedShadowCasterCollection, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionProjectedShadowCasterCollection {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionProjectedShadowCasterCollection {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IIterable<CompositionProjectedShadowCaster>> for CompositionProjectedShadowCasterCollection {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionProjectedShadowCasterCollection {}
unsafe impl ::core::marker::Send for CompositionProjectedShadowCasterCollection {}
unsafe impl ::core::marker::Sync for CompositionProjectedShadowCasterCollection {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionProjectedShadowReceiver(::windows_core::IUnknown);
impl CompositionProjectedShadowReceiver {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn ReceivingVisual(&self) -> ::windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ReceivingVisual)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetReceivingVisual<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<Visual>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetReceivingVisual)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionProjectedShadowReceiver {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionProjectedShadowReceiver;{1377985a-6a49-536a-9be4-a96a8e5298a9})");
}
unsafe impl ::windows_core::Interface for CompositionProjectedShadowReceiver {
    type Vtable = ICompositionProjectedShadowReceiver_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionProjectedShadowReceiver {
    const IID: ::windows_core::GUID = <ICompositionProjectedShadowReceiver as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionProjectedShadowReceiver {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowReceiver";
}
::windows_core::imp::interface_hierarchy!(CompositionProjectedShadowReceiver, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionProjectedShadowReceiver {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionProjectedShadowReceiver {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionProjectedShadowReceiver {}
unsafe impl ::core::marker::Send for CompositionProjectedShadowReceiver {}
unsafe impl ::core::marker::Sync for CompositionProjectedShadowReceiver {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionProjectedShadowReceiverUnorderedCollection(::windows_core::IUnknown);
impl CompositionProjectedShadowReceiverUnorderedCollection {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn Add<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionProjectedShadowReceiver>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Add)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn Count(&self) -> ::windows_core::Result<i32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Count)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Remove<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<CompositionProjectedShadowReceiver>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Remove)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn RemoveAll(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAll)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn First(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionProjectedShadowReceiver>> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IIterable<CompositionProjectedShadowReceiver>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).First)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
}
impl ::windows_core::RuntimeType for CompositionProjectedShadowReceiverUnorderedCollection {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionProjectedShadowReceiverUnorderedCollection;{02b3e3b7-27d2-599f-ac4b-ab787cdde6fd})");
}
unsafe impl ::windows_core::Interface for CompositionProjectedShadowReceiverUnorderedCollection {
    type Vtable = ICompositionProjectedShadowReceiverUnorderedCollection_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionProjectedShadowReceiverUnorderedCollection {
    const IID: ::windows_core::GUID = <ICompositionProjectedShadowReceiverUnorderedCollection as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionProjectedShadowReceiverUnorderedCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionProjectedShadowReceiverUnorderedCollection";
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for CompositionProjectedShadowReceiverUnorderedCollection {
    type Item = CompositionProjectedShadowReceiver;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        ::core::iter::IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for &CompositionProjectedShadowReceiverUnorderedCollection {
    type Item = CompositionProjectedShadowReceiver;
    type IntoIter = super::super::Foundation::Collections::IIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        self.First().unwrap()
    }
}
::windows_core::imp::interface_hierarchy!(CompositionProjectedShadowReceiverUnorderedCollection, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionProjectedShadowReceiverUnorderedCollection {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionProjectedShadowReceiverUnorderedCollection {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IIterable<CompositionProjectedShadowReceiver>> for CompositionProjectedShadowReceiverUnorderedCollection {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionProjectedShadowReceiverUnorderedCollection {}
unsafe impl ::core::marker::Send for CompositionProjectedShadowReceiverUnorderedCollection {}
unsafe impl ::core::marker::Sync for CompositionProjectedShadowReceiverUnorderedCollection {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionPropertySet(::windows_core::IUnknown);
impl CompositionPropertySet {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn InsertColor(&self, propertyname: &::windows_core::HSTRING, value: super::Color) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertColor)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertMatrix3x2(&self, propertyname: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertMatrix3x2)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertMatrix4x4(&self, propertyname: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertMatrix4x4)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertQuaternion(&self, propertyname: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertQuaternion)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    pub fn InsertScalar(&self, propertyname: &::windows_core::HSTRING, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertScalar)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertVector2(&self, propertyname: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertVector2)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertVector3(&self, propertyname: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertVector3)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn InsertVector4(&self, propertyname: &::windows_core::HSTRING, value: super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertVector4)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    pub fn TryGetColor(&self, propertyname: &::windows_core::HSTRING, value: &mut super::Color) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetColor)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetMatrix3x2(&self, propertyname: &::windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetMatrix3x2)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetMatrix4x4(&self, propertyname: &::windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Matrix4x4) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetMatrix4x4)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetQuaternion(&self, propertyname: &::windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Quaternion) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetQuaternion)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetScalar(&self, propertyname: &::windows_core::HSTRING, value: &mut f32) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetScalar)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetVector2(&self, propertyname: &::windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetVector2)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetVector3(&self, propertyname: &::windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Vector3) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetVector3)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TryGetVector4(&self, propertyname: &::windows_core::HSTRING, value: &mut super::super::Foundation::Numerics::Vector4) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetVector4)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
    pub fn InsertBoolean(&self, propertyname: &::windows_core::HSTRING, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionPropertySet2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).InsertBoolean)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value).ok() }
    }
    pub fn TryGetBoolean(&self, propertyname: &::windows_core::HSTRING, value: &mut bool) -> ::windows_core::Result<CompositionGetValueStatus> {
        let this = &::windows_core::ComInterface::cast::<ICompositionPropertySet2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetBoolean)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), value, &mut result__).from_abi(result__)
        }
    }
}
impl ::windows_core::RuntimeType for CompositionPropertySet {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionPropertySet;{c9d6d202-5f67-4453-9117-9eadd430d3c2})");
}
unsafe impl ::windows_core::Interface for CompositionPropertySet {
    type Vtable = ICompositionPropertySet_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionPropertySet {
    const IID: ::windows_core::GUID = <ICompositionPropertySet as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionPropertySet {
    const NAME: &'static str = "Windows.UI.Composition.CompositionPropertySet";
}
::windows_core::imp::interface_hierarchy!(CompositionPropertySet, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionPropertySet {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionPropertySet {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionPropertySet {}
unsafe impl ::core::marker::Send for CompositionPropertySet {}
unsafe impl ::core::marker::Sync for CompositionPropertySet {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionRadialGradientBrush(::windows_core::IUnknown);
impl CompositionRadialGradientBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AnchorPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetAnchorPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn ColorStops(&self) -> ::windows_core::Result<CompositionColorGradientStopCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ColorStops)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn ExtendMode(&self) -> ::windows_core::Result<CompositionGradientExtendMode> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ExtendMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetExtendMode(&self, value: CompositionGradientExtendMode) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetExtendMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn InterpolationSpace(&self) -> ::windows_core::Result<CompositionColorSpace> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).InterpolationSpace)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetInterpolationSpace(&self, value: CompositionColorSpace) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetInterpolationSpace)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn MappingMode(&self) -> ::windows_core::Result<CompositionMappingMode> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).MappingMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetMappingMode(&self, value: CompositionMappingMode) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGradientBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetMappingMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn EllipseCenter(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).EllipseCenter)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEllipseCenter(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetEllipseCenter)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn EllipseRadius(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).EllipseRadius)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetEllipseRadius(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetEllipseRadius)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn GradientOriginOffset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GradientOriginOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetGradientOriginOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetGradientOriginOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionRadialGradientBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionRadialGradientBrush;{3d3b50c5-e3fa-4ce2-b9fc-3ee12561788f})");
}
unsafe impl ::windows_core::Interface for CompositionRadialGradientBrush {
    type Vtable = ICompositionRadialGradientBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionRadialGradientBrush {
    const IID: ::windows_core::GUID = <ICompositionRadialGradientBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionRadialGradientBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionRadialGradientBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionRadialGradientBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionRadialGradientBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionRadialGradientBrush {}
impl ::windows_core::CanTryInto<CompositionGradientBrush> for CompositionRadialGradientBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionRadialGradientBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionRadialGradientBrush {}
unsafe impl ::core::marker::Send for CompositionRadialGradientBrush {}
unsafe impl ::core::marker::Sync for CompositionRadialGradientBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionRectangleGeometry(::windows_core::IUnknown);
impl CompositionRectangleGeometry {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimEnd)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimEnd)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimStart)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimStart)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Size(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Size)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSize(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetSize)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionRectangleGeometry {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionRectangleGeometry;{0cd51428-5356-4246-aecf-7a0b76975400})");
}
unsafe impl ::windows_core::Interface for CompositionRectangleGeometry {
    type Vtable = ICompositionRectangleGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionRectangleGeometry {
    const IID: ::windows_core::GUID = <ICompositionRectangleGeometry as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionRectangleGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionRectangleGeometry";
}
::windows_core::imp::interface_hierarchy!(CompositionRectangleGeometry, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionRectangleGeometry {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionRectangleGeometry {}
impl ::windows_core::CanTryInto<CompositionGeometry> for CompositionRectangleGeometry {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionRectangleGeometry {}
unsafe impl ::core::marker::Send for CompositionRectangleGeometry {}
unsafe impl ::core::marker::Sync for CompositionRectangleGeometry {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionRoundedRectangleGeometry(::windows_core::IUnknown);
impl CompositionRoundedRectangleGeometry {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn TrimEnd(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimEnd)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimEnd(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimEnd)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimOffset(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn TrimStart(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TrimStart)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetTrimStart(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionGeometry>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTrimStart)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CornerRadius(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CornerRadius)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCornerRadius(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetCornerRadius)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Size(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Size)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetSize(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetSize)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionRoundedRectangleGeometry {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionRoundedRectangleGeometry;{8770c822-1d50-4b8b-b013-7c9a0e46935f})");
}
unsafe impl ::windows_core::Interface for CompositionRoundedRectangleGeometry {
    type Vtable = ICompositionRoundedRectangleGeometry_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionRoundedRectangleGeometry {
    const IID: ::windows_core::GUID = <ICompositionRoundedRectangleGeometry as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionRoundedRectangleGeometry {
    const NAME: &'static str = "Windows.UI.Composition.CompositionRoundedRectangleGeometry";
}
::windows_core::imp::interface_hierarchy!(CompositionRoundedRectangleGeometry, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionRoundedRectangleGeometry {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionRoundedRectangleGeometry {}
impl ::windows_core::CanTryInto<CompositionGeometry> for CompositionRoundedRectangleGeometry {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionRoundedRectangleGeometry {}
unsafe impl ::core::marker::Send for CompositionRoundedRectangleGeometry {}
unsafe impl ::core::marker::Sync for CompositionRoundedRectangleGeometry {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionScopedBatch(::windows_core::IUnknown);
impl CompositionScopedBatch {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn IsActive(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsActive)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn IsEnded(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsEnded)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn End(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).End)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Resume(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Resume)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Suspend(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Suspend)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Completed<P0>(&self, handler: P0) -> ::windows_core::Result<super::super::Foundation::EventRegistrationToken>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::TypedEventHandler<::windows_core::IInspectable, CompositionBatchCompletedEventArgs>>,
    {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Completed)(::windows_core::Interface::as_raw(this), handler.into_param().abi(), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn RemoveCompleted(&self, token: super::super::Foundation::EventRegistrationToken) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveCompleted)(::windows_core::Interface::as_raw(this), token).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionScopedBatch {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionScopedBatch;{0d00dad0-fb07-46fd-8c72-6280d1a3d1dd})");
}
unsafe impl ::windows_core::Interface for CompositionScopedBatch {
    type Vtable = ICompositionScopedBatch_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionScopedBatch {
    const IID: ::windows_core::GUID = <ICompositionScopedBatch as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionScopedBatch {
    const NAME: &'static str = "Windows.UI.Composition.CompositionScopedBatch";
}
::windows_core::imp::interface_hierarchy!(CompositionScopedBatch, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionScopedBatch {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionScopedBatch {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionScopedBatch {}
unsafe impl ::core::marker::Send for CompositionScopedBatch {}
unsafe impl ::core::marker::Sync for CompositionScopedBatch {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionShadow(::windows_core::IUnknown);
impl CompositionShadow {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionShadow {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionShadow;{329e52e2-4335-49cc-b14a-37782d10f0c4})");
}
unsafe impl ::windows_core::Interface for CompositionShadow {
    type Vtable = ICompositionShadow_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionShadow {
    const IID: ::windows_core::GUID = <ICompositionShadow as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionShadow {
    const NAME: &'static str = "Windows.UI.Composition.CompositionShadow";
}
::windows_core::imp::interface_hierarchy!(CompositionShadow, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionShadow {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionShadow {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionShadow {}
unsafe impl ::core::marker::Send for CompositionShadow {}
unsafe impl ::core::marker::Sync for CompositionShadow {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionShape(::windows_core::IUnknown);
impl CompositionShape {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionShape {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionShape;{b47ce2f7-9a88-42c4-9e87-2e500ca8688c})");
}
unsafe impl ::windows_core::Interface for CompositionShape {
    type Vtable = ICompositionShape_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionShape {
    const IID: ::windows_core::GUID = <ICompositionShape as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionShape {
    const NAME: &'static str = "Windows.UI.Composition.CompositionShape";
}
::windows_core::imp::interface_hierarchy!(CompositionShape, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionShape {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionShape {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionShape {}
unsafe impl ::core::marker::Send for CompositionShape {}
unsafe impl ::core::marker::Sync for CompositionShape {}
#[doc = "Required features: `\"Foundation_Collections\"`"]
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionShapeCollection(::windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
impl CompositionShapeCollection {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn First(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IIterator<CompositionShape>> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IIterable<CompositionShape>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).First)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetAt(&self, index: u32) -> ::windows_core::Result<CompositionShape> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetAt)(::windows_core::Interface::as_raw(this), index, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Size(&self) -> ::windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Size)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetView(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IVectorView<CompositionShape>> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetView)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn IndexOf<P0>(&self, value: P0, index: &mut u32) -> ::windows_core::Result<bool>
    where
        P0: ::windows_core::TryIntoParam<CompositionShape>,
    {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IndexOf)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi(), index, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetAt<P0>(&self, index: u32, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionShape>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetAt)(::windows_core::Interface::as_raw(this), index, value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InsertAt<P0>(&self, index: u32, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionShape>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertAt)(::windows_core::Interface::as_raw(this), index, value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn RemoveAt(&self, index: u32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAt)(::windows_core::Interface::as_raw(this), index).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Append<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionShape>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Append)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn RemoveAtEnd(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAtEnd)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Clear(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Clear)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetMany(&self, startindex: u32, items: &mut [::core::option::Option<CompositionShape>]) -> ::windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetMany)(::windows_core::Interface::as_raw(this), startindex, items.len().try_into().unwrap(), ::core::mem::transmute_copy(&items), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn ReplaceAll(&self, items: &[::core::option::Option<CompositionShape>]) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).ReplaceAll)(::windows_core::Interface::as_raw(this), items.len().try_into().unwrap(), ::core::mem::transmute(items.as_ptr())).ok() }
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::RuntimeType for CompositionShapeCollection {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionShapeCollection;pinterface({913337e9-11a1-4345-a3a2-4e7f956e222d};rc(Windows.UI.Composition.CompositionShape;{b47ce2f7-9a88-42c4-9e87-2e500ca8688c})))");
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::windows_core::Interface for CompositionShapeCollection {
    type Vtable = super::super::Foundation::Collections::IVector_Vtbl<CompositionShape>;
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::windows_core::ComInterface for CompositionShapeCollection {
    const IID: ::windows_core::GUID = <super::super::Foundation::Collections::IVector<CompositionShape> as ::windows_core::ComInterface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::RuntimeName for CompositionShapeCollection {
    const NAME: &'static str = "Windows.UI.Composition.CompositionShapeCollection";
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for CompositionShapeCollection {
    type Item = CompositionShape;
    type IntoIter = super::super::Foundation::Collections::VectorIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        ::core::iter::IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for &CompositionShapeCollection {
    type Item = CompositionShape;
    type IntoIter = super::super::Foundation::Collections::VectorIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        super::super::Foundation::Collections::VectorIterator::new(::windows_core::ComInterface::cast(self).ok())
    }
}
#[cfg(feature = "Foundation_Collections")]
::windows_core::imp::interface_hierarchy!(CompositionShapeCollection, ::windows_core::IUnknown, ::windows_core::IInspectable);
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IIterable<CompositionShape>> for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IVector<CompositionShape>> for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<CompositionObject> for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::core::marker::Send for CompositionShapeCollection {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::core::marker::Sync for CompositionShapeCollection {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionSpriteShape(::windows_core::IUnknown);
impl CompositionSpriteShape {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionShape>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn FillBrush(&self) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).FillBrush)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetFillBrush<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetFillBrush)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn Geometry(&self) -> ::windows_core::Result<CompositionGeometry> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Geometry)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetGeometry<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionGeometry>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetGeometry)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn IsStrokeNonScaling(&self) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IsStrokeNonScaling)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetIsStrokeNonScaling(&self, value: bool) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetIsStrokeNonScaling)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeBrush(&self) -> ::windows_core::Result<CompositionBrush> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeBrush)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeBrush<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionBrush>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeBrush)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn StrokeDashArray(&self) -> ::windows_core::Result<CompositionStrokeDashArray> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeDashArray)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StrokeDashCap(&self) -> ::windows_core::Result<CompositionStrokeCap> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeDashCap)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeDashCap(&self, value: CompositionStrokeCap) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeDashCap)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeDashOffset(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeDashOffset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeDashOffset(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeDashOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeEndCap(&self) -> ::windows_core::Result<CompositionStrokeCap> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeEndCap)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeEndCap(&self, value: CompositionStrokeCap) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeEndCap)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeLineJoin(&self) -> ::windows_core::Result<CompositionStrokeLineJoin> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeLineJoin)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeLineJoin(&self, value: CompositionStrokeLineJoin) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeLineJoin)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeMiterLimit(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeMiterLimit)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeMiterLimit(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeMiterLimit)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeStartCap(&self) -> ::windows_core::Result<CompositionStrokeCap> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeStartCap)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeStartCap(&self, value: CompositionStrokeCap) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeStartCap)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn StrokeThickness(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).StrokeThickness)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStrokeThickness(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStrokeThickness)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionSpriteShape {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionSpriteShape;{401b61bb-0007-4363-b1f3-6bcc003fb83e})");
}
unsafe impl ::windows_core::Interface for CompositionSpriteShape {
    type Vtable = ICompositionSpriteShape_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionSpriteShape {
    const IID: ::windows_core::GUID = <ICompositionSpriteShape as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionSpriteShape {
    const NAME: &'static str = "Windows.UI.Composition.CompositionSpriteShape";
}
::windows_core::imp::interface_hierarchy!(CompositionSpriteShape, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionSpriteShape {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionSpriteShape {}
impl ::windows_core::CanTryInto<CompositionShape> for CompositionSpriteShape {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionSpriteShape {}
unsafe impl ::core::marker::Send for CompositionSpriteShape {}
unsafe impl ::core::marker::Sync for CompositionSpriteShape {}
#[doc = "Required features: `\"Foundation_Collections\"`"]
#[cfg(feature = "Foundation_Collections")]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionStrokeDashArray(::windows_core::IUnknown);
#[cfg(feature = "Foundation_Collections")]
impl CompositionStrokeDashArray {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn First(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IIterator<f32>> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::Collections::IIterable<f32>>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).First)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetAt(&self, index: u32) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetAt)(::windows_core::Interface::as_raw(this), index, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Size(&self) -> ::windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Size)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetView(&self) -> ::windows_core::Result<super::super::Foundation::Collections::IVectorView<f32>> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetView)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn IndexOf(&self, value: f32, index: &mut u32) -> ::windows_core::Result<bool> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).IndexOf)(::windows_core::Interface::as_raw(this), value, index, &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn SetAt(&self, index: u32, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetAt)(::windows_core::Interface::as_raw(this), index, value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn InsertAt(&self, index: u32, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).InsertAt)(::windows_core::Interface::as_raw(this), index, value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn RemoveAt(&self, index: u32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAt)(::windows_core::Interface::as_raw(this), index).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Append(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Append)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn RemoveAtEnd(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).RemoveAtEnd)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn Clear(&self) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).Clear)(::windows_core::Interface::as_raw(this)).ok() }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn GetMany(&self, startindex: u32, items: &mut [f32]) -> ::windows_core::Result<u32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).GetMany)(::windows_core::Interface::as_raw(this), startindex, items.len().try_into().unwrap(), items.as_mut_ptr(), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Collections\"`"]
    #[cfg(feature = "Foundation_Collections")]
    pub fn ReplaceAll(&self, items: &[f32]) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).ReplaceAll)(::windows_core::Interface::as_raw(this), items.len().try_into().unwrap(), items.as_ptr()).ok() }
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::RuntimeType for CompositionStrokeDashArray {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionStrokeDashArray;pinterface({913337e9-11a1-4345-a3a2-4e7f956e222d};f4))");
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::windows_core::Interface for CompositionStrokeDashArray {
    type Vtable = super::super::Foundation::Collections::IVector_Vtbl<f32>;
}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::windows_core::ComInterface for CompositionStrokeDashArray {
    const IID: ::windows_core::GUID = <super::super::Foundation::Collections::IVector<f32> as ::windows_core::ComInterface>::IID;
}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::RuntimeName for CompositionStrokeDashArray {
    const NAME: &'static str = "Windows.UI.Composition.CompositionStrokeDashArray";
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for CompositionStrokeDashArray {
    type Item = f32;
    type IntoIter = super::super::Foundation::Collections::VectorIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        ::core::iter::IntoIterator::into_iter(&self)
    }
}
#[cfg(feature = "Foundation_Collections")]
impl ::core::iter::IntoIterator for &CompositionStrokeDashArray {
    type Item = f32;
    type IntoIter = super::super::Foundation::Collections::VectorIterator<Self::Item>;
    fn into_iter(self) -> Self::IntoIter {
        super::super::Foundation::Collections::VectorIterator::new(::windows_core::ComInterface::cast(self).ok())
    }
}
#[cfg(feature = "Foundation_Collections")]
::windows_core::imp::interface_hierarchy!(CompositionStrokeDashArray, ::windows_core::IUnknown, ::windows_core::IInspectable);
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IIterable<f32>> for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<super::super::Foundation::Collections::IVector<f32>> for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
impl ::windows_core::CanTryInto<CompositionObject> for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::core::marker::Send for CompositionStrokeDashArray {}
#[cfg(feature = "Foundation_Collections")]
unsafe impl ::core::marker::Sync for CompositionStrokeDashArray {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionSurfaceBrush(::windows_core::IUnknown);
impl CompositionSurfaceBrush {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn BitmapInterpolationMode(&self) -> ::windows_core::Result<CompositionBitmapInterpolationMode> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).BitmapInterpolationMode)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetBitmapInterpolationMode(&self, value: CompositionBitmapInterpolationMode) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetBitmapInterpolationMode)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn HorizontalAlignmentRatio(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).HorizontalAlignmentRatio)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetHorizontalAlignmentRatio(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetHorizontalAlignmentRatio)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Stretch(&self) -> ::windows_core::Result<CompositionStretch> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Stretch)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetStretch(&self, value: CompositionStretch) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetStretch)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn Surface(&self) -> ::windows_core::Result<ICompositionSurface> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Surface)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetSurface<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionSurface>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetSurface)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn VerticalAlignmentRatio(&self) -> ::windows_core::Result<f32> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).VerticalAlignmentRatio)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetVerticalAlignmentRatio(&self, value: f32) -> ::windows_core::Result<()> {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetVerticalAlignmentRatio)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn AnchorPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).AnchorPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetAnchorPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetAnchorPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn CenterPoint(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).CenterPoint)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetCenterPoint(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetCenterPoint)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Offset(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Offset)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetOffset(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetOffset)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngle(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngle)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngle(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngle)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn RotationAngleInDegrees(&self) -> ::windows_core::Result<f32> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).RotationAngleInDegrees)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRotationAngleInDegrees(&self, value: f32) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetRotationAngleInDegrees)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn Scale(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Vector2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Scale)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetScale(&self, value: super::super::Foundation::Numerics::Vector2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetScale)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn TransformMatrix(&self) -> ::windows_core::Result<super::super::Foundation::Numerics::Matrix3x2> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TransformMatrix)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"Foundation_Numerics\"`"]
    #[cfg(feature = "Foundation_Numerics")]
    pub fn SetTransformMatrix(&self, value: super::super::Foundation::Numerics::Matrix3x2) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetTransformMatrix)(::windows_core::Interface::as_raw(this), value).ok() }
    }
    pub fn SnapToPixels(&self) -> ::windows_core::Result<bool> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).SnapToPixels)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetSnapToPixels(&self, value: bool) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionSurfaceBrush3>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetSnapToPixels)(::windows_core::Interface::as_raw(this), value).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionSurfaceBrush {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionSurfaceBrush;{ad016d79-1e4c-4c0d-9c29-83338c87c162})");
}
unsafe impl ::windows_core::Interface for CompositionSurfaceBrush {
    type Vtable = ICompositionSurfaceBrush_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionSurfaceBrush {
    const IID: ::windows_core::GUID = <ICompositionSurfaceBrush as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionSurfaceBrush {
    const NAME: &'static str = "Windows.UI.Composition.CompositionSurfaceBrush";
}
::windows_core::imp::interface_hierarchy!(CompositionSurfaceBrush, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionSurfaceBrush {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionSurfaceBrush {}
impl ::windows_core::CanTryInto<CompositionBrush> for CompositionSurfaceBrush {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionSurfaceBrush {}
unsafe impl ::core::marker::Send for CompositionSurfaceBrush {}
unsafe impl ::core::marker::Sync for CompositionSurfaceBrush {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionTarget(::windows_core::IUnknown);
impl CompositionTarget {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::<IAnimationObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).PopulatePropertyInfo)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), propertyinfo.into_param().abi()).ok() }
    }
    #[doc = "Required features: `\"Foundation\"`"]
    #[cfg(feature = "Foundation")]
    pub fn Close(&self) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<super::super::Foundation::IClosable>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).Close)(::windows_core::Interface::as_raw(this)).ok() }
    }
    pub fn Compositor(&self) -> ::windows_core::Result<Compositor> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Compositor)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    #[doc = "Required features: `\"UI_Core\"`"]
    #[cfg(feature = "UI_Core")]
    pub fn Dispatcher(&self) -> ::windows_core::Result<super::Core::CoreDispatcher> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Dispatcher)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn Properties(&self) -> ::windows_core::Result<CompositionPropertySet> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Properties)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimation<P0>(&self, propertyname: &::windows_core::HSTRING, animation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimation(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimation)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname)).ok() }
    }
    pub fn Comment(&self) -> ::windows_core::Result<::windows_core::HSTRING> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Comment)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetComment(&self, value: &::windows_core::HSTRING) -> ::windows_core::Result<()> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetComment)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(value)).ok() }
    }
    pub fn ImplicitAnimations(&self) -> ::windows_core::Result<ImplicitAnimationCollection> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).ImplicitAnimations)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetImplicitAnimations<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ImplicitAnimationCollection>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).SetImplicitAnimations)(::windows_core::Interface::as_raw(this), value.into_param().abi()).ok() }
    }
    pub fn StartAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    pub fn StopAnimationGroup<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<ICompositionAnimationBase>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject2>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StopAnimationGroup)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
    #[doc = "Required features: `\"System\"`"]
    #[cfg(feature = "System")]
    pub fn DispatcherQueue(&self) -> ::windows_core::Result<super::super::System::DispatcherQueue> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject3>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).DispatcherQueue)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn TryGetAnimationController(&self, propertyname: &::windows_core::HSTRING) -> ::windows_core::Result<AnimationController> {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject4>(self)?;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).TryGetAnimationController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), &mut result__).from_abi(result__)
        }
    }
    pub fn StartAnimationWithController<P0, P1>(&self, propertyname: &::windows_core::HSTRING, animation: P0, animationcontroller: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<CompositionAnimation>,
        P1: ::windows_core::IntoParam<AnimationController>,
    {
        let this = &::windows_core::ComInterface::cast::<ICompositionObject5>(self)?;
        unsafe { (::windows_core::Interface::vtable(this).StartAnimationWithController)(::windows_core::Interface::as_raw(this), ::core::mem::transmute_copy(propertyname), animation.try_into_param()?.abi(), animationcontroller.into_param().abi()).ok() }
    }
    pub fn Root(&self) -> ::windows_core::Result<Visual> {
        let this = self;
        unsafe {
            let mut result__ = ::std::mem::zeroed();
            (::windows_core::Interface::vtable(this).Root)(::windows_core::Interface::as_raw(this), &mut result__).from_abi(result__)
        }
    }
    pub fn SetRoot<P0>(&self, value: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::TryIntoParam<Visual>,
    {
        let this = self;
        unsafe { (::windows_core::Interface::vtable(this).SetRoot)(::windows_core::Interface::as_raw(this), value.try_into_param()?.abi()).ok() }
    }
}
impl ::windows_core::RuntimeType for CompositionTarget {
    const SIGNATURE: ::windows_core::imp::ConstBuffer = ::windows_core::imp::ConstBuffer::from_slice(b"rc(Windows.UI.Composition.CompositionTarget;{a1bea8ba-d726-4663-8129-6b5e7927ffa6})");
}
unsafe impl ::windows_core::Interface for CompositionTarget {
    type Vtable = ICompositionTarget_Vtbl;
}
unsafe impl ::windows_core::ComInterface for CompositionTarget {
    const IID: ::windows_core::GUID = <ICompositionTarget as ::windows_core::ComInterface>::IID;
}
impl ::windows_core::RuntimeName for CompositionTarget {
    const NAME: &'static str = "Windows.UI.Composition.CompositionTarget";
}
::windows_core::imp::interface_hierarchy!(CompositionTarget, ::windows_core::IUnknown, ::windows_core::IInspectable);
impl ::windows_core::CanTryInto<IAnimationObject> for CompositionTarget {}
#[cfg(feature = "Foundation")]
impl ::windows_core::CanTryInto<super::super::Foundation::IClosable> for CompositionTarget {}
impl ::windows_core::CanTryInto<CompositionObject> for CompositionTarget {}
unsafe impl ::core::marker::Send for CompositionTarget {}
unsafe impl ::core::marker::Sync for CompositionTarget {}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::fmt::Debug, ::core::clone::Clone)]
pub struct CompositionTransform(::windows_core::IUnknown);
impl CompositionTransform {
    pub fn PopulatePropertyInfo<P0>(&self, propertyname: &::windows_core::HSTRING, propertyinfo: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<AnimationPropertyInfo>,
    {
        let this = &::windows_core::ComInterface::cast::