mod ace;
mod highlightjs;
mod rouge;
mod sublime;
mod vim;
mod vscode;
pub use ace::Ace;
pub use highlightjs::Highlightjs;
pub use rouge::Rouge;
pub use sublime::Sublime;
pub use vim::Vim;
pub use vscode::Vscode;

use crate::keywords::Keywords;
use std::path::PathBuf;

pub trait Template {
    fn apply(&self, keywords: &Keywords) -> String;
    fn path(&self) -> PathBuf;
}
