/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.SimpleUsageMarker;
import proguard.util.Processable;

public class ShortestUsageMarker
extends SimpleUsageMarker {
    public ShortestUsageMark currentUsageMark;
    private final MyReferenceChecker referenceChecker = new MyReferenceChecker();

    public void setCurrentUsageMark(ShortestUsageMark currentUsageMark) {
        this.currentUsageMark = currentUsageMark;
    }

    @Override
    public void markAsUsed(Processable processable) {
        Object processingInfo = processable.getProcessingInfo();
        ShortestUsageMark shortestUsageMark = processingInfo instanceof ShortestUsageMark && !((ShortestUsageMark)processingInfo).isCertain() && !this.currentUsageMark.isShorter((ShortestUsageMark)processingInfo) ? new ShortestUsageMark((ShortestUsageMark)processingInfo, true) : this.currentUsageMark;
        processable.setProcessingInfo((Object)shortestUsageMark);
    }

    @Override
    public boolean isUsed(Processable processable) {
        Object processingInfo = processable.getProcessingInfo();
        return processingInfo != null && processingInfo instanceof ShortestUsageMark && ((ShortestUsageMark)processingInfo).isCertain();
    }

    public boolean shouldBeMarkedAsUsed(ProgramClass programClass) {
        Object processingInfo = programClass.getProcessingInfo();
        return processingInfo == null || !(processingInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)processingInfo).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)processingInfo) && !this.referencesClassMember(this.currentUsageMark, (Clazz)programClass);
    }

    public boolean shouldBeMarkedAsUsed(ProgramClass programClass, ProgramMember programMember) {
        Object processingInfo = programMember.getProcessingInfo();
        return processingInfo == null || !(processingInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)processingInfo).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)processingInfo) && !this.referencesClass(this.currentUsageMark, (Clazz)programClass);
    }

    public boolean shouldBeMarkedAsUsed(Processable processable) {
        Object processingInfo = processable.getProcessingInfo();
        return processingInfo == null || !(processingInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)processingInfo).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)processingInfo);
    }

    @Override
    public void markAsPossiblyUsed(Processable processable) {
        processable.setProcessingInfo((Object)new ShortestUsageMark(this.currentUsageMark, false));
    }

    public boolean shouldBeMarkedAsPossiblyUsed(ProgramClass programClass, ProgramMember programMember) {
        Object processingInfo = programMember.getProcessingInfo();
        return processingInfo == null || !(processingInfo instanceof ShortestUsageMark) || this.currentUsageMark.isShorter((ShortestUsageMark)processingInfo) && !((ShortestUsageMark)processingInfo).isCertain() && !this.referencesClass(this.currentUsageMark, (Clazz)programClass);
    }

    public boolean shouldBeMarkedAsPossiblyUsed(Processable processable) {
        Object processingInfo = processable.getProcessingInfo();
        return processingInfo == null || !(processingInfo instanceof ShortestUsageMark) || this.currentUsageMark.isShorter((ShortestUsageMark)processingInfo) && !((ShortestUsageMark)processingInfo).isCertain();
    }

    @Override
    public boolean isPossiblyUsed(Processable processable) {
        Object processingInfo = processable.getProcessingInfo();
        return processingInfo != null && processingInfo instanceof ShortestUsageMark && !((ShortestUsageMark)processingInfo).isCertain();
    }

    protected ShortestUsageMark getShortestUsageMark(Processable processable) {
        Object processingInfo = processable.getProcessingInfo();
        return (ShortestUsageMark)processingInfo;
    }

    private boolean referencesClass(ShortestUsageMark shortestUsageMark, Clazz clazz) {
        return this.referenceChecker.referencesClass(shortestUsageMark, clazz);
    }

    private boolean referencesClassMember(ShortestUsageMark shortestUsageMark, Clazz clazz) {
        return this.referenceChecker.referencesClassMember(shortestUsageMark, clazz);
    }

    private class MyReferenceChecker
    implements ClassVisitor,
    MemberVisitor {
        private Clazz checkClass;
        private boolean checkMember;
        private boolean isReferencing;

        private MyReferenceChecker() {
        }

        public boolean referencesClass(ShortestUsageMark shortestUsageMark, Clazz clazz) {
            this.checkClass = clazz;
            this.checkMember = false;
            this.isReferencing = false;
            this.checkReferenceFrom(shortestUsageMark);
            return this.isReferencing;
        }

        public boolean referencesClassMember(ShortestUsageMark shortestUsageMark, Clazz clazz) {
            this.checkClass = clazz;
            this.checkMember = true;
            this.isReferencing = false;
            this.checkReferenceFrom(shortestUsageMark);
            return this.isReferencing;
        }

        public void visitAnyClass(Clazz clazz) {
        }

        public void visitProgramClass(ProgramClass programClass) {
            this.checkReferenceFrom((Processable)programClass);
        }

        public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        }

        public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        }

        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            this.checkReferenceFrom((Processable)programField);
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            this.checkReferenceFrom((Processable)programMethod);
        }

        private void checkReferenceFrom(Processable processable) {
            if (!this.isReferencing) {
                this.checkReferenceFrom(ShortestUsageMarker.this.getShortestUsageMark(processable));
            }
        }

        private void checkReferenceFrom(ShortestUsageMark shortestUsageMark) {
            this.isReferencing = this.checkMember ? shortestUsageMark.isCausedByMember(this.checkClass) : shortestUsageMark.isCausedBy(this.checkClass);
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
        }
    }
}

