/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.LibraryClassEditor;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.visitor.MemberVisitor;

public class LibraryClassBuilder {
    private final LibraryClass libraryClass;
    private final LibraryClassEditor libraryClassEditor;

    public LibraryClassBuilder(int u2accessFlags, String className, String superclassName) {
        this(new LibraryClass(u2accessFlags, className, superclassName));
    }

    public LibraryClassBuilder(int u2accessFlags, String className, String superclassName, String[] interfaceNames, Clazz[] interfaceClasses, int subClassCount, Clazz[] subClasses, LibraryField[] fields, LibraryMethod[] methods, KotlinMetadata kotlinMetadata) {
        this(new LibraryClass(u2accessFlags, className, superclassName, interfaceNames, interfaceClasses, subClassCount, subClasses, fields, methods, kotlinMetadata));
    }

    public LibraryClassBuilder(LibraryClass libraryClass) {
        this.libraryClass = libraryClass;
        this.libraryClassEditor = new LibraryClassEditor(libraryClass);
    }

    public LibraryClass getLibraryClass() {
        return this.libraryClass;
    }

    public ConstantPoolEditor getConstantPoolEditor() {
        throw new UnsupportedOperationException("Library class [" + this.libraryClass.thisClassName + "] doesn't store constant pool");
    }

    public LibraryClassBuilder addInterface(Clazz interfaceClass) {
        return this.addInterface(interfaceClass.getName(), interfaceClass);
    }

    public LibraryClassBuilder addInterface(String interfaceName) {
        return this.addInterface(interfaceName, null);
    }

    public LibraryClassBuilder addInterface(String interfaceName, Clazz referencedInterface) {
        this.libraryClassEditor.addInterface(interfaceName, referencedInterface);
        return this;
    }

    public LibraryClassBuilder addField(int u2accessFlags, String fieldName, String fieldDescriptor) {
        return this.addField(u2accessFlags, fieldName, fieldDescriptor, null);
    }

    public LibraryClassBuilder addField(int u2accessFlags, String fieldName, String fieldDescriptor, MemberVisitor extraMemberVisitor) {
        LibraryField libraryField = this.addAndReturnField(u2accessFlags, fieldName, fieldDescriptor);
        if (extraMemberVisitor != null) {
            extraMemberVisitor.visitLibraryField(this.libraryClass, libraryField);
        }
        return this;
    }

    public LibraryField addAndReturnField(int u2accessFlags, String fieldName, String fieldDescriptor) {
        LibraryField libraryField = new LibraryField(u2accessFlags, fieldName, fieldDescriptor);
        this.libraryClassEditor.addField(libraryField);
        return libraryField;
    }

    public LibraryClassBuilder addMethod(int u2accessFlags, String methodName, String methodDescriptor) {
        return this.addMethod(u2accessFlags, methodName, methodDescriptor, null);
    }

    public LibraryClassBuilder addMethod(int u2accessFlags, String methodName, String methodDescriptor, MemberVisitor extraMemberVisitor) {
        LibraryMethod libraryMethod = this.addAndReturnMethod(u2accessFlags, methodName, methodDescriptor);
        if (extraMemberVisitor != null) {
            extraMemberVisitor.visitLibraryMethod(this.libraryClass, libraryMethod);
        }
        return this;
    }

    public LibraryMethod addAndReturnMethod(int u2accessFlags, String methodName, String methodDescriptor) {
        LibraryMethod libraryMethod = new LibraryMethod(u2accessFlags, methodName, methodDescriptor);
        this.libraryClassEditor.addMethod(libraryMethod);
        return libraryMethod;
    }
}

