/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;
import proguard.util.WildcardManager;

public class AnnotationTypeFilter
implements AnnotationVisitor {
    private final StringMatcher stringMatcher;
    private final AnnotationVisitor annotationVisitor;

    public AnnotationTypeFilter(String regularExpression, AnnotationVisitor annotationVisitor) {
        this(regularExpression, null, annotationVisitor);
    }

    public AnnotationTypeFilter(String regularExpression, WildcardManager wildcardManager, AnnotationVisitor annotationVisitor) {
        this(new ListParser(new ClassNameParser(wildcardManager)).parse(regularExpression), annotationVisitor);
    }

    public AnnotationTypeFilter(StringMatcher stringMatcher, AnnotationVisitor annotationVisitor) {
        this.stringMatcher = stringMatcher;
        this.annotationVisitor = annotationVisitor;
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Field field, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, field, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, int parameterIndex, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, parameterIndex, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, CodeAttribute codeAttribute, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, codeAttribute, annotation);
        }
    }

    private boolean accepted(String name) {
        return this.stringMatcher.matches(name);
    }
}

