/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.defaults.BamCpaRun;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.BamLocationDependentJvmMemoryLocation;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationBamCpaRun;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintBamCpaRun;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransformer;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.state.HashMapAbstractStateFactory;
import proguard.analysis.cpa.state.MapAbstractStateFactory;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;

public class JvmTaintMemoryLocationBamCpaRun
extends JvmMemoryLocationBamCpaRun<SimpleCpa, SetAbstractState<JvmTaintSource>> {
    private final Collection<? extends JvmTaintSink> taintSinks;
    private List<BamLocationDependentJvmMemoryLocation<?>> endPoints;
    private Map<BamLocationDependentJvmMemoryLocation<?>, List<JvmTaintSink>> endPointToSinks;

    protected JvmTaintMemoryLocationBamCpaRun(JvmTaintBamCpaRun jvmTaintCpaRun, SetAbstractState<JvmTaintSource> threshold, Collection<? extends JvmTaintSink> taintSinks, AbortOperator memoryLocationAbortOperator) {
        super(jvmTaintCpaRun, threshold, memoryLocationAbortOperator);
        this.taintSinks = taintSinks;
    }

    protected JvmTaintMemoryLocationBamCpaRun(JvmCfa cfa, Set<? extends JvmTaintSource> taintSources, MethodSignature mainSignature, int maxCallStackDepth, HeapModel heapModel, SetAbstractState<JvmTaintSource> threshold, Collection<? extends JvmTaintSink> taintSinks, AbortOperator abortOperator, AbortOperator memoryLocationAbortOperator, boolean reduceHeap, MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory, MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> principalHeapMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory, MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> followerHeapMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory, Map<MethodSignature, JvmTaintTransformer> taintTransformers) {
        this(new JvmTaintBamCpaRun(cfa, taintSources, mainSignature, maxCallStackDepth, heapModel, abortOperator, reduceHeap, staticFieldMapAbstractStateFactory, principalHeapMapAbstractStateFactory, principalHeapNodeMapAbstractStateFactory, followerHeapMapAbstractStateFactory, followerHeapNodeMapAbstractStateFactory, taintTransformers), threshold, taintSinks, memoryLocationAbortOperator);
    }

    public Collection<? extends JvmTaintSink> getTaintSinks() {
        return this.taintSinks;
    }

    public Map<BamLocationDependentJvmMemoryLocation<?>, List<JvmTaintSink>> getEndPointToSinks() {
        return this.endPointToSinks;
    }

    @Override
    public List<JvmMemoryLocationAbstractState<?>> getInitialStates() {
        return this.getEndPoints().stream().map(JvmMemoryLocationAbstractState::new).collect(Collectors.toList());
    }

    @Override
    public Collection<BamLocationDependentJvmMemoryLocation<?>> getEndPoints() {
        if (this.endPoints != null) {
            return this.endPoints;
        }
        if (this.inputReachedSet == null) {
            this.execute();
            return this.endPoints;
        }
        HashSet memoryLocations = new HashSet();
        HashMap endPointToSinks = new HashMap();
        Map<Signature, Map<JvmTaintSink, Set<JvmMemoryLocation>>> fqnToSinkLocations = JvmTaintSink.convertSinksToMemoryLocations(this.taintSinks);
        ((BamCpa)((BamCpaRun)this.inputCpaRun).getCpa()).getCache().values().stream().map(BlockAbstraction::getReachedSet).forEach(reachedSet -> reachedSet.asCollection().forEach(state -> ((JvmAbstractState)state.getStateByName("Jvm")).getProgramLocation().getLeavingEdges().forEach(edge -> this.createEndpointsForEdgeIfTainted((ReachedSet)reachedSet, (AbstractState)state, (JvmCfaEdge)edge, fqnToSinkLocations, memoryLocations, endPointToSinks))));
        this.endPointToSinks = endPointToSinks;
        this.endPoints = new ArrayList(memoryLocations);
        return this.endPoints;
    }

    private void createEndpointsForEdgeIfTainted(ReachedSet reachedSet, AbstractState state, JvmCfaEdge edge, Map<Signature, Map<JvmTaintSink, Set<JvmMemoryLocation>>> signatureToSinkLocations, Set<BamLocationDependentJvmMemoryLocation<?>> memoryLocations, Map<BamLocationDependentJvmMemoryLocation<?>, List<JvmTaintSink>> endPointToSinks) {
        signatureToSinkLocations.getOrDefault(edge.targetSignature(), Collections.emptyMap()).entrySet().stream().filter(e -> ((JvmTaintSink)e.getKey()).matchCfaEdge(edge)).forEach(e -> ((Set)e.getValue()).stream().filter(l -> this.isStateTaintedForMemoryLocation((JvmAbstractState)state.getStateByName("Jvm"), (JvmMemoryLocation)l, (JvmTaintSink)e.getKey())).forEach(l -> this.createAndAddEndpoint(reachedSet, state, (JvmMemoryLocation)l, (JvmTaintSink)e.getKey(), memoryLocations, endPointToSinks)));
    }

    private void createAndAddEndpoint(ReachedSet reachedSet, AbstractState state, JvmMemoryLocation taintLocation, JvmTaintSink sink, Set<BamLocationDependentJvmMemoryLocation<?>> memoryLocations, Map<BamLocationDependentJvmMemoryLocation<?>, List<JvmTaintSink>> endPointToSinks) {
        BamLocationDependentJvmMemoryLocation memoryLocation = new BamLocationDependentJvmMemoryLocation(taintLocation, (JvmCfaNode)((ProgramLocationDependent)((Object)state)).getProgramLocation(), (ProgramLocationDependentReachedSet)reachedSet);
        memoryLocations.add(memoryLocation);
        endPointToSinks.computeIfAbsent(memoryLocation, x -> new ArrayList()).add(sink);
    }

    private boolean isStateTaintedForMemoryLocation(JvmAbstractState<SetAbstractState<JvmTaintSource>> state, JvmMemoryLocation memoryLocation, JvmTaintSink sink) {
        SetAbstractState extractedState = memoryLocation.extractValueOrDefault(state, SetAbstractState.bottom);
        extractedState.addAll((Collection)state.getHeap().getFieldOrDefault(memoryLocation, "", SetAbstractState.bottom));
        return extractedState.stream().anyMatch(sink.isValidForSource);
    }

    public static class Builder {
        private JvmCfa cfa;
        private MethodSignature mainSignature;
        private Set<? extends JvmTaintSource> taintSources = Collections.emptySet();
        private int maxCallStackDepth = -1;
        private HeapModel heapModel = HeapModel.FORGETFUL;
        private SetAbstractState<JvmTaintSource> threshold = SetAbstractState.bottom;
        private Collection<? extends JvmTaintSink> taintSinks = Collections.emptySet();
        private AbortOperator abortOperator = NeverAbortOperator.INSTANCE;
        private AbortOperator memoryLocationAbortOperator = NeverAbortOperator.INSTANCE;
        private boolean reduceHeap = true;
        private MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        private MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> principalHeapMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        private MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        private MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> followerHeapMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        private MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        private Map<MethodSignature, JvmTaintTransformer> taintTransformers = Collections.emptyMap();

        public JvmTaintMemoryLocationBamCpaRun build() {
            if (this.cfa == null || this.mainSignature == null) {
                throw new IllegalStateException("CFA and the main signature must be set");
            }
            return new JvmTaintMemoryLocationBamCpaRun(this.cfa, this.taintSources, this.mainSignature, this.maxCallStackDepth, this.heapModel, this.threshold, this.taintSinks, this.abortOperator, this.memoryLocationAbortOperator, this.reduceHeap, this.staticFieldMapAbstractStateFactory, this.principalHeapMapAbstractStateFactory, this.principalHeapNodeMapAbstractStateFactory, this.followerHeapMapAbstractStateFactory, this.followerHeapNodeMapAbstractStateFactory, this.taintTransformers);
        }

        public Builder setCfa(JvmCfa cfa) {
            this.cfa = cfa;
            return this;
        }

        public Builder setTaintSources(Set<? extends JvmTaintSource> taintSources) {
            this.taintSources = taintSources;
            return this;
        }

        public Builder setMainSignature(MethodSignature mainSignature) {
            this.mainSignature = mainSignature;
            return this;
        }

        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            this.maxCallStackDepth = maxCallStackDepth;
            return this;
        }

        public Builder setHeapModel(HeapModel heapModel) {
            this.heapModel = heapModel;
            return this;
        }

        public Builder setThreshold(SetAbstractState<JvmTaintSource> threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder setTaintSinks(Collection<? extends JvmTaintSink> taintSinks) {
            this.taintSinks = taintSinks;
            return this;
        }

        public Builder setAbortOperator(AbortOperator abortOperator) {
            this.abortOperator = abortOperator;
            return this;
        }

        public Builder setMemoryLocationAbortOperator(AbortOperator memoryLocationAbortOperator) {
            this.memoryLocationAbortOperator = memoryLocationAbortOperator;
            return this;
        }

        public Builder setReduceHeap(boolean reduceHeap) {
            this.reduceHeap = reduceHeap;
            return this;
        }

        public Builder setStaticFieldMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory) {
            this.staticFieldMapAbstractStateFactory = staticFieldMapAbstractStateFactory;
            return this;
        }

        public Builder setPrincipalHeapMapAbstractStateFactory(MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> principalHeapMapAbstractStateFactory) {
            this.principalHeapMapAbstractStateFactory = principalHeapMapAbstractStateFactory;
            return this;
        }

        public Builder setPrincipalHeapNodeMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory) {
            this.principalHeapNodeMapAbstractStateFactory = principalHeapNodeMapAbstractStateFactory;
            return this;
        }

        public Builder setFollowerHeapMapAbstractStateFactory(MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> followerHeapMapAbstractStateFactory) {
            this.followerHeapMapAbstractStateFactory = followerHeapMapAbstractStateFactory;
            return this;
        }

        public Builder setFollowerHeapNodeMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory) {
            this.followerHeapNodeMapAbstractStateFactory = followerHeapNodeMapAbstractStateFactory;
            return this;
        }

        public Builder setTaintTransformers(Map<MethodSignature, JvmTaintTransformer> taintTransformers) {
            this.taintTransformers = taintTransformers;
            return this;
        }
    }
}

