/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.trial;

import com.google.caliper.bridge.TrialRequest;
import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.runner.experiment.Experiment;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.server.LocalPort;
import com.google.caliper.runner.worker.WorkerSpec;
import com.google.caliper.runner.worker.trial.TrialId;
import com.google.caliper.runner.worker.trial.TrialNumber;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.UUID;
import javax.inject.Inject;

public final class TrialSpec
extends WorkerSpec {
    private final Experiment experiment;
    private final BenchmarkClassModel benchmarkClass;
    private final int trialNumber;

    @Inject
    @VisibleForTesting
    public TrialSpec(@TrialId UUID id, @LocalPort int port, Experiment experiment, BenchmarkClassModel benchmarkClass, @TrialNumber int trialNumber) {
        super(experiment.target(), id, id, port, experiment.benchmarkSpec().className());
        this.experiment = experiment;
        this.benchmarkClass = benchmarkClass;
        this.trialNumber = trialNumber;
    }

    @Override
    public String name() {
        int n = this.trialNumber;
        return new StringBuilder(17).append("trial-").append(n).toString();
    }

    @Override
    public WorkerRequest request() {
        return new TrialRequest(this.experiment.toExperimentSpec());
    }

    @Override
    public ImmutableList<String> additionalVmOptions() {
        Instrument instrument = this.experiment.instrumentedMethod().instrument();
        return new ImmutableList.Builder().addAll((Iterable)this.benchmarkClass.vmOptions()).addAll(this.target().vm().trialArgs()).addAll(instrument.getExtraCommandLineArgs(this.target().vm().config())).build();
    }

    @Override
    public void printInfoHeader(PrintWriter writer) {
        int n = this.trialNumber;
        writer.println(new StringBuilder(25).append("Trial Number: ").append(n).toString());
        String string = String.valueOf(this.id());
        writer.println(new StringBuilder(10 + String.valueOf(string).length()).append("Trial Id: ").append(string).toString());
        string = String.valueOf(this.experiment);
        writer.println(new StringBuilder(12 + String.valueOf(string).length()).append("Experiment: ").append(string).toString());
    }
}

