/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.dryrun;

import com.google.caliper.bridge.DryRunRequest;
import com.google.caliper.bridge.ExperimentSpec;
import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.runner.experiment.Experiment;
import com.google.caliper.runner.server.LocalPort;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.worker.WorkerScoped;
import com.google.caliper.runner.worker.WorkerSpec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;

@WorkerScoped
final class DryRunSpec
extends WorkerSpec {
    private final BenchmarkClassModel benchmarkClass;
    private final ImmutableSet<Experiment> experiments;
    private final Target target;

    @Inject
    DryRunSpec(UUID id, @LocalPort int port, BenchmarkClassModel benchmarkClass, Set<Experiment> experiments, Target target) {
        super(target, id, id, port, benchmarkClass.name());
        this.benchmarkClass = benchmarkClass;
        this.experiments = ImmutableSet.copyOf(experiments);
        this.target = target;
    }

    @Override
    public String name() {
        String string = String.valueOf(this.target.name());
        return string.length() != 0 ? "dry-run-".concat(string) : new String("dry-run-");
    }

    @Override
    public WorkerRequest request() {
        HashSet<ExperimentSpec> experimentSpecs = new HashSet<ExperimentSpec>();
        for (Experiment experiment : this.experiments) {
            experimentSpecs.add(experiment.toExperimentSpec());
        }
        return new DryRunRequest(experimentSpecs);
    }

    @Override
    public ImmutableList<String> additionalVmOptions() {
        return this.benchmarkClass.vmOptions().asList();
    }

    @Override
    public void printInfoHeader(PrintWriter writer) {
        String string = String.valueOf(this.id());
        writer.println(new StringBuilder(11 + String.valueOf(string).length()).append("Worker Id: ").append(string).toString());
        writer.println("Experiments:");
        for (Experiment experiment : this.experiments) {
            String string2 = String.valueOf(experiment);
            writer.println(new StringBuilder(2 + String.valueOf(string2).length()).append("  ").append(string2).toString());
        }
    }
}

