/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.dryrun;

import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.DryRunSuccessLogMessage;
import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.LogMessageVisitor;
import com.google.caliper.runner.experiment.Experiment;
import com.google.caliper.runner.worker.FailureLogMessageVisitor;
import com.google.caliper.runner.worker.Worker;
import com.google.caliper.runner.worker.WorkerProcessor;
import com.google.caliper.util.ShortDuration;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;

final class DryRunProcessor
extends WorkerProcessor<ImmutableSet<Experiment>> {
    private final SuccessVisitor successVisitor;

    @Inject
    DryRunProcessor(Set<Experiment> experiments) {
        this.successVisitor = new SuccessVisitor(experiments);
    }

    @Override
    public ShortDuration timeLimit() {
        return ShortDuration.of((long)10L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Override
    public boolean handleMessage(LogMessage message, Worker worker) {
        message.accept((LogMessageVisitor)FailureLogMessageVisitor.INSTANCE);
        message.accept((LogMessageVisitor)this.successVisitor);
        return this.successVisitor.result != null;
    }

    @Override
    public ImmutableSet<Experiment> getResult() {
        return this.successVisitor.result;
    }

    private static final class SuccessVisitor
    extends AbstractLogMessageVisitor {
        private final ImmutableMap<Integer, Experiment> experiments;
        @Nullable
        private volatile ImmutableSet<Experiment> result = null;

        private SuccessVisitor(Iterable<Experiment> experiments) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Experiment experiment : experiments) {
                builder.put((Object)experiment.id(), (Object)experiment);
            }
            this.experiments = builder.build();
        }

        public void visit(DryRunSuccessLogMessage logMessage) {
            this.result = ImmutableSet.copyOf(Maps.filterKeys(this.experiments, (Predicate)Predicates.in((Collection)logMessage.ids())).values());
        }
    }
}

