/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.dryrun;

import com.google.caliper.runner.experiment.Experiment;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.worker.WorkerModule;
import com.google.caliper.runner.worker.WorkerProcessor;
import com.google.caliper.runner.worker.WorkerSpec;
import com.google.caliper.runner.worker.dryrun.DryRunProcessor;
import com.google.caliper.runner.worker.dryrun.DryRunSpec;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import java.util.HashSet;
import java.util.Set;

@Module(includes={WorkerModule.class})
abstract class DryRunModule {
    private DryRunModule() {
    }

    @Provides
    @Reusable
    static Target provideTarget(Set<Experiment> experiments) {
        Preconditions.checkArgument((!experiments.isEmpty() ? 1 : 0) != 0, (Object)"Dry-run component bound no experiments.");
        HashSet<Target> targets = new HashSet<Target>();
        for (Experiment experiment : experiments) {
            targets.add(experiment.target());
        }
        Preconditions.checkArgument((targets.size() == 1 ? 1 : 0) != 0, (String)"All dry-run component experiments should have the same target. Experiments for %s different targets were found.", (int)targets.size());
        return (Target)Iterables.getOnlyElement(targets);
    }

    @Binds
    abstract WorkerProcessor<ImmutableSet<Experiment>> bindWorkerProcessor(DryRunProcessor var1);

    @Binds
    abstract WorkerSpec bindWorkerSpec(DryRunSpec var1);
}

