/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.target.Target;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public abstract class VmProcess {
    private final Set<StopListener> listeners = new HashSet<StopListener>();
    private boolean running = true;

    public final synchronized void addStopListener(StopListener listener) {
        this.listeners.add(listener);
    }

    public abstract InputStream stdout();

    public abstract InputStream stderr();

    public final int awaitExit() throws InterruptedException {
        int result = this.doAwaitExit();
        this.stopped();
        return result;
    }

    protected abstract int doAwaitExit() throws InterruptedException;

    public final void kill() {
        this.doKill();
    }

    protected abstract void doKill();

    private synchronized void stopped() {
        if (this.running) {
            this.running = false;
            for (StopListener listener : this.listeners) {
                listener.stopped(this);
            }
        }
    }

    public static interface Logger {
        public void log(String var1);

        public void log(String var1, String var2);
    }

    public static interface Spec {
        public UUID id();

        public Target target();

        public ImmutableList<String> vmOptions();

        public String mainClass();

        public ImmutableList<String> mainArgs();
    }

    public static interface StopListener {
        public void stopped(VmProcess var1);
    }
}

