/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.target.ShellException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;

final class Shell {
    private static final Joiner COMMAND_JOINER = Joiner.on((char)' ');
    private static final Splitter COMMAND_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();
    private final ExecutorService executor;
    private final ImmutableMap<String, String> env;

    @Inject
    Shell(ExecutorService executor) {
        this(executor, (Map<String, String>)ImmutableMap.of());
    }

    Shell(ExecutorService executor, Map<String, String> env) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.env = ImmutableMap.copyOf(env);
    }

    public Shell withEnv(Map<String, String> env) {
        return new Shell(this.executor, env);
    }

    public Result execute(String command) {
        return this.execute(COMMAND_SPLITTER.splitToList((CharSequence)command));
    }

    public Result execute(String first, String second, String ... rest) {
        return this.execute(Lists.asList((Object)first, (Object)second, (Object[])rest));
    }

    public Result execute(List<String> command) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.environment().putAll((Map<String, String>)this.env);
        builder.command(command);
        try {
            Process process = builder.start();
            Future<String> stdoutFuture = this.inputStreamToString(process.getInputStream());
            Future<String> stderrFuture = this.inputStreamToString(process.getErrorStream());
            int exitCode = process.waitFor();
            return new Result(command, exitCode, stdoutFuture.get(), stderrFuture.get());
        }
        catch (Exception e) {
            throw new ShellException(e);
        }
    }

    private Future<String> inputStreamToString(final InputStream in) {
        return this.executor.submit(new Callable<String>(this){

            @Override
            public String call() throws IOException {
                return CharStreams.toString((Readable)new InputStreamReader(in, Charset.defaultCharset()));
            }
        });
    }

    public static final class Result {
        private final ImmutableList<String> command;
        private final int exitCode;
        private final String stdout;
        private final String stderr;

        Result(List<String> command, int exitCode, String stdout, String stderr) {
            this.command = ImmutableList.copyOf(command);
            this.exitCode = exitCode;
            this.stdout = stdout.trim();
            this.stderr = stderr.trim();
        }

        public ImmutableList<String> command() {
            return this.command;
        }

        public boolean isSuccessful() {
            return this.exitCode == 0;
        }

        public int exitCode() {
            return this.exitCode;
        }

        public String stdout() {
            return this.stdout;
        }

        public String stderr() {
            return this.stderr;
        }

        public Result orThrow() {
            String string = String.valueOf(COMMAND_JOINER.join(this.command));
            return this.orThrow(string.length() != 0 ? "command failed: ".concat(string) : new String("command failed: "));
        }

        public Result orThrow(String message) {
            if (!this.isSuccessful()) {
                throw new ShellException(message, this);
            }
            return this;
        }
    }
}

