/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.bridge.KillVmRequest;
import com.google.caliper.bridge.OpenedSocket;
import com.google.caliper.bridge.RemoteClasspathMessage;
import com.google.caliper.bridge.StartVmRequest;
import com.google.caliper.bridge.StopProxyRequest;
import com.google.caliper.bridge.VmStoppedMessage;
import com.google.caliper.runner.server.ServerSocketService;
import com.google.caliper.runner.target.VmProcess;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

final class ProxyConnectionService
extends AbstractExecutionThreadService {
    private final UUID proxyId = UUID.randomUUID();
    private final ServerSocketService server;
    private final Closer closer = Closer.create();
    private OpenedSocket.Reader reader;
    private OpenedSocket.Writer writer;
    private final SettableFuture<String> classpathFuture = SettableFuture.create();
    private final SettableFuture<String> nativeLibraryDirFuture = SettableFuture.create();
    private final ConcurrentMap<UUID, VmProxy> vms = new ConcurrentHashMap<UUID, VmProxy>();

    @Inject
    ProxyConnectionService(ServerSocketService server) {
        this.server = server;
    }

    public UUID proxyId() {
        return this.proxyId;
    }

    public void startUp() throws IOException, ExecutionException, InterruptedException {
        OpenedSocket socket = (OpenedSocket)this.server.getConnection(this.proxyId).get();
        this.reader = (OpenedSocket.Reader)this.closer.register((Closeable)socket.reader());
        this.writer = (OpenedSocket.Writer)this.closer.register((Closeable)socket.writer());
    }

    public void run() throws IOException {
        while (this.isRunning()) {
            Serializable message = this.reader.read();
            if (message == null) {
                return;
            }
            if (message instanceof VmStoppedMessage) {
                VmStoppedMessage stoppedMessage = (VmStoppedMessage)message;
                UUID vmId = stoppedMessage.vmId();
                VmProxy vm = (VmProxy)this.vms.remove(vmId);
                if (vm == null) continue;
                vm.stopped(stoppedMessage.exitCode());
                continue;
            }
            if (!(message instanceof RemoteClasspathMessage)) continue;
            this.classpathFuture.set((Object)((RemoteClasspathMessage)message).classpath());
            this.nativeLibraryDirFuture.set((Object)((RemoteClasspathMessage)message).nativeLibraryDir());
        }
    }

    public String getRemoteClasspath() throws ExecutionException {
        return (String)Uninterruptibles.getUninterruptibly(this.classpathFuture);
    }

    public String getRemoteNativeLibraryDir() throws ExecutionException {
        return (String)Uninterruptibles.getUninterruptibly(this.nativeLibraryDirFuture);
    }

    public VmProcess startVm(StartVmRequest request) throws ExecutionException, IOException {
        VmProxy vm = new VmProxy(request.vmId(), request.stdoutId(), request.stderrId());
        this.vms.put(request.vmId(), vm);
        this.writer.write(new Serializable[]{request});
        vm.awaitStarted();
        return vm;
    }

    private void waitForAllVmsToExit(long timeout, TimeUnit unit) {
        if (this.vms.isEmpty()) {
            return;
        }
        ArrayList<SettableFuture> exitFutures = new ArrayList<SettableFuture>();
        for (VmProxy vm : this.vms.values()) {
            exitFutures.add(vm.exitCode);
        }
        ListenableFuture allExited = Futures.allAsList(exitFutures);
        try {
            allExited.get(timeout, unit);
        }
        catch (Exception ignore) {
            return;
        }
        for (VmProxy vm : this.vms.values()) {
            try {
                vm.awaitExit();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    protected void triggerShutdown() {
        try {
            this.writer.write(new Serializable[]{new StopProxyRequest()});
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutDown() throws IOException {
        this.waitForAllVmsToExit(5L, TimeUnit.SECONDS);
        this.closer.close();
    }

    private final class VmProxy
    extends VmProcess {
        private final UUID vmId;
        private final UUID stdoutId;
        private final UUID stderrId;
        private volatile InputStream stdout;
        private volatile InputStream stderr;
        private final SettableFuture<Integer> exitCode = SettableFuture.create();

        VmProxy(UUID vmId, UUID stdoutId, UUID stderrId) {
            this.vmId = (UUID)Preconditions.checkNotNull((Object)vmId);
            this.stdoutId = (UUID)Preconditions.checkNotNull((Object)stdoutId);
            this.stderrId = (UUID)Preconditions.checkNotNull((Object)stderrId);
        }

        void awaitStarted() throws ExecutionException {
            this.stdout = (InputStream)Uninterruptibles.getUninterruptibly(ProxyConnectionService.this.server.getInputStream(this.stdoutId));
            this.stderr = (InputStream)Uninterruptibles.getUninterruptibly(ProxyConnectionService.this.server.getInputStream(this.stderrId));
        }

        void stopped(int exitCode) {
            this.exitCode.set((Object)exitCode);
        }

        @Override
        public InputStream stdout() {
            return this.stdout;
        }

        @Override
        public InputStream stderr() {
            return this.stderr;
        }

        @Override
        protected int doAwaitExit() throws InterruptedException {
            try {
                return (Integer)this.exitCode.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void doKill() {
            try {
                ProxyConnectionService.this.writer.write(new Serializable[]{KillVmRequest.create((UUID)this.vmId)});
            }
            catch (IOException e) {
                if (e.getMessage().equals("Socket closed")) {
                    return;
                }
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            String string = String.valueOf(this.vmId);
            return new StringBuilder(14 + String.valueOf(string).length()).append("VmProxy{vmId=").append(string).append("}").toString();
        }
    }
}

