/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.resultprocessor;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.resultprocessor.HttpUploader;
import com.google.caliper.runner.resultprocessor.OutputFileDumper;
import com.google.caliper.runner.resultprocessor.ResultProcessorCreator;
import com.google.common.collect.ImmutableSet;
import dagger.Binds;
import dagger.MapKey;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import javax.inject.Provider;

@Module
public abstract class ResultProcessorModule {
    private ResultProcessorModule() {
    }

    @Binds
    @IntoMap
    @ResultProcessorClassKey(value=OutputFileDumper.class)
    abstract ResultProcessor bindOutputFileDumper(OutputFileDumper var1);

    @Binds
    @IntoMap
    @ResultProcessorClassKey(value=HttpUploader.class)
    abstract ResultProcessor bindHttpUploader(HttpUploader var1);

    @Provides
    static ImmutableSet<ResultProcessor> provideResultProcessors(CaliperConfig config, Map<Class<? extends ResultProcessor>, Provider<ResultProcessor>> availableProcessors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class processorClass : config.getConfiguredResultProcessors()) {
            Provider<ResultProcessor> resultProcessorProvider = availableProcessors.get(processorClass);
            ResultProcessor resultProcessor = resultProcessorProvider == null ? ResultProcessorCreator.createResultProcessor(processorClass, config.getResultProcessorConfig(processorClass)) : (ResultProcessor)resultProcessorProvider.get();
            builder.add((Object)resultProcessor);
        }
        return builder.build();
    }

    @MapKey
    public static @interface ResultProcessorClassKey {
        public Class<? extends ResultProcessor> value();
    }
}

