/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.config;

import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.config.SupportsVmType;
import java.util.Arrays;

public enum VmType {
    JVM,
    ANDROID;

    final String name = this.name().toLowerCase();

    public static VmType of(String type) {
        switch (type) {
            case "jvm": {
                return JVM;
            }
            case "android": {
                return ANDROID;
            }
        }
        String string = String.valueOf(type);
        throw new InvalidConfigurationException(string.length() != 0 ? "Invalid VM type: ".concat(string) : new String("Invalid VM type: "));
    }

    public final boolean supports(Class<?> clazz) {
        SupportsVmType annotation = clazz.getAnnotation(SupportsVmType.class);
        return annotation != null && Arrays.asList(annotation.value()).contains((Object)this);
    }

    public String toString() {
        return this.name;
    }
}

