/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.core.UserCodeException;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.ConsoleOutput;
import com.google.caliper.runner.experiment.Experiment;
import com.google.caliper.runner.experiment.ExperimentSelector;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.worker.ProxyWorkerException;
import com.google.caliper.runner.worker.WorkerRunner;
import com.google.caliper.runner.worker.dryrun.DryRunComponent;
import com.google.caliper.runner.worker.trial.TrialComponent;
import com.google.caliper.runner.worker.trial.TrialExecutor;
import com.google.caliper.runner.worker.trial.TrialFailureException;
import com.google.caliper.runner.worker.trial.TrialResult;
import com.google.caliper.util.Stdout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import dagger.producers.Producer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;

@VisibleForTesting
public final class ExperimentingCaliperRun
implements CaliperRun {
    private static final Logger logger = Logger.getLogger(ExperimentingCaliperRun.class.getName());
    private static final AsyncFunction<Throwable, Object> FALLBACK_TO_NULL = new AsyncFunction<Throwable, Object>(){
        final ListenableFuture<Object> nullFuture = Futures.immediateFuture(null);

        public ListenableFuture<Object> apply(Throwable t) throws Exception {
            return this.nullFuture;
        }
    };
    private final CaliperOptions options;
    private final PrintWriter stdout;
    private final BenchmarkClassModel benchmarkClass;
    private final ImmutableSet<Instrument> instruments;
    private final ImmutableSet<ResultProcessor> resultProcessors;
    private final ExperimentSelector selector;
    private final ListeningExecutorService trialExecutor;
    private final Provider<DryRunComponent.Builder> dryRunComponentBuilder;
    private final TrialComponent.TrialRunner trialRunner;

    @Inject
    @VisibleForTesting
    public ExperimentingCaliperRun(CaliperOptions options, @Stdout PrintWriter stdout, BenchmarkClassModel benchmarkClass, ImmutableSet<Instrument> instruments, ImmutableSet<ResultProcessor> resultProcessors, ExperimentSelector selector, @TrialExecutor ListeningExecutorService trialExecutor, Provider<DryRunComponent.Builder> dryRunComponentBuilder, TrialComponent.Builder trialComponentBuilder) {
        this.options = options;
        this.stdout = stdout;
        this.benchmarkClass = benchmarkClass;
        this.instruments = instruments;
        this.resultProcessors = resultProcessors;
        this.selector = selector;
        this.trialExecutor = trialExecutor;
        this.dryRunComponentBuilder = dryRunComponentBuilder;
        this.trialRunner = trialComponentBuilder.trialRunner((Executor)trialExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws InvalidBenchmarkException {
        ImmutableSet<Experiment> allExperiments = this.selector.selectExperiments();
        this.printRunInfo(allExperiments);
        if (allExperiments.isEmpty()) {
            throw new InvalidBenchmarkException("There were no experiments to be performed for the class '%s' using the instruments %s", new Object[]{this.benchmarkClass.name(), this.instruments});
        }
        this.stdout.format("This selection yields %s experiments.%n", allExperiments.size());
        this.stdout.flush();
        ImmutableSet<Experiment> experimentsToRun = this.dryRun((Iterable<Experiment>)allExperiments);
        if (experimentsToRun.size() != allExperiments.size()) {
            int numSkipped = allExperiments.size() - experimentsToRun.size();
            this.stdout.println(numSkipped == 1 ? "1 experiment was skipped." : String.format("%d experiments were skipped.", numSkipped));
        }
        if (experimentsToRun.isEmpty()) {
            throw new InvalidBenchmarkException("All experiments were skipped.", new Object[0]);
        }
        if (this.options.dryRun()) {
            this.stdout.println("Dry-run completed successfully.");
            return;
        }
        this.stdout.flush();
        int totalTrials = experimentsToRun.size() * this.options.trialsPerScenario();
        Stopwatch stopwatch = Stopwatch.createStarted();
        HashMultimap resultsByInstrumentedMethod = HashMultimap.create();
        List<ListenableFuture<TrialResult>> pendingTrials = this.scheduleTrials(experimentsToRun, totalTrials);
        ConsoleOutput output = new ConsoleOutput(this.stdout, totalTrials, stopwatch);
        try {
            for (ListenableFuture trialFuture : ExperimentingCaliperRun.inCompletionOrder(pendingTrials)) {
                try {
                    TrialResult result = (TrialResult)trialFuture.get();
                    output.processTrial(result);
                    for (ResultProcessor resultProcessor : this.resultProcessors) {
                        resultProcessor.processTrial(result.getTrial());
                    }
                    resultsByInstrumentedMethod.put((Object)result.getExperiment().instrumentedMethod(), (Object)result);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof TrialFailureException) {
                        output.processFailedTrial((TrialFailureException)e.getCause());
                        continue;
                    }
                    ExperimentingCaliperRun.cancelAll(pendingTrials);
                    throw Throwables.propagate((Throwable)e.getCause());
                }
                catch (InterruptedException e) {
                    ExperimentingCaliperRun.cancelAll(pendingTrials);
                    throw new RuntimeException(e);
                }
            }
            for (Map.Entry entry : resultsByInstrumentedMethod.asMap().entrySet()) {
                Instrument.InstrumentedMethod instrumentedMethod = (Instrument.InstrumentedMethod)entry.getKey();
                Optional<String> message = instrumentedMethod.validateMeasurements(ExperimentingCaliperRun.measurements((Iterable)entry.getValue()));
                if (!message.isPresent()) continue;
                this.stdout.printf("For %s (%s)%n  %s%n", instrumentedMethod.benchmarkMethod().name(), instrumentedMethod.instrument().name(), message.get());
            }
        }
        finally {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.trialExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            output.close();
        }
        for (ResultProcessor resultProcessor : this.resultProcessors) {
            try {
                resultProcessor.close();
            }
            catch (IOException e) {
                Object object = String.valueOf(resultProcessor);
                logger.log(Level.WARNING, new StringBuilder(36 + String.valueOf(object).length()).append("Could not close a result processor: ").append((String)object).toString(), e);
            }
        }
    }

    private static Iterable<ImmutableList<Measurement>> measurements(Iterable<TrialResult> results) {
        return Iterables.transform(results, (Function)new Function<TrialResult, ImmutableList<Measurement>>(){

            public ImmutableList<Measurement> apply(TrialResult result) {
                return result.getTrial().measurements();
            }
        });
    }

    private void printRunInfo(ImmutableSet<Experiment> allExperiments) {
        if (!this.options.runName().isEmpty()) {
            String string = String.valueOf(this.options.runName());
            this.stdout.println(string.length() != 0 ? "Run: ".concat(string) : new String("Run: "));
        }
        this.stdout.println("Experiment selection: ");
        String string = String.valueOf(FluentIterable.from(allExperiments).transform((Function)new Function<Experiment, String>(this){

            public String apply(Experiment experiment) {
                return experiment.instrumentedMethod().benchmarkMethod().name();
            }
        }).toSet());
        this.stdout.println(new StringBuilder(23 + String.valueOf(string).length()).append("  Benchmark Methods:   ").append(string).toString());
        string = String.valueOf(FluentIterable.from(this.selector.instruments()).transform((Function)new Function<Instrument, String>(this){

            public String apply(Instrument instrument) {
                return instrument.name();
            }
        }));
        this.stdout.println(new StringBuilder(17 + String.valueOf(string).length()).append("  Instruments:   ").append(string).toString());
        string = String.valueOf(this.selector.userParameters());
        this.stdout.println(new StringBuilder(21 + String.valueOf(string).length()).append("  User parameters:   ").append(string).toString());
        string = String.valueOf(FluentIterable.from(this.selector.targets()).transform((Function)new Function<Target, String>(this){

            public String apply(Target target) {
                return target.name();
            }
        }));
        this.stdout.println(new StringBuilder(15 + String.valueOf(string).length()).append("  Target VMs:  ").append(string).toString());
        this.stdout.println();
    }

    private List<ListenableFuture<TrialResult>> scheduleTrials(ImmutableSet<Experiment> experimentsToRun, int totalTrials) {
        ArrayList pendingTrials = Lists.newArrayListWithCapacity((int)totalTrials);
        ArrayList serialTrials = Lists.newArrayList();
        int trialNumber = 1;
        for (int i = 0; i < this.options.trialsPerScenario(); ++i) {
            for (Experiment experiment : experimentsToRun) {
                Producer<TrialResult> trialResultProducer = this.trialRunner.trialResultProducer(experiment, trialNumber++);
                switch (experiment.getTrialSchedulingPolicy()) {
                    case PARALLEL: {
                        pendingTrials.add(trialResultProducer.get());
                        break;
                    }
                    case SERIAL: {
                        serialTrials.add(trialResultProducer);
                    }
                }
            }
        }
        ListenableFuture previous = Futures.successfulAsList((Iterable)pendingTrials);
        for (final Producer trialResultProducer : serialTrials) {
            ListenableFuture current = Futures.transformAsync((ListenableFuture)previous, (AsyncFunction)new AsyncFunction<Object, TrialResult>(this){

                public ListenableFuture<TrialResult> apply(Object ignored) {
                    return trialResultProducer.get();
                }
            }, (Executor)MoreExecutors.directExecutor());
            pendingTrials.add(current);
            previous = Futures.catchingAsync((ListenableFuture)current, Throwable.class, FALLBACK_TO_NULL, (Executor)MoreExecutors.directExecutor());
        }
        return pendingTrials;
    }

    ImmutableSet<Experiment> dryRun(Iterable<Experiment> experiments) throws InvalidBenchmarkException {
        ImmutableSetMultimap<Target, Experiment> experimentsByTarget = this.indexByTarget(experiments);
        ImmutableSet.Builder results = ImmutableSet.builder();
        for (Target target : experimentsByTarget.keySet()) {
            WorkerRunner<ImmutableSet<Experiment>> runner = ((DryRunComponent.Builder)this.dryRunComponentBuilder.get()).experiments((Set<Experiment>)experimentsByTarget.get((Object)target)).build().workerRunner();
            try {
                results.addAll((Iterable)runner.runWorker());
            }
            catch (ProxyWorkerException e) {
                if (e.exceptionType().equals(UserCodeException.class.getName())) {
                    throw new UserCodeException(e.message(), (Throwable)e);
                }
                if (e.exceptionType().equals(InvalidBenchmarkException.class.getName())) {
                    throw new InvalidBenchmarkException(e.message(), (Throwable)e);
                }
                throw e;
            }
        }
        return results.build();
    }

    private ImmutableSetMultimap<Target, Experiment> indexByTarget(Iterable<Experiment> experiments) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (Experiment experiment : experiments) {
            result.put((Object)experiment.target(), (Object)experiment);
        }
        return result.build();
    }

    private static void cancelAll(Iterable<? extends ListenableFuture<?>> futures) {
        for (ListenableFuture<?> toCancel : futures) {
            toCancel.cancel(true);
        }
    }

    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> futures) {
        final ConcurrentLinkedQueue delegates = Queues.newConcurrentLinkedQueue();
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (final ListenableFuture<T> listenableFuture : futures) {
            SettableFuture delegate = SettableFuture.create();
            delegates.add(delegate);
            listenableFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    SettableFuture delegate = (SettableFuture)delegates.remove();
                    try {
                        delegate.set(Uninterruptibles.getUninterruptibly((Future)listenableFuture));
                    }
                    catch (ExecutionException e) {
                        delegate.setException(e.getCause());
                    }
                    catch (CancellationException e) {
                        delegate.cancel(true);
                    }
                }
            }, MoreExecutors.directExecutor());
            listBuilder.add((Object)delegate);
        }
        return listBuilder.build();
    }
}

