/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Logger level check is already implied in the log() call. An explicit atLEVEL().isEnabled() check is redundant.", severity=BugPattern.SeverityLevel.WARNING)
public class FloggerRedundantIsEnabled
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final String FLOGGER = "com.google.common.flogger.FluentLogger";
    private static final String FLOGGER_API = "com.google.common.flogger.FluentLogger.Api";
    private static final Matcher<ExpressionTree> AT_LEVEL = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.FluentLogger").namedAnyOf(new String[]{"atInfo", "atConfig", "atFine", "atFiner", "atFinest", "atWarning", "atSevere"}).withNoParameters();
    private static final Matcher<ExpressionTree> IS_ENABLED = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.FluentLogger.Api").named("isEnabled").withNoParameters();
    private static final Matcher<ExpressionTree> LOG = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.FluentLogger.Api").named("log");

    public Description matchIf(IfTree ifTree, VisitorState state) {
        if (ifTree.getElseStatement() != null) {
            return Description.NO_MATCH;
        }
        Optional<MethodInvocationTree> methodCall = FloggerRedundantIsEnabled.extractLoneLogInvocation(ifTree, state);
        if (!methodCall.isPresent()) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree logInvocation = methodCall.get();
        ExpressionTree ifCondition = ifTree.getCondition();
        ExpressionTree unwrappedIfCondition = FloggerRedundantIsEnabled.unwrap(ifCondition);
        if (IS_ENABLED.matches((Tree)unwrappedIfCondition, state) && FloggerRedundantIsEnabled.sameLoggerAtSameLevel(unwrappedIfCondition, logInvocation, state)) {
            return this.describeMatch(ifTree, (Fix)SuggestedFix.replace((Tree)ifTree, (String)(state.getSourceForNode((Tree)logInvocation) + ";")));
        }
        return FloggerRedundantIsEnabled.fixBinaryIfCondition(ifCondition, logInvocation, state).map(fix -> this.describeMatch(ifTree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static Optional<MethodInvocationTree> extractLoneLogInvocation(IfTree ifTree, VisitorState state) {
        ExpressionTree thenExpression;
        StatementTree thenStatement = ifTree.getThenStatement();
        while (thenStatement.getKind() == Tree.Kind.BLOCK) {
            List<? extends StatementTree> statements = ((BlockTree)thenStatement).getStatements();
            if (statements.size() != 1) {
                return Optional.empty();
            }
            thenStatement = (StatementTree)Iterables.getOnlyElement(statements);
        }
        if (thenStatement.getKind() == Tree.Kind.EXPRESSION_STATEMENT && LOG.matches((Tree)(thenExpression = ((ExpressionStatementTree)thenStatement).getExpression()), state)) {
            return Optional.of((MethodInvocationTree)thenExpression);
        }
        return Optional.empty();
    }

    private static ExpressionTree unwrap(ExpressionTree expr) {
        return expr.accept(new SimpleTreeVisitor<ExpressionTree, Void>(){

            @Override
            protected @Nullable ExpressionTree defaultAction(Tree tree, Void unused) {
                return tree instanceof ExpressionTree ? (ExpressionTree)tree : null;
            }

            @Override
            public ExpressionTree visitParenthesized(ParenthesizedTree parenthesizedTree, Void unused) {
                return parenthesizedTree.getExpression().accept(this, null);
            }

            @Override
            public ExpressionTree visitUnary(UnaryTree unaryTree, Void unused) {
                return unaryTree.getExpression().accept(this, null);
            }
        }, null);
    }

    private static boolean sameLoggerAtSameLevel(ExpressionTree expr1, ExpressionTree expr2, VisitorState state) {
        ExpressionTree atLevel1 = ASTHelpers.getReceiver((ExpressionTree)expr1);
        ExpressionTree atLevel2 = ASTHelpers.getReceiver((ExpressionTree)expr2);
        if (!AT_LEVEL.matches((Tree)atLevel1, state) || !AT_LEVEL.matches((Tree)atLevel2, state)) {
            return false;
        }
        Symbol atLevelSym1 = ASTHelpers.getSymbol((Tree)atLevel1);
        Symbol atLevelSym2 = ASTHelpers.getSymbol((Tree)atLevel2);
        if (atLevelSym1 == null || !atLevelSym1.equals(atLevelSym2)) {
            return false;
        }
        Symbol logger1 = ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)atLevel1));
        Symbol logger2 = ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)atLevel2));
        return logger1 != null && logger1.equals(logger2);
    }

    private static Optional<SuggestedFix> fixBinaryIfCondition(ExpressionTree ifCondition, MethodInvocationTree logInvocation, VisitorState state) {
        LoggerIsEnabledBinaryIfConditionScanner scanner = new LoggerIsEnabledBinaryIfConditionScanner(logInvocation, state);
        scanner.scan(ifCondition, null);
        return scanner.fix;
    }

    private static class LoggerIsEnabledBinaryIfConditionScanner
    extends TreeScanner<Void, Void> {
        private final ExpressionTree logInvocation;
        private final VisitorState state;
        public Optional<SuggestedFix> fix;

        public LoggerIsEnabledBinaryIfConditionScanner(ExpressionTree logInvocation, VisitorState state) {
            this.logInvocation = logInvocation;
            this.state = state;
            this.fix = Optional.empty();
        }

        @Override
        public Void visitBinary(BinaryTree binaryTree, Void unused) {
            ExpressionTree left = FloggerRedundantIsEnabled.unwrap(binaryTree.getLeftOperand());
            ExpressionTree right = FloggerRedundantIsEnabled.unwrap(binaryTree.getRightOperand());
            if (IS_ENABLED.matches((Tree)left, this.state) && FloggerRedundantIsEnabled.sameLoggerAtSameLevel(this.logInvocation, left, this.state)) {
                this.fix = Optional.of(SuggestedFix.replace((Tree)binaryTree, (String)this.state.getSourceForNode((Tree)binaryTree.getRightOperand())));
                return null;
            }
            if (IS_ENABLED.matches((Tree)right, this.state) && FloggerRedundantIsEnabled.sameLoggerAtSameLevel(this.logInvocation, right, this.state)) {
                this.fix = Optional.of(SuggestedFix.replace((Tree)binaryTree, (String)this.state.getSourceForNode((Tree)binaryTree.getLeftOperand())));
                return null;
            }
            return (Void)super.visitBinary(binaryTree, null);
        }
    }
}

