/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.instrument;

import com.google.caliper.bridge.ExperimentSpec;
import com.google.caliper.core.Running;
import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.InstrumentType;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.Util;
import com.google.caliper.worker.instrument.ArbitraryMeasurementWorkerInstrument;
import com.google.caliper.worker.instrument.BenchmarkCreator;
import com.google.caliper.worker.instrument.InstrumentTypeKey;
import com.google.caliper.worker.instrument.MacrobenchmarkWorkerInstrument;
import com.google.caliper.worker.instrument.RuntimeWorkerInstrument;
import com.google.caliper.worker.instrument.WorkerInstrument;
import com.google.common.base.Function;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import dagger.multibindings.IntoMap;
import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Provider;

@Module
public abstract class WorkerInstrumentModule {
    private static final ImmutableMap<String, Class<?>> PRIMITIVE_TYPES = Maps.uniqueIndex((Iterable)Primitives.allPrimitiveTypes(), (Function)new Function<Class<?>, String>(){

        public String apply(Class<?> input) {
            return input.getName();
        }
    });

    private WorkerInstrumentModule() {
    }

    @Provides
    static BenchmarkSpec provideBenchmarkSpec(ExperimentSpec experiment) {
        return experiment.benchmarkSpec();
    }

    @Provides
    @Running.Benchmark
    static Object provideBenchmarkInstance(BenchmarkCreator creator) {
        return creator.createBenchmarkInstance();
    }

    @Provides
    @Reusable
    @Running.BenchmarkMethod
    static Method provideBenchmarkMethod(ExperimentSpec experiment, BenchmarkSpec benchmarkSpec, @Running.BenchmarkClass Class<?> benchmarkClass) {
        Method method = WorkerInstrumentModule.findBenchmarkMethod(benchmarkClass, benchmarkSpec.methodName(), (ImmutableList<String>)experiment.methodParameterClasses());
        method.setAccessible(true);
        return method;
    }

    @Provides
    @Running.BenchmarkMethod
    static String provideBenchmarkMethodName(@Running.BenchmarkMethod Method benchmarkMethod) {
        return benchmarkMethod.getName();
    }

    @Provides
    @Running.Benchmark
    static ImmutableSortedMap<String, String> provideUserParameters(BenchmarkSpec spec) {
        return spec.parameters();
    }

    @Provides
    static InstrumentType provideInstrumentType(ExperimentSpec experiment) {
        return experiment.instrumentType();
    }

    @Provides
    @WorkerInstrument.Options
    static Map<String, String> provideWorkerInstrumentOptions(ExperimentSpec experiment) {
        return experiment.workerInstrumentOptions();
    }

    @Provides
    static WorkerInstrument provideWorkerInstrument(InstrumentType instrumentType, Map<InstrumentType, Provider<WorkerInstrument>> availableWorkerInstruments) {
        Provider<WorkerInstrument> workerInstrumentProvider = availableWorkerInstruments.get(instrumentType);
        if (workerInstrumentProvider == null) {
            throw new InvalidCommandException("%s is not a supported instrument type (%s).", new Object[]{instrumentType, availableWorkerInstruments});
        }
        return (WorkerInstrument)workerInstrumentProvider.get();
    }

    @Binds
    @IntoMap
    @InstrumentTypeKey(value=InstrumentType.ARBITRARY_MEASUREMENT)
    abstract WorkerInstrument bindArbitraryMeasurementWorkerInstrument(ArbitraryMeasurementWorkerInstrument var1);

    @Binds
    @IntoMap
    @InstrumentTypeKey(value=InstrumentType.RUNTIME_MACRO)
    abstract WorkerInstrument bindMacrobenchmarkWorkerInstrument(MacrobenchmarkWorkerInstrument var1);

    @Binds
    @IntoMap
    @InstrumentTypeKey(value=InstrumentType.RUNTIME_MICRO)
    abstract WorkerInstrument bindRuntimeWorkerInstrumentMicro(RuntimeWorkerInstrument.Micro var1);

    @Binds
    @IntoMap
    @InstrumentTypeKey(value=InstrumentType.RUNTIME_PICO)
    abstract WorkerInstrument bindRuntimeWorkerInstrumentPico(RuntimeWorkerInstrument.Pico var1);

    @Provides
    static Ticker provideTicker() {
        return Ticker.systemTicker();
    }

    private static Method findBenchmarkMethod(Class<?> benchmark, String methodName, ImmutableList<String> methodParameterClasses) {
        Class[] params = new Class[methodParameterClasses.size()];
        for (int i = 0; i < methodParameterClasses.size(); ++i) {
            try {
                String typeName = (String)methodParameterClasses.get(i);
                Class primitiveType = (Class)PRIMITIVE_TYPES.get((Object)typeName);
                if (primitiveType != null) {
                    params[i] = primitiveType;
                    continue;
                }
                params[i] = Util.loadClass((String)typeName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return benchmark.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

