/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.AfterExperiment;
import com.google.caliper.BeforeExperiment;
import com.google.caliper.core.Running;
import com.google.caliper.util.Reflection;
import com.google.caliper.worker.WorkerOptionsModule;
import com.google.caliper.worker.handler.RequestHandlerModule;
import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import java.lang.reflect.Method;
import java.util.Random;
import javax.inject.Singleton;

@Module(includes={WorkerOptionsModule.class, RequestHandlerModule.class})
abstract class WorkerModule {
    private WorkerModule() {
    }

    @Provides
    @Singleton
    static Random provideRandom() {
        return new Random();
    }

    @Provides
    @Reusable
    @Running.BeforeExperimentMethods
    static ImmutableSet<Method> provideBeforeExperimentMethods(@Running.BenchmarkClass Class<?> benchmarkClass) {
        return Reflection.getAnnotatedMethods(benchmarkClass, BeforeExperiment.class);
    }

    @Provides
    @Reusable
    @Running.AfterExperimentMethods
    static ImmutableSet<Method> provideAfterExperimentMethods(@Running.BenchmarkClass Class<?> benchmarkClass) {
        return Reflection.getAnnotatedMethods(benchmarkClass, AfterExperiment.class);
    }
}

