/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.bridge.FailureLogMessage;
import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.worker.connection.ClientConnectionService;
import com.google.caliper.worker.handler.RequestDispatcher;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;

final class Worker {
    private final ClientConnectionService clientConnection;
    private final RequestDispatcher requestDispatcher;

    @Inject
    Worker(ClientConnectionService clientConnection, RequestDispatcher requestDispatcher) {
        this.clientConnection = clientConnection;
        this.requestDispatcher = requestDispatcher;
    }

    public void run() throws IOException {
        this.clientConnection.startAsync().awaitRunning();
        try {
            WorkerRequest request = (WorkerRequest)this.clientConnection.receive();
            this.requestDispatcher.dispatch(request);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.clientConnection.send(new Serializable[]{FailureLogMessage.create((Throwable)e)});
        }
        finally {
            this.clientConnection.stopAsync().awaitTerminated();
        }
    }
}

