/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.PackageSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.RecordComponentSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.processing.ClassHierarchy;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.processing.TurbineTypeMirror;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Element;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeMirror;

public class ModelFactory {
    public Env<ClassSymbol, ? extends TypeBoundClass> env;
    private final AtomicInteger round = new AtomicInteger(0);
    private final HashMap<Type, TurbineTypeMirror> typeCache = new HashMap();
    private final Map<FieldSymbol, TurbineElement.TurbineFieldElement> fieldCache = new HashMap<FieldSymbol, TurbineElement.TurbineFieldElement>();
    private final Map<MethodSymbol, TurbineElement.TurbineExecutableElement> methodCache = new HashMap<MethodSymbol, TurbineElement.TurbineExecutableElement>();
    private final Map<ClassSymbol, TurbineElement.TurbineTypeElement> classCache = new HashMap<ClassSymbol, TurbineElement.TurbineTypeElement>();
    private final Map<ParamSymbol, TurbineElement.TurbineParameterElement> paramCache = new HashMap<ParamSymbol, TurbineElement.TurbineParameterElement>();
    private final Map<RecordComponentSymbol, TurbineElement.TurbineRecordComponentElement> recordComponentCache = new HashMap<RecordComponentSymbol, TurbineElement.TurbineRecordComponentElement>();
    private final Map<TyVarSymbol, TurbineElement.TurbineTypeParameterElement> tyParamCache = new HashMap<TyVarSymbol, TurbineElement.TurbineTypeParameterElement>();
    private final Map<PackageSymbol, TurbineElement.TurbinePackageElement> packageCache = new HashMap<PackageSymbol, TurbineElement.TurbinePackageElement>();
    private final HashMap<CharSequence, ClassSymbol> inferSymbolCache = new HashMap();
    private final ClassHierarchy cha;
    private final ClassLoader processorLoader;
    private TopLevelIndex tli;

    public void round(CompoundEnv<ClassSymbol, TypeBoundClass> env, TopLevelIndex tli) {
        this.env = env;
        this.tli = tli;
        this.round.getAndIncrement();
        this.cha.round(env);
    }

    public ModelFactory(Env<ClassSymbol, ? extends TypeBoundClass> env, ClassLoader processorLoader, TopLevelIndex tli) {
        this.env = Objects.requireNonNull(env);
        this.cha = new ClassHierarchy(env);
        this.processorLoader = Objects.requireNonNull(processorLoader);
        this.tli = Objects.requireNonNull(tli);
    }

    TypeMirror asTypeMirror(Type type) {
        return this.typeCache.computeIfAbsent(type, this::createTypeMirror);
    }

    <T> Supplier<T> memoize(final Supplier<T> s) {
        return new Supplier<T>(){
            T v;
            int initializedInRound = -1;

            public T get() {
                int r = ModelFactory.this.round.get();
                if (this.initializedInRound != r) {
                    this.v = s.get();
                    this.initializedInRound = r;
                }
                return this.v;
            }
        };
    }

    private TurbineTypeMirror createTypeMirror(Type type) {
        switch (type.tyKind()) {
            case PRIM_TY: {
                if (((Type.PrimTy)type).primkind() == TurbineConstantTypeKind.STRING) {
                    return new TurbineTypeMirror.TurbineDeclaredType(this, Type.ClassTy.STRING);
                }
                return new TurbineTypeMirror.TurbinePrimitiveType(this, (Type.PrimTy)type);
            }
            case CLASS_TY: {
                return new TurbineTypeMirror.TurbineDeclaredType(this, (Type.ClassTy)type);
            }
            case ARRAY_TY: {
                return new TurbineTypeMirror.TurbineArrayType(this, (Type.ArrayTy)type);
            }
            case VOID_TY: {
                return new TurbineTypeMirror.TurbineVoidType(this);
            }
            case WILD_TY: {
                return new TurbineTypeMirror.TurbineWildcardType(this, (Type.WildTy)type);
            }
            case TY_VAR: {
                return new TurbineTypeMirror.TurbineTypeVariable(this, (Type.TyVar)type);
            }
            case INTERSECTION_TY: {
                Type.IntersectionTy intersectionTy = (Type.IntersectionTy)type;
                switch (intersectionTy.bounds().size()) {
                    case 0: {
                        return this.createTypeMirror(Type.ClassTy.OBJECT);
                    }
                    case 1: {
                        return this.createTypeMirror((Type)Iterables.getOnlyElement(intersectionTy.bounds()));
                    }
                }
                return new TurbineTypeMirror.TurbineIntersectionType(this, intersectionTy);
            }
            case NONE_TY: {
                return new TurbineTypeMirror.TurbineNoType(this);
            }
            case METHOD_TY: {
                return new TurbineTypeMirror.TurbineExecutableType(this, (Type.MethodTy)type);
            }
            case ERROR_TY: {
                return new TurbineTypeMirror.TurbineErrorType(this, (Type.ErrorTy)type);
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    ImmutableList<TypeMirror> asTypeMirrors(Iterable<? extends Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)this.asTypeMirror(type));
        }
        return result.build();
    }

    NoType noType() {
        return (NoType)this.asTypeMirror(Type.NONE);
    }

    NoType packageType(PackageSymbol symbol) {
        return new TurbineTypeMirror.TurbinePackageType(this, symbol);
    }

    public NullType nullType() {
        return new TurbineTypeMirror.TurbineNullType(this);
    }

    Element element(Symbol symbol) {
        switch (symbol.symKind()) {
            case CLASS: {
                return this.typeElement((ClassSymbol)symbol);
            }
            case TY_PARAM: {
                return this.typeParameterElement((TyVarSymbol)symbol);
            }
            case METHOD: {
                return this.executableElement((MethodSymbol)symbol);
            }
            case FIELD: {
                return this.fieldElement((FieldSymbol)symbol);
            }
            case PARAMETER: {
                return this.parameterElement((ParamSymbol)symbol);
            }
            case RECORD_COMPONENT: {
                return this.recordComponentElement((RecordComponentSymbol)symbol);
            }
            case PACKAGE: {
                return this.packageElement((PackageSymbol)symbol);
            }
        }
        throw new AssertionError((Object)symbol.symKind());
    }

    Element noElement(String name) {
        return new TurbineElement.TurbineNoTypeElement(this, name);
    }

    TurbineElement.TurbineFieldElement fieldElement(FieldSymbol symbol) {
        return this.fieldCache.computeIfAbsent(symbol, k -> new TurbineElement.TurbineFieldElement(this, symbol));
    }

    TurbineElement.TurbineExecutableElement executableElement(MethodSymbol symbol) {
        return this.methodCache.computeIfAbsent(symbol, k -> new TurbineElement.TurbineExecutableElement(this, symbol));
    }

    public TurbineElement.TurbineTypeElement typeElement(ClassSymbol symbol) {
        Verify.verify((!symbol.simpleName().equals("package-info") ? 1 : 0) != 0, (String)"%s", (Object)symbol);
        return this.classCache.computeIfAbsent(symbol, k -> new TurbineElement.TurbineTypeElement(this, symbol));
    }

    TurbineElement.TurbinePackageElement packageElement(PackageSymbol symbol) {
        return this.packageCache.computeIfAbsent(symbol, k -> new TurbineElement.TurbinePackageElement(this, symbol));
    }

    VariableElement parameterElement(ParamSymbol sym) {
        return this.paramCache.computeIfAbsent(sym, k -> new TurbineElement.TurbineParameterElement(this, sym));
    }

    RecordComponentElement recordComponentElement(RecordComponentSymbol sym) {
        return this.recordComponentCache.computeIfAbsent(sym, k -> new TurbineElement.TurbineRecordComponentElement(this, sym));
    }

    TurbineElement.TurbineTypeParameterElement typeParameterElement(TyVarSymbol sym) {
        return this.tyParamCache.computeIfAbsent(sym, k -> new TurbineElement.TurbineTypeParameterElement(this, sym));
    }

    ImmutableSet<Element> elements(ImmutableSet<? extends Symbol> symbols) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Symbol symbol : symbols) {
            result.add((Object)this.element(symbol));
        }
        return result.build();
    }

    public ClassSymbol inferSymbol(CharSequence name) {
        return this.inferSymbolCache.computeIfAbsent(name, key -> this.inferSymbolImpl(name));
    }

    private ClassSymbol inferSymbolImpl(CharSequence name) {
        LookupResult lookup = this.tli.scope().lookup(new LookupKey(ModelFactory.asIdents(name)));
        if (lookup == null) {
            return null;
        }
        ClassSymbol sym = (ClassSymbol)lookup.sym();
        for (Tree.Ident bit : lookup.remaining()) {
            if ((sym = (ClassSymbol)this.getSymbol(sym).children().get((Object)bit.value())) != null) continue;
            return null;
        }
        return sym;
    }

    private static ImmutableList<Tree.Ident> asIdents(CharSequence name) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String bit : Splitter.on((char)'.').split(name)) {
            result.add((Object)new Tree.Ident(-1, bit));
        }
        return result.build();
    }

    TypeBoundClass getSymbol(ClassSymbol sym) {
        return this.env.get(sym);
    }

    TypeBoundClass.MethodInfo getMethodInfo(MethodSymbol method) {
        TypeBoundClass info = this.getSymbol(method.owner());
        for (TypeBoundClass.MethodInfo m : info.methods()) {
            if (!m.sym().equals(method)) continue;
            return m;
        }
        return null;
    }

    TypeBoundClass.ParamInfo getParamInfo(ParamSymbol sym) {
        TypeBoundClass.MethodInfo info = this.getMethodInfo(sym.owner());
        for (TypeBoundClass.ParamInfo p : info.parameters()) {
            if (!p.sym().equals(sym)) continue;
            return p;
        }
        return null;
    }

    TypeBoundClass.RecordComponentInfo getRecordComponentInfo(RecordComponentSymbol sym) {
        TypeBoundClass info = this.getSymbol(sym.owner());
        for (TypeBoundClass.RecordComponentInfo component : info.components()) {
            if (!component.sym().equals(sym)) continue;
            return component;
        }
        return null;
    }

    TypeBoundClass.FieldInfo getFieldInfo(FieldSymbol symbol) {
        TypeBoundClass info = this.getSymbol(symbol.owner());
        Objects.requireNonNull(info, symbol.owner().toString());
        for (TypeBoundClass.FieldInfo field : info.fields()) {
            if (!field.sym().equals(symbol)) continue;
            return field;
        }
        throw new AssertionError(symbol);
    }

    TypeBoundClass.TyVarInfo getTyVarInfo(TyVarSymbol tyVar) {
        Symbol owner = tyVar.owner();
        Verify.verifyNotNull((Object)owner);
        return (TypeBoundClass.TyVarInfo)(switch (owner.symKind()) {
            case Symbol.Kind.METHOD -> this.getMethodInfo((MethodSymbol)owner).tyParams();
            case Symbol.Kind.CLASS -> this.getSymbol((ClassSymbol)owner).typeParameterTypes();
            default -> throw new AssertionError((Object)owner.symKind());
        }).get((Object)tyVar);
    }

    static ClassSymbol enclosingClass(Symbol sym) {
        switch (sym.symKind()) {
            case CLASS: {
                return (ClassSymbol)sym;
            }
            case TY_PARAM: {
                return ModelFactory.enclosingClass(((TyVarSymbol)sym).owner());
            }
            case METHOD: {
                return ((MethodSymbol)sym).owner();
            }
            case FIELD: {
                return ((FieldSymbol)sym).owner();
            }
            case PARAMETER: {
                return ((ParamSymbol)sym).owner().owner();
            }
            case RECORD_COMPONENT: {
                return ((RecordComponentSymbol)sym).owner();
            }
            case PACKAGE: 
            case MODULE: {
                throw new IllegalArgumentException(sym.toString());
            }
        }
        throw new AssertionError((Object)sym.symKind());
    }

    ClassHierarchy cha() {
        return this.cha;
    }

    ClassLoader processorLoader() {
        return this.processorLoader;
    }

    TopLevelIndex tli() {
        return this.tli;
    }
}

