/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.truth.extensions.proto.AnyUtils;
import com.google.common.truth.extensions.proto.SubScopeId;
import com.google.common.truth.extensions.proto.UnknownFieldDescriptor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.UnknownFieldSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldNumberTree {
    private static final FieldNumberTree EMPTY = new FieldNumberTree();
    private final Map<SubScopeId, FieldNumberTree> children = Maps.newHashMap();

    FieldNumberTree() {
    }

    static FieldNumberTree empty() {
        return EMPTY;
    }

    boolean isEmpty() {
        return this.children.isEmpty();
    }

    FieldNumberTree child(SubScopeId subScopeId) {
        FieldNumberTree child = this.children.get(subScopeId);
        return child == null ? EMPTY : child;
    }

    boolean hasChild(SubScopeId subScopeId) {
        return this.children.containsKey(subScopeId);
    }

    static FieldNumberTree fromMessage(Message message, TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        FieldNumberTree tree = new FieldNumberTree();
        Map knownFieldValues = message.getAllFields();
        for (Descriptors.FieldDescriptor field : knownFieldValues.keySet()) {
            SubScopeId subScopeId = SubScopeId.of(field);
            FieldNumberTree childTree = new FieldNumberTree();
            tree.children.put(subScopeId, childTree);
            if (field.equals(AnyUtils.valueFieldDescriptor())) {
                Optional<Message> unpackedAny = AnyUtils.unpack(message, typeRegistry, extensionRegistry);
                if (!unpackedAny.isPresent()) continue;
                tree.children.put(SubScopeId.ofUnpackedAnyValueType(((Message)unpackedAny.get()).getDescriptorForType()), FieldNumberTree.fromMessage((Message)unpackedAny.get(), typeRegistry, extensionRegistry));
                continue;
            }
            Object fieldValue = knownFieldValues.get(field);
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field.isRepeated()) {
                List valueList = (List)fieldValue;
                for (Object value : valueList) {
                    childTree.merge(FieldNumberTree.fromMessage((Message)value, typeRegistry, extensionRegistry));
                }
                continue;
            }
            childTree.merge(FieldNumberTree.fromMessage((Message)fieldValue, typeRegistry, extensionRegistry));
        }
        tree.merge(FieldNumberTree.fromUnknownFieldSet(message.getUnknownFields()));
        return tree;
    }

    static FieldNumberTree fromMessages(Iterable<? extends Message> messages, TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        FieldNumberTree tree = new FieldNumberTree();
        for (Message message : messages) {
            if (message == null) continue;
            tree.merge(FieldNumberTree.fromMessage(message, typeRegistry, extensionRegistry));
        }
        return tree;
    }

    private static FieldNumberTree fromUnknownFieldSet(UnknownFieldSet unknownFieldSet) {
        FieldNumberTree tree = new FieldNumberTree();
        Iterator iterator = unknownFieldSet.asMap().keySet().iterator();
        while (iterator.hasNext()) {
            int fieldNumber = (Integer)iterator.next();
            UnknownFieldSet.Field unknownField = (UnknownFieldSet.Field)unknownFieldSet.asMap().get(fieldNumber);
            for (UnknownFieldDescriptor unknownFieldDescriptor : UnknownFieldDescriptor.descriptors(fieldNumber, unknownField)) {
                SubScopeId subScopeId = SubScopeId.of(unknownFieldDescriptor);
                FieldNumberTree childTree = new FieldNumberTree();
                tree.children.put(subScopeId, childTree);
                if (unknownFieldDescriptor.type() != UnknownFieldDescriptor.Type.GROUP) continue;
                for (Object group : unknownFieldDescriptor.type().getValues(unknownField)) {
                    childTree.merge(FieldNumberTree.fromUnknownFieldSet((UnknownFieldSet)group));
                }
            }
        }
        return tree;
    }

    private void merge(FieldNumberTree other) {
        for (SubScopeId subScopeId : other.children.keySet()) {
            FieldNumberTree value = other.children.get(subScopeId);
            if (!this.children.containsKey(subScopeId)) {
                this.children.put(subScopeId, value);
                continue;
            }
            this.children.get(subScopeId).merge(value);
        }
    }
}

