#!/bin/sh

RPMBUILDDIR="rpmbuild"
PYTHONEXE="python3"
REQUIREMENTS="contrib/packaging/venv_py3/requirements.txt"

while [ "$1" ]; do
    case "$1" in
    --rpmbuilddir )
        shift
        RPMBUILDDIR="$1"
        shift
        ;;
    --installhg )
        shift
        HGRPM="$1"
        shift
        ;;
    --python )
        shift
        PYTHONEXE="$1"
        shift
        ;;
    --requirements )
        shift
        REQUIREMENTS="$1"
        shift
        ;;
    --arch-dependent )
        ARCH_DEPENDENT=1
        shift
        ;;
    --platform )
        shift
        PLATFORM="$1"
        shift
        ;;
    * )
       	echo "Invalid parameter $1!" 1>&2
        exit 1
        ;;
    esac
done

if [ ! -z "$HGRPM" ]; then
	sudo rpm -i $HGRPM
fi

if [ "$PLATFORM" == "rhel9" ]; then
	SPEC_FILE="tortoisehg-rhel9.spec"
else
	SPEC_FILE="tortoisehg.spec"
fi

mkdir -p ${RPMBUILDDIR}/{SOURCES,BUILD,RPMS,SRPMS,SPECS}
version=$(hg parents --template '{sub(r".*:", "", latesttag)}+{latesttagdistance}')
if [ $(expr "$version" : '.*+0$') -ne 0 ]; then
  # We are on a tagged version
  version=$(expr "$version" : '\(.*\)+0$')
  release='1'
else
  release=$(hg parents --template '{node|short}')
fi

hg archive -t tgz ${RPMBUILDDIR}/SOURCES/tortoisehg-$version.tar.gz
sed -e "s,^Version:.*,Version: $version," \
    -e "s,^Release:.*,Release: $release," \
    -e "s/^%define __python .*/%define __python $PYTHONEXE/" \
    -e "s,^%define requirements_txt .*,%define requirements_txt $REQUIREMENTS," \
    $(dirname $0)/${SPEC_FILE} > ${RPMBUILDDIR}/SPECS/tortoisehg.spec

if [ "${ARCH_DEPENDENT}" == "1" ]; then
  sed -i -e "s/^%define _archdependent .*/%define _archdependent 1/" ${RPMBUILDDIR}/SPECS/tortoisehg.spec
fi

rpmbuild --define "_topdir $(pwd)/${RPMBUILDDIR}" -ba ${RPMBUILDDIR}/SPECS/tortoisehg.spec || exit 1

rm -rf ${RPMBUILDDIR}/BUILD/
ls -l ${RPMBUILDDIR}/{RPMS/*,SRPMS}/tortoisehg-*.rpm
