# q

> 在 CSV 和 TSV 文件上执行类似 SQL 的查询。
> 更多信息：<https://harelba.github.io/q>.

- 指定分隔符为 ',' 来查询 CSV 文件：

`q -d',' "SELECT * from {{路径/到/文件}}"`

- 查询 TSV 文件：

`q -t "SELECT * from {{路径/到/文件}}"`

- 查询带有表头行的文件：

`q -d{{分隔符}} -H "SELECT * from {{路径/到/文件}}"`

- 从 `stdin` 读取数据；查询中的 '-' 代表来自 `stdin` 的数据：

`{{输出}} | q "select * from -"`

- 在列 `c1` 上连接两个文件（在例子中别名为 `f1` 和 `f2`）：

`q "SELECT * FROM {{路径/到/文件1}} f1 JOIN {{路径/到/文件2}} f2 ON (f1.c1 = f2.c1)"`

- 使用包含输出标题行的输出分隔符来格式化输出（注意：命令将根据输入文件标题或在查询中覆盖的列别名输出列名）：

`q -D{{分隔符}} -O "SELECT {{列}} as {{别名}} from {{路径/到/文件}}"`
