# ssh

> Secure Shell (SSH) — это протокол для безопасного входа на удаленные системы.
> Его можно использовать для входа или выполнения команд на удаленном сервере.
> Больше информации: <https://man.openbsd.org/ssh>.

- Подключиться к удаленному серверу:

`ssh {{имя_пользователя}}@{{удаленный_хост}}`

- Подключиться к удаленному серверу с использованием определенного приватного ключа:

`ssh -i {{путь/к/файлу_ключа}} {{имя_пользователя}}@{{удаленный_хост}}`

- Подключиться к удаленному серверу с IP-адресом 10.0.0.1, используя определенный порт [p]:

`ssh {{имя_пользователя}}@10.0.0.1 -p {{2222}}`

- Запустить команду на удаленном сервере с выделением [t]ty, что позволяет взаимодействовать с удаленной командой:

`ssh {{имя_пользователя}}@{{удаленный_хост}} -t {{команда}} {{аргументы_команды}}`

- SSH-туннелирование: динамическая [D] переадресация портов (SOCKS-прокси на `localhost:1080`):

`ssh -D {{1080}} {{имя_пользователя}}@{{удаленный_хост}}`

- SSH-туннелирование: переадресовать определенный порт (`localhost:9999` на `example.com:80`) с отключением псевдо-[T]ty и выполне[N]ия удаленных команд:

`ssh -L {{9999}}:{{example.com}}:{{80}} -N -T {{имя_пользователя}}@{{удаленный_хост}}`

- SSH-прыжок [J]: подключиться к удаленному серверу через промежуточный хост (можно указать несколько хостов через запятую):

`ssh -J {{имя_пользователя}}@{{промежуточный_хост}} {{имя_пользователя}}@{{удаленный_хост}}`

- Закрыть зависшую сессию:

`<Enter><~><.>`
