# rtl_sdr

> RTL-SDR 수신기를 위한 원시 데이터 기록기.
> 데이터는 I/Q 샘플링(즉, 직교 샘플링)을 사용하여 인코딩됩니다.
> 더 많은 정보: <https://osmocom.org/projects/rtl-sdr/wiki/Rtl-sdr>.

- 주파수(Hz 단위로 지정)에서 RAW 데이터를 파일로 저장:

`rtl_sdr -f {{100000000}} {{경로/대상/파일}}`

- 데이터를 다른 프로그램으로 파이프 처리:

`rtl_sdr -f {{100000000}} - | {{aplay}}`

- 지정된 수의 샘플 읽기:

`rtl_sdr -f {{100000000}} -n {{20}} -`

- 샘플 속도를 Hz 단위로 지정 (범위 225001-300000 및 900001-3200000):

`rtl_sdr -f {{100000000}} -s {{2400000}} -`

- 인덱스로 디바이스 지정:

`rtl_sdr -f {{100000000}} -d {{0}} -`

- 이득(gain) 지정:

`rtl_sdr -f {{100000000}} -g {{20}} -`

- 출력 블록 크기 지정:

`rtl_sdr -f {{100000000}} -b {{9999999}} -`

- 동기 출력 사용:

`rtl_sdr -f {{100000000}} -S -`
