# Mentioning sub-commands

When a command has a sub-command, which can't be covered in the original page, it gets its own page.
An example for this is `git` and it's sub-command pages like `git-commit`, `git-push`, etc.
In order to notify the user that such sub-command pages exist, we put a little notice in the base command's description.
This file contains the translation templates of this notice.

[en](#en) •
[ar](#ar) •
[bn](#bn) •
[bs](#bs) •
[ca](#ca) •
[cs](#cs) •
[da](#da) •
[de](#de) •
[es](#es) •
[fa](#fa) •
[fi](#fi) •
[fr](#fr) •
[hi](#hi) •
[id](#id) •
[it](#it) •
[ja](#ja) •
[ko](#ko) •
[lo](#lo) •
[ml](#ml) •
[ne](#ne) •
[nl](#nl) •
[no](#no) •
[pl](#pl) •
[pt_BR](#pt_br) •
[pt_PT](#pt_pt) •
[ro](#ro) •
[ru](#ru) •
[sh](#sh) •
[sr](#sr) •
[sv](#sv) •
[ta](#ta) •
[th](#th) •
[tr](#tr) •
[uk](#uk) •
[uz](#uz) •
[zh](#zh) •
[zh_TW](#zh_tw)

---

### en

```markdown
Some subcommands such as `example command` have their own usage documentation.
```

---

### ar

```markdown
بعض الأوامر الفرعية لديها توثيقات الاستخدام الخاصة بها مثل: `example command`
```

---

### bn

```markdown
কিছু উপ-কমান্ড যেমন `example command` স্বতন্ত্র ব্যবহার নির্দেশনা রয়েছে।
```

---

### bs

```markdown
Neke podnaredbe kao što je `example command` imaju vlastitu dokumentaciju o korištenju.
```

---

### ca

```markdown
Alguns subcomandaments com `example command` tenen la seva pròpia documentació.
```

---

### cs

```markdown
Některé dílčí příkazy jako je `example command` mají svou vlastní dokumentaci.
```

---

### da

```markdown
Visse underkommandoer såsom `example command` har sin egen dokumentation.
```

---

### de

```markdown
Manche Unterbefehle wie `example command` sind separat dokumentiert.
```

---

### es

```markdown
Algunos subcomandos, como `example command`, tienen su propia documentación de uso.
```

---

### fa

```markdown
برخی از دستورات فرعی مانند `example command` سند استفاده خاص خودشون رو دارند.
```

---

### fi

```markdown
Joillakin alikomennoilla, kuten `example command`, on omat käyttöoppaansa.
```

---

### fr

```markdown
Certaines sous-commandes comme `example command` ont leur propre documentation.
```

---

### hi

```markdown
कुछ कमांड्स जैसे की `example command`, उनके अपने उपयोग प्रलेखन हैं|
```

---

### id

```markdown
Beberapa subperintah seperti `example command` mempunyai dokumentasi terpisah.
```

---

### it

```markdown
Alcuni comandi aggiuntivi, come `example command`, hanno la propria documentazione.
```

---

### ja

```markdown
`example command` のようないくつかのサブコマンドには、使用方法についての独自のドキュメントがあります。
```

---

### ko

```markdown
`example command`와 같은 일부 하위 명령에는 자체 사용 설명서가 있습니다.
```

---

### lo

```markdown
ບາງຄໍາສັ່ງຍ່ອຍເຊັ່ນ `example command` ມີເອກະສານການນໍາໃຊ້ຂອງຕົນເອງ.
```

---

### ml

```markdown
`example command` പോലുള്ള ചില ഉപകമാൻഡുകൾക്ക് അവരുടേതായ ഉപയോഗ ഡോക്യുമെന്റേഷൻ ഉണ്ട്.
```

---

### ne

```markdown
केही उपादेशहरु जस्तै `example command` को आफ्नै प्रयोग कागजात हुन्छ।
```

---

### nl

```markdown
Sommige subcommando's zoals `example command` hebben een eigen documentatie pagina.
```

---

### no

```markdown
Noen underkommandoer som `example command` har sin egen bruksdokumentasjon.
```

---

### pl

```markdown
Niektóre podkomendy takie jak `example command` mają osobną dokumentację.
```

---

### pt_BR

```markdown
Alguns subcomandos como `example command` têm sua própria documentação de uso.
```

---

### pt_PT

```markdown
Alguns subcomandos, como `example command`, tem a sua própria documentação de uso.
```

---

### ro

```markdown
Unele subcomenzi precum `example command` au propria lor documentație de utilizare.
```

---

### ru

```markdown
Некоторые подкоманды, такие как `example command`, имеют собственную документацию по использованию.
```

---

### sh

```markdown
Neke podkomande, kao što je `example command`, imaju svoju dokumentaciju za upotrebu.

```

---

### sr

```markdown
Неке подкоманде као што је `example command` имају своју документацију о коришћењу.
```

---

### sv

```markdown
En del underkommandon som t.ex: `example command` har sin egen användningsdokumentation.
```

---

### ta

```markdown
`example command` போன்ற சிலச் சார்கட்டளைகளுக்குத் தனிப் பக்கம் உள்ளது.
```

---

### th

```markdown
คำสั่งย่อยบางคำสั่ง เช่น `example command` มีเอกสารการใช้งานของตัวเอง
```

---

### tr

```markdown
`example command` gibi bazı alt komutların kendi kullanım belgeleri vardır.
```

---

### uk

```markdown
Певна підкоманда, як от `example command`, що має свою власну документацію.
```

---

### uz

```markdown
`example command` kabi baʼzi kichik buyruqlar oʻzlarining foydalanish hujjatlariga ega.
```

---

### zh

```markdown
此命令也有关于其子命令的文件，例如：`example command`.
```

---

### zh_TW

```markdown
此命令也有關於其子命令的文件，例如：`example command`.
```
