/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.core;

import java.util.ArrayList;
import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.cli.command.AbstractCommand;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.HelpExample;
import org.springframework.boot.cli.command.NoHelpCommandArgumentsException;
import org.springframework.boot.cli.command.NoSuchCommandException;
import org.springframework.boot.cli.command.core.HintCommand;
import org.springframework.boot.cli.command.options.OptionHelp;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;

public class HelpCommand
extends AbstractCommand {
    private final CommandRunner commandRunner;

    public HelpCommand(CommandRunner commandRunner) {
        super("help", "Get help on commands");
        this.commandRunner = commandRunner;
    }

    public String getUsageHelp() {
        return "command";
    }

    public @Nullable String getHelp() {
        return null;
    }

    public Collection<OptionHelp> getOptionsHelp() {
        ArrayList<OptionHelp> help = new ArrayList<OptionHelp>();
        for (Command command : this.commandRunner) {
            if (!this.isHelpShown(command)) continue;
            help.add((OptionHelp)new /* Unavailable Anonymous Inner Class!! */);
        }
        return help;
    }

    private boolean isHelpShown(Command command) {
        return !(command instanceof HelpCommand) && !(command instanceof HintCommand);
    }

    public ExitStatus run(String ... args) throws Exception {
        if (args.length == 0) {
            throw new NoHelpCommandArgumentsException();
        }
        String commandName = args[0];
        for (Command command : this.commandRunner) {
            Collection examples;
            if (!command.getName().equals(commandName)) continue;
            Log.info((String)(this.commandRunner.getName() + command.getName() + " - " + command.getDescription()));
            Log.info((String)"");
            if (command.getUsageHelp() != null) {
                Log.info((String)("usage: " + this.commandRunner.getName() + command.getName() + " " + command.getUsageHelp()));
                Log.info((String)"");
            }
            if (command.getHelp() != null) {
                Log.info((String)command.getHelp());
            }
            if ((examples = command.getExamples()) != null) {
                Log.info((String)(examples.size() != 1 ? "examples:" : "example:"));
                Log.info((String)"");
                for (HelpExample example : examples) {
                    Log.info((String)("    " + example.getDescription() + ":"));
                    Log.info((String)("        $ " + example.getExample()));
                    Log.info((String)"");
                }
                Log.info((String)"");
            }
            return ExitStatus.OK;
        }
        throw new NoSuchCommandException(commandName);
    }
}

