/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.shared.models.Payload;
import com.azul.crs.shared.models.VMArtifact;
import com.azul.crs.shared.models.VMInstance;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class VMEvent<T>
extends Payload {
    private String vmId;
    private String eventId;
    private Type eventType;
    private Long eventTime;
    private T eventPayload;

    public String getVmId() {
        return this.vmId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Long getEventTime() {
        return this.eventTime;
    }

    public T getEventPayload() {
        return this.eventPayload;
    }

    public void setVmId(String vmId) {
        this.vmId = vmId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setEventTime(Long eventTime) {
        this.eventTime = eventTime;
    }

    public void setEventType(Type eventType) {
        if (this.eventPayload != null && !eventType.payloadClass().isAssignableFrom(this.eventPayload.getClass())) {
            throw new IllegalArgumentException("Event type inconsistent with event payload type");
        }
        this.eventType = eventType;
    }

    public void setEventPayload(T eventPayload) {
        if (this.eventType != null && !this.eventType.payloadClass().isAssignableFrom(eventPayload.getClass())) {
            throw new IllegalArgumentException("Event payload type inconsistent with event type ");
        }
        this.eventPayload = eventPayload;
    }

    public VMEvent<T> vmId(String vmId) {
        this.setVmId(vmId);
        return this;
    }

    public VMEvent<T> eventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public VMEvent<T> randomEventId() {
        this.setEventId(UUID.randomUUID().toString());
        return this;
    }

    public VMEvent<T> eventType(Type eventType) {
        this.setEventType(eventType);
        return this;
    }

    public VMEvent<T> eventType(String eventType) {
        this.setEventType(Type.valueOf(eventType));
        return this;
    }

    public VMEvent<T> eventTime(Long eventTime) {
        this.setEventTime(eventTime);
        return this;
    }

    public VMEvent<T> eventPayload(T eventPayload) {
        this.setEventPayload(eventPayload);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VMEvent vmEvent = (VMEvent)o;
        return Objects.equals(this.vmId, vmEvent.vmId) && Objects.equals(this.eventId, vmEvent.eventId) && this.eventType == vmEvent.eventType && Objects.equals(this.eventTime, vmEvent.eventTime) && Objects.equals(this.eventPayload, vmEvent.eventPayload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vmId, this.eventId, this.eventType, this.eventTime, this.eventPayload});
    }

    @Override
    public String toString() {
        return "vmId=" + this.vmId + ", eventId=" + this.eventId + ", eventType=" + (Object)((Object)this.eventType) + ", eventTime=" + this.eventTime + ", eventPayload=" + this.eventPayload;
    }

    public static enum Type {
        VM_CREATE(VMInstance.class),
        VM_PATCH(VMInstance.class),
        VM_ARTIFACT_CREATE(VMArtifact.class),
        VM_ARTIFACT_PATCH(VMArtifact.class),
        VM_ARTIFACT_DATA(Map.class),
        VM_HEARTBEAT(Void.class),
        VM_SHUTDOWN(Void.class),
        VM_CLASS_LOADED(Map.class),
        VM_METHOD_FIRST_CALLED(Map.class),
        VM_PERFORMANCE_METRICS(Map.class);

        private final Class payloadClass;

        private Type(Class payloadClass) {
            this.payloadClass = payloadClass;
        }

        public Class payloadClass() {
            return this.payloadClass;
        }

        public static Type eventType(String type) {
            return type != null ? Type.valueOf(type.toUpperCase()) : null;
        }
    }
}

