/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.service.FileTailer;
import com.azul.crs.client.service.FileTailerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class GCRotatingLogTailer
extends FileTailer {
    private static final String CURRENT = "current";
    private long startTime;
    private int logCount;

    protected GCRotatingLogTailer(String serviceName, File file, FileTailerListener listener, long delayTimeout, boolean completeOnStop, int bufSize, int logCount, long startTime) {
        super(serviceName, file, listener, delayTimeout, false, completeOnStop, bufSize);
        this.logCount = logCount;
        this.startTime = startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        FileInputStream reader = null;
        try {
            String logName = this.file.getPath();
            int logNum = 0;
            File logFile = null;
            long checkTime = this.startTime;
            this.logger().info("looking for current file of GC log %s", logName);
            while (this.running) {
                try {
                    logNum = 0;
                    logFile = new File(String.format("%s.%d.%s", logName, logNum, CURRENT));
                    if (logFile.lastModified() > checkTime) {
                        reader = new FileInputStream(logFile);
                        checkTime = logFile.lastModified();
                        this.readBytes(reader);
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    this.listener.fileNotFound();
                }
                logNum = (logNum + 1) % this.logCount;
                Thread.sleep(this.delayTimeout / (long)this.logCount);
            }
            this.logger().info("tailing GC log starting from file %s", logFile.getName());
            while (this.running) {
                this.readBytes(reader);
                if (!logFile.exists()) {
                    while (this.running) {
                        Throwable throwable;
                        FileInputStream saved2;
                        logNum = (logNum + 1) % this.logCount;
                        logFile = new File(String.format("%s.%d.%s", logName, logNum, CURRENT));
                        if (logFile.lastModified() > checkTime) {
                            try {
                                saved2 = reader;
                                throwable = null;
                                try {
                                    reader = new FileInputStream(logFile);
                                    checkTime = logFile.lastModified();
                                    this.listener.fileRotated("current log number " + logNum);
                                    this.readBytes(reader);
                                    break;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (saved2 != null) {
                                        if (throwable != null) {
                                            try {
                                                saved2.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                        } else {
                                            saved2.close();
                                        }
                                    }
                                }
                            }
                            catch (FileNotFoundException saved2) {
                                // empty catch block
                            }
                        }
                        if ((logFile = new File(String.format("%s.%d", logName, logNum))).lastModified() > checkTime) {
                            try {
                                saved2 = reader;
                                throwable = null;
                                try {
                                    reader = new FileInputStream(logFile);
                                    checkTime = logFile.lastModified();
                                    this.listener.fileRotated("next log number " + logNum);
                                    this.readBytes(reader);
                                    continue;
                                }
                                catch (Throwable throwable4) {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (saved2 == null) continue;
                                    if (throwable != null) {
                                        try {
                                            saved2.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    saved2.close();
                                    continue;
                                }
                            }
                            catch (FileNotFoundException e) {
                                this.listener.fileNotFound();
                            }
                        }
                        logNum = (logNum - 1) % this.logCount;
                    }
                }
                Thread.sleep(this.delayTimeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.listener.interrupted();
        }
        catch (Exception e) {
            this.listener.handle(e);
        }
        finally {
            this.closeReader(reader);
            this.running = false;
        }
    }

    public static class Builder
    extends FileTailer.Builder<Builder> {
        private int logCount;
        private long startTime;

        public Builder(File file) {
            super(file);
        }

        public Builder logCount(int logCount) {
            this.logCount = logCount;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public GCRotatingLogTailer build() {
            return new GCRotatingLogTailer(this.serviceName, this.file, this.listener, this.delayTimeout, this.completeOnStop, this.bufSize, this.logCount, this.startTime);
        }
    }
}

