/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultTrackingFileManager
implements TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTrackingFileManager.class);

    @Override
    @Deprecated
    public Properties read(File file) {
        return this.read(file.toPath());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties read(Path path) {
        if (Files.isReadable(path)) {
            Object object = this.getMutex(path);
            synchronized (object) {
                try {
                    long fileSize = Files.size(path);
                    try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
                        Properties properties;
                        block18: {
                            FileLock unused = this.fileLock(fileChannel, Math.max(1L, fileSize), true);
                            try {
                                Properties props = new Properties();
                                props.load(Channels.newInputStream(fileChannel));
                                properties = props;
                                if (unused == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (unused != null) {
                                    try {
                                        unused.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            unused.close();
                        }
                        return properties;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read tracking file '{}'", (Object)path, (Object)e);
                    throw new UncheckedIOException(e);
                }
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Properties update(File file, Map<String, String> updates) {
        return this.update(file.toPath(), updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties update(Path path, Map<String, String> updates) {
        Properties props = new Properties();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create tracking file parent '{}'", (Object)path, (Object)e);
            throw new UncheckedIOException(e);
        }
        Object object = this.getMutex(path);
        synchronized (object) {
            try {
                long fileSize;
                try {
                    fileSize = Files.size(path);
                }
                catch (IOException e) {
                    fileSize = 0L;
                }
                try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                     FileLock unused = this.fileLock(fileChannel, Math.max(1L, fileSize), false);){
                    if (fileSize > 0L) {
                        props.load(Channels.newInputStream(fileChannel));
                    }
                    for (Map.Entry<String, String> update : updates.entrySet()) {
                        if (update.getValue() == null) {
                            props.remove(update.getKey());
                            continue;
                        }
                        props.setProperty(update.getKey(), update.getValue());
                    }
                    LOGGER.debug("Writing tracking file '{}'", (Object)path);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                    props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
                    fileChannel.position(0L);
                    int written = fileChannel.write(ByteBuffer.wrap(stream.toByteArray()));
                    fileChannel.truncate(written);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to write tracking file '{}'", (Object)path, (Object)e);
                throw new UncheckedIOException(e);
            }
        }
        return props;
    }

    private Object getMutex(Path path) {
        return path.toAbsolutePath().normalize().toString().intern();
    }

    private FileLock fileLock(FileChannel channel, long size, boolean shared) throws IOException {
        FileLock lock = null;
        for (int attempts = 8; attempts >= 0; --attempts) {
            try {
                lock = channel.lock(0L, size, shared);
                break;
            }
            catch (OverlappingFileLockException e) {
                if (attempts <= 0) {
                    throw new IOException(e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lock == null) {
            throw new IOException("Could not lock file");
        }
        return lock;
    }
}

